<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_cap_ret_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_cap_ret_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_cap_ret_head.Dept"]["edit"] = array("table" => "ST_Cap_Ret_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_cap_isu_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_cap_isu_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_cap_isu_head.Dept"]["edit"] = array("table" => "ST_Cap_Isu_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["st_cap_isu_item.CategoryID"] )) {
			$lookupTableLinks["Assets_Group"]["st_cap_isu_item.CategoryID"] = array();
		}
		$lookupTableLinks["Assets_Group"]["st_cap_isu_item.CategoryID"]["edit"] = array("table" => "ST_Cap_Isu_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Item"] ) ) {
			$lookupTableLinks["Assets_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Item"]["st_cap_isu_item.Part_ID"] )) {
			$lookupTableLinks["Assets_Item"]["st_cap_isu_item.Part_ID"] = array();
		}
		$lookupTableLinks["Assets_Item"]["st_cap_isu_item.Part_ID"]["edit"] = array("table" => "ST_Cap_Isu_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["st_cap_adj_item.CategoryID"] )) {
			$lookupTableLinks["Assets_Group"]["st_cap_adj_item.CategoryID"] = array();
		}
		$lookupTableLinks["Assets_Group"]["st_cap_adj_item.CategoryID"]["edit"] = array("table" => "ST_Cap_Adj_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Item"] ) ) {
			$lookupTableLinks["Assets_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Item"]["st_cap_adj_item.Part_ID"] )) {
			$lookupTableLinks["Assets_Item"]["st_cap_adj_item.Part_ID"] = array();
		}
		$lookupTableLinks["Assets_Item"]["st_cap_adj_item.Part_ID"]["edit"] = array("table" => "ST_Cap_Adj_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_cap_adj_item.Adj_Type"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_cap_adj_item.Adj_Type"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_cap_adj_item.Adj_Type"]["edit"] = array("table" => "ST_Cap_Adj_Item", "field" => "Adj_Type", "page" => "edit");
		if( !isset( $lookupTableLinks["PI_Imp_A_Head"] ) ) {
			$lookupTableLinks["PI_Imp_A_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PI_Imp_A_Head"]["st_cap_rec_head.Inv_No"] )) {
			$lookupTableLinks["PI_Imp_A_Head"]["st_cap_rec_head.Inv_No"] = array();
		}
		$lookupTableLinks["PI_Imp_A_Head"]["st_cap_rec_head.Inv_No"]["edit"] = array("table" => "ST_Cap_Rec_Head", "field" => "Inv_No", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_Loc_A_Head"] ) ) {
			$lookupTableLinks["PO_Loc_A_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PO_Loc_A_Head"]["st_cap_rec_head.Po_no"] )) {
			$lookupTableLinks["PO_Loc_A_Head"]["st_cap_rec_head.Po_no"] = array();
		}
		$lookupTableLinks["PO_Loc_A_Head"]["st_cap_rec_head.Po_no"]["edit"] = array("table" => "ST_Cap_Rec_Head", "field" => "Po_no", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["st_cap_ret_item.CategoryID"] )) {
			$lookupTableLinks["Assets_Group"]["st_cap_ret_item.CategoryID"] = array();
		}
		$lookupTableLinks["Assets_Group"]["st_cap_ret_item.CategoryID"]["edit"] = array("table" => "ST_Cap_Ret_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Item"] ) ) {
			$lookupTableLinks["Assets_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Item"]["st_cap_ret_item.Part_ID"] )) {
			$lookupTableLinks["Assets_Item"]["st_cap_ret_item.Part_ID"] = array();
		}
		$lookupTableLinks["Assets_Item"]["st_cap_ret_item.Part_ID"]["edit"] = array("table" => "ST_Cap_Ret_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["PI_Imp_C_Head"] ) ) {
			$lookupTableLinks["PI_Imp_C_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PI_Imp_C_Head"]["st_c_rec_head.Inv_No"] )) {
			$lookupTableLinks["PI_Imp_C_Head"]["st_c_rec_head.Inv_No"] = array();
		}
		$lookupTableLinks["PI_Imp_C_Head"]["st_c_rec_head.Inv_No"]["edit"] = array("table" => "ST_C_Rec_Head", "field" => "Inv_No", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_Loc_C_Head"] ) ) {
			$lookupTableLinks["PO_Loc_C_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PO_Loc_C_Head"]["st_c_rec_head.Po_no"] )) {
			$lookupTableLinks["PO_Loc_C_Head"]["st_c_rec_head.Po_no"] = array();
		}
		$lookupTableLinks["PO_Loc_C_Head"]["st_c_rec_head.Po_no"]["edit"] = array("table" => "ST_C_Rec_Head", "field" => "Po_no", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["st_c_rec_item.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["st_c_rec_item.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["st_c_rec_item.Location"]["edit"] = array("table" => "ST_C_Rec_Item", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_c_isu_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_c_isu_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_c_isu_head.Dept"]["edit"] = array("table" => "ST_C_Isu_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["ConsCat"] ) ) {
			$lookupTableLinks["ConsCat"] = array();
		}
		if( !isset( $lookupTableLinks["ConsCat"]["st_c_isu_item.CategoryID"] )) {
			$lookupTableLinks["ConsCat"]["st_c_isu_item.CategoryID"] = array();
		}
		$lookupTableLinks["ConsCat"]["st_c_isu_item.CategoryID"]["edit"] = array("table" => "ST_C_Isu_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["st_c_isu_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item"]["st_c_isu_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item"]["st_c_isu_item.Part_ID"]["edit"] = array("table" => "ST_C_Isu_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_c_ret_head.Sc_No"] )) {
			$lookupTableLinks["SC_Item"]["st_c_ret_head.Sc_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_c_ret_head.Sc_No"]["edit"] = array("table" => "ST_C_Ret_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_c_ret_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_c_ret_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_c_ret_head.Seq_No"]["edit"] = array("table" => "ST_C_Ret_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_c_ret_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_c_ret_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_c_ret_head.Dept"]["edit"] = array("table" => "ST_C_Ret_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["ConsCat"] ) ) {
			$lookupTableLinks["ConsCat"] = array();
		}
		if( !isset( $lookupTableLinks["ConsCat"]["st_c_ret_item.CategoryID"] )) {
			$lookupTableLinks["ConsCat"]["st_c_ret_item.CategoryID"] = array();
		}
		$lookupTableLinks["ConsCat"]["st_c_ret_item.CategoryID"]["edit"] = array("table" => "ST_C_Ret_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["st_c_ret_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item"]["st_c_ret_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item"]["st_c_ret_item.Part_ID"]["edit"] = array("table" => "ST_C_Ret_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ConsCat"] ) ) {
			$lookupTableLinks["ConsCat"] = array();
		}
		if( !isset( $lookupTableLinks["ConsCat"]["st_c_adj_item.CategoryID"] )) {
			$lookupTableLinks["ConsCat"]["st_c_adj_item.CategoryID"] = array();
		}
		$lookupTableLinks["ConsCat"]["st_c_adj_item.CategoryID"]["edit"] = array("table" => "ST_C_Adj_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["st_c_adj_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item"]["st_c_adj_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item"]["st_c_adj_item.Part_ID"]["edit"] = array("table" => "ST_C_Adj_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_c_adj_item.Adj_Type"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_c_adj_item.Adj_Type"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_c_adj_item.Adj_Type"]["edit"] = array("table" => "ST_C_Adj_Item", "field" => "Adj_Type", "page" => "edit");
		if( !isset( $lookupTableLinks["PI_Imp_R_Head"] ) ) {
			$lookupTableLinks["PI_Imp_R_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PI_Imp_R_Head"]["st_repl_rec_head.Inv_No"] )) {
			$lookupTableLinks["PI_Imp_R_Head"]["st_repl_rec_head.Inv_No"] = array();
		}
		$lookupTableLinks["PI_Imp_R_Head"]["st_repl_rec_head.Inv_No"]["edit"] = array("table" => "ST_Repl_Rec_Head", "field" => "Inv_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["st_rep_rec_item.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["st_rep_rec_item.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["st_rep_rec_item.Location"]["edit"] = array("table" => "ST_Rep_Rec_Item", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_repl_isu_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_repl_isu_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_repl_isu_head.Sc_No"]["edit"] = array("table" => "ST_Repl_Isu_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_repl_isu_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_repl_isu_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_repl_isu_head.Seq_No"]["edit"] = array("table" => "ST_Repl_Isu_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_repl_isu_head.To_Sc"] )) {
			$lookupTableLinks["Sc_Head"]["st_repl_isu_head.To_Sc"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_repl_isu_head.To_Sc"]["edit"] = array("table" => "ST_Repl_Isu_Head", "field" => "To_Sc", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_repl_isu_head.To_Seq"] )) {
			$lookupTableLinks["SC_Item"]["st_repl_isu_head.To_Seq"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_repl_isu_head.To_Seq"]["edit"] = array("table" => "ST_Repl_Isu_Head", "field" => "To_Seq", "page" => "edit");
		if( !isset( $lookupTableLinks["Replacement_Item"] ) ) {
			$lookupTableLinks["Replacement_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Replacement_Item"]["st_repl_isu_item.Part_ID"] )) {
			$lookupTableLinks["Replacement_Item"]["st_repl_isu_item.Part_ID"] = array();
		}
		$lookupTableLinks["Replacement_Item"]["st_repl_isu_item.Part_ID"]["edit"] = array("table" => "ST_Repl_Isu_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Replacement_Item"] ) ) {
			$lookupTableLinks["Replacement_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Replacement_Item"]["st_repl_adj_item.Part_ID"] )) {
			$lookupTableLinks["Replacement_Item"]["st_repl_adj_item.Part_ID"] = array();
		}
		$lookupTableLinks["Replacement_Item"]["st_repl_adj_item.Part_ID"]["edit"] = array("table" => "ST_Repl_Adj_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_repl_adj_item.Adj_Type"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_repl_adj_item.Adj_Type"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_repl_adj_item.Adj_Type"]["edit"] = array("table" => "ST_Repl_Adj_Item", "field" => "Adj_Type", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_Loc_B_Head"] ) ) {
			$lookupTableLinks["PO_Loc_B_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PO_Loc_B_Head"]["st_b_rec_head.Po_No"] )) {
			$lookupTableLinks["PO_Loc_B_Head"]["st_b_rec_head.Po_No"] = array();
		}
		$lookupTableLinks["PO_Loc_B_Head"]["st_b_rec_head.Po_No"]["edit"] = array("table" => "ST_B_Rec_Head", "field" => "Po_No", "page" => "edit");
		if( !isset( $lookupTableLinks["BulkInv_Ref"] ) ) {
			$lookupTableLinks["BulkInv_Ref"] = array();
		}
		if( !isset( $lookupTableLinks["BulkInv_Ref"]["st_b_rec_head.Inv_No"] )) {
			$lookupTableLinks["BulkInv_Ref"]["st_b_rec_head.Inv_No"] = array();
		}
		$lookupTableLinks["BulkInv_Ref"]["st_b_rec_head.Inv_No"]["edit"] = array("table" => "ST_B_Rec_Head", "field" => "Inv_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Rim_DeliveryNote_Head"] ) ) {
			$lookupTableLinks["Rim_DeliveryNote_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Rim_DeliveryNote_Head"]["st_b_rec_head.RIM_Dlvy_Note"] )) {
			$lookupTableLinks["Rim_DeliveryNote_Head"]["st_b_rec_head.RIM_Dlvy_Note"] = array();
		}
		$lookupTableLinks["Rim_DeliveryNote_Head"]["st_b_rec_head.RIM_Dlvy_Note"]["edit"] = array("table" => "ST_B_Rec_Head", "field" => "RIM_Dlvy_Note", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_b_rec_item.CategoryID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_b_rec_item.CategoryID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_b_rec_item.CategoryID"]["edit"] = array("table" => "ST_B_Rec_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["st_b_rec_item.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["st_b_rec_item.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["st_b_rec_item.Location"]["edit"] = array("table" => "ST_B_Rec_Item", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_b_isu_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_b_isu_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_b_isu_head.Sc_No"]["edit"] = array("table" => "ST_B_Isu_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_b_isu_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_b_isu_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_b_isu_head.Dept"]["edit"] = array("table" => "ST_B_Isu_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["st_b_isu_head.Seq_No_Select"] )) {
			$lookupTableLinks["SC_Item1"]["st_b_isu_head.Seq_No_Select"] = array();
		}
		$lookupTableLinks["SC_Item1"]["st_b_isu_head.Seq_No_Select"]["edit"] = array("table" => "ST_B_Isu_Head", "field" => "Seq_No_Select", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_b_isu_item.CategoryID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_b_isu_item.CategoryID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_b_isu_item.CategoryID"]["edit"] = array("table" => "ST_B_Isu_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["st_b_isu_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["st_b_isu_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["st_b_isu_item.Part_ID"]["edit"] = array("table" => "ST_B_Isu_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_b_ret_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_b_ret_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_b_ret_head.Sc_No"]["edit"] = array("table" => "ST_B_Ret_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_b_ret_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_b_ret_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_b_ret_head.Seq_No"]["edit"] = array("table" => "ST_B_Ret_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_b_ret_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_b_ret_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_b_ret_head.Dept"]["edit"] = array("table" => "ST_B_Ret_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_b_ret_item.CategoryID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_b_ret_item.CategoryID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_b_ret_item.CategoryID"]["edit"] = array("table" => "ST_B_Ret_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["st_b_ret_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["st_b_ret_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["st_b_ret_item.Part_ID"]["edit"] = array("table" => "ST_B_Ret_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_b_ret_item.Remarks"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_b_ret_item.Remarks"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_b_ret_item.Remarks"]["edit"] = array("table" => "ST_B_Ret_Item", "field" => "Remarks", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_b_adj_item.CategoryID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_b_adj_item.CategoryID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_b_adj_item.CategoryID"]["edit"] = array("table" => "ST_B_Adj_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["st_b_adj_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["st_b_adj_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["st_b_adj_item.Part_ID"]["edit"] = array("table" => "ST_B_Adj_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_b_adj_item.Adj_Type"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_b_adj_item.Adj_Type"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_b_adj_item.Adj_Type"]["edit"] = array("table" => "ST_B_Adj_Item", "field" => "Adj_Type", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Fixed_Inv1"] ) ) {
			$lookupTableLinks["Ref_Fixed_Inv1"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Fixed_Inv1"]["st_f_rec_head.Inv_no"] )) {
			$lookupTableLinks["Ref_Fixed_Inv1"]["st_f_rec_head.Inv_no"] = array();
		}
		$lookupTableLinks["Ref_Fixed_Inv1"]["st_f_rec_head.Inv_no"]["edit"] = array("table" => "ST_F_Rec_Head", "field" => "Inv_no", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_Loc_F_Head"] ) ) {
			$lookupTableLinks["PO_Loc_F_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PO_Loc_F_Head"]["st_f_rec_head.Po_no"] )) {
			$lookupTableLinks["PO_Loc_F_Head"]["st_f_rec_head.Po_no"] = array();
		}
		$lookupTableLinks["PO_Loc_F_Head"]["st_f_rec_head.Po_no"]["edit"] = array("table" => "ST_F_Rec_Head", "field" => "Po_no", "page" => "edit");
		if( !isset( $lookupTableLinks["PI_Imp_Paint_Head"] ) ) {
			$lookupTableLinks["PI_Imp_Paint_Head"] = array();
		}
		if( !isset( $lookupTableLinks["PI_Imp_Paint_Head"]["st_f_rec_head.Paint_Inv_no"] )) {
			$lookupTableLinks["PI_Imp_Paint_Head"]["st_f_rec_head.Paint_Inv_no"] = array();
		}
		$lookupTableLinks["PI_Imp_Paint_Head"]["st_f_rec_head.Paint_Inv_no"]["edit"] = array("table" => "ST_F_Rec_Head", "field" => "Paint_Inv_no", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["st_f_rec_item.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["st_f_rec_item.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["st_f_rec_item.Location"]["edit"] = array("table" => "ST_F_Rec_Item", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_f_ret_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_f_ret_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_f_ret_head.Sc_No"]["edit"] = array("table" => "ST_F_Ret_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_f_ret_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_f_ret_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_f_ret_head.Seq_No"]["edit"] = array("table" => "ST_F_Ret_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_f_ret_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_f_ret_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_f_ret_head.Dept"]["edit"] = array("table" => "ST_F_Ret_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_f_ret_item.CategoryID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_f_ret_item.CategoryID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_f_ret_item.CategoryID"]["edit"] = array("table" => "ST_F_Ret_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Fixed"] ) ) {
			$lookupTableLinks["ST_Item_Fixed"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Fixed"]["st_f_ret_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item_Fixed"]["st_f_ret_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item_Fixed"]["st_f_ret_item.Part_ID"]["edit"] = array("table" => "ST_F_Ret_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_f_isu_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_f_isu_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_f_isu_head.Sc_No"]["edit"] = array("table" => "ST_F_Isu_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_f_isu_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_f_isu_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_f_isu_head.Dept"]["edit"] = array("table" => "ST_F_Isu_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["st_f_isu_head.Seq_No_Select"] )) {
			$lookupTableLinks["SC_Item1"]["st_f_isu_head.Seq_No_Select"] = array();
		}
		$lookupTableLinks["SC_Item1"]["st_f_isu_head.Seq_No_Select"]["edit"] = array("table" => "ST_F_Isu_Head", "field" => "Seq_No_Select", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Fixed"] ) ) {
			$lookupTableLinks["ST_Item_Fixed"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Fixed"]["st_f_isu_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item_Fixed"]["st_f_isu_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item_Fixed"]["st_f_isu_item.Part_ID"]["edit"] = array("table" => "ST_F_Isu_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["st_f_isu_item.Cat_ID"] )) {
			$lookupTableLinks["Parts"]["st_f_isu_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts"]["st_f_isu_item.Cat_ID"]["edit"] = array("table" => "ST_F_Isu_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_f_adj_item.CategoryID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_f_adj_item.CategoryID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_f_adj_item.CategoryID"]["edit"] = array("table" => "ST_F_Adj_Item", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Fixed"] ) ) {
			$lookupTableLinks["ST_Item_Fixed"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Fixed"]["st_f_adj_item.Part_ID"] )) {
			$lookupTableLinks["ST_Item_Fixed"]["st_f_adj_item.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item_Fixed"]["st_f_adj_item.Part_ID"]["edit"] = array("table" => "ST_F_Adj_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_f_adj_item.Adj_Type"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_f_adj_item.Adj_Type"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_f_adj_item.Adj_Type"]["edit"] = array("table" => "ST_F_Adj_Item", "field" => "Adj_Type", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Ibwsreccont"] ) ) {
			$lookupTableLinks["Ref_Ibwsreccont"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Ibwsreccont"]["st_ibws_rec_head_new.CNTRNo"] )) {
			$lookupTableLinks["Ref_Ibwsreccont"]["st_ibws_rec_head_new.CNTRNo"] = array();
		}
		$lookupTableLinks["Ref_Ibwsreccont"]["st_ibws_rec_head_new.CNTRNo"]["edit"] = array("table" => "ST_IBWS_Rec_Head_New", "field" => "CNTRNo", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["st_ibws_rec_item_new.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["st_ibws_rec_item_new.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["st_ibws_rec_item_new.Location"]["edit"] = array("table" => "ST_IBWS_Rec_Item_New", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Ibwspc3"] ) ) {
			$lookupTableLinks["Ref_Ibwspc3"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Ibwspc3"]["st_ibws_pc3_rec_head_new.CNTRNo"] )) {
			$lookupTableLinks["Ref_Ibwspc3"]["st_ibws_pc3_rec_head_new.CNTRNo"] = array();
		}
		$lookupTableLinks["Ref_Ibwspc3"]["st_ibws_pc3_rec_head_new.CNTRNo"]["edit"] = array("table" => "ST_IBWS_PC3_Rec_Head_New", "field" => "CNTRNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_IBWS_Vehicles"] ) ) {
			$lookupTableLinks["Ref_IBWS_Vehicles"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_IBWS_Vehicles"]["st_ibws_pc3_rec_head_new.VehicleNo"] )) {
			$lookupTableLinks["Ref_IBWS_Vehicles"]["st_ibws_pc3_rec_head_new.VehicleNo"] = array();
		}
		$lookupTableLinks["Ref_IBWS_Vehicles"]["st_ibws_pc3_rec_head_new.VehicleNo"]["edit"] = array("table" => "ST_IBWS_PC3_Rec_Head_New", "field" => "VehicleNo", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["st_ibws_pc3_rec_item_new.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["st_ibws_pc3_rec_item_new.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["st_ibws_pc3_rec_item_new.Location"]["edit"] = array("table" => "ST_IBWS_PC3_Rec_Item_New", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["st_ibws_rec_head.Model_No"] )) {
			$lookupTableLinks["BD_Model"]["st_ibws_rec_head.Model_No"] = array();
		}
		$lookupTableLinks["BD_Model"]["st_ibws_rec_head.Model_No"]["edit"] = array("table" => "ST_IBWS_Rec_Head", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_ibws_isu_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_ibws_isu_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_ibws_isu_head.Dept"]["edit"] = array("table" => "ST_IBWS_Isu_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_ibws_ret_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_ibws_ret_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_ibws_ret_head.Sc_No"]["edit"] = array("table" => "ST_IBWS_Ret_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_ibws_ret_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_ibws_ret_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_ibws_ret_head.Seq_No"]["edit"] = array("table" => "ST_IBWS_Ret_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_ibws_ret_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_ibws_ret_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_ibws_ret_head.Dept"]["edit"] = array("table" => "ST_IBWS_Ret_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_IBWS_Isu_Head"] ) ) {
			$lookupTableLinks["ST_IBWS_Isu_Head"] = array();
		}
		if( !isset( $lookupTableLinks["ST_IBWS_Isu_Head"]["st_ibws_ret_head.Isu_Ref"] )) {
			$lookupTableLinks["ST_IBWS_Isu_Head"]["st_ibws_ret_head.Isu_Ref"] = array();
		}
		$lookupTableLinks["ST_IBWS_Isu_Head"]["st_ibws_ret_head.Isu_Ref"]["edit"] = array("table" => "ST_IBWS_Ret_Head", "field" => "Isu_Ref", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["st_ibws_ret_item.Part_ID"] )) {
			$lookupTableLinks["Parts"]["st_ibws_ret_item.Part_ID"] = array();
		}
		$lookupTableLinks["Parts"]["st_ibws_ret_item.Part_ID"]["edit"] = array("table" => "ST_IBWS_Ret_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Adj_Reason"] ) ) {
			$lookupTableLinks["ST_Adj_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Adj_Reason"]["st_ibws_ret_item.Reason"] )) {
			$lookupTableLinks["ST_Adj_Reason"]["st_ibws_ret_item.Reason"] = array();
		}
		$lookupTableLinks["ST_Adj_Reason"]["st_ibws_ret_item.Reason"]["edit"] = array("table" => "ST_IBWS_Ret_Item", "field" => "Reason", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_ibws_adj_item.Sc_No"] )) {
			$lookupTableLinks["SC_Item"]["st_ibws_adj_item.Sc_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_ibws_adj_item.Sc_No"]["edit"] = array("table" => "ST_IBWS_Adj_Item", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_ibws_adj_item.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_ibws_adj_item.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_ibws_adj_item.Seq_No"]["edit"] = array("table" => "ST_IBWS_Adj_Item", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Bulk_refcat"] ) ) {
			$lookupTableLinks["Bulk_refcat"] = array();
		}
		if( !isset( $lookupTableLinks["Bulk_refcat"]["st_ibws_adj_item.Part_ID"] )) {
			$lookupTableLinks["Bulk_refcat"]["st_ibws_adj_item.Part_ID"] = array();
		}
		$lookupTableLinks["Bulk_refcat"]["st_ibws_adj_item.Part_ID"]["edit"] = array("table" => "ST_IBWS_Adj_Item", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_swap_ibws.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_swap_ibws.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_swap_ibws.Sc_No"]["edit"] = array("table" => "ST_Swap_IBWS", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["st_swap_ibws.Seq_No"] )) {
			$lookupTableLinks["SC_Item1"]["st_swap_ibws.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item1"]["st_swap_ibws.Seq_No"]["edit"] = array("table" => "ST_Swap_IBWS", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["st_swap_ibws.Item"] )) {
			$lookupTableLinks["Parts"]["st_swap_ibws.Item"] = array();
		}
		$lookupTableLinks["Parts"]["st_swap_ibws.Item"]["edit"] = array("table" => "ST_Swap_IBWS", "field" => "Item", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_swap_ibws.Transfer_SC"] )) {
			$lookupTableLinks["Sc_Head"]["st_swap_ibws.Transfer_SC"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_swap_ibws.Transfer_SC"]["edit"] = array("table" => "ST_Swap_IBWS", "field" => "Transfer_SC", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["st_swap_ibws.Transfer_Seq"] )) {
			$lookupTableLinks["SC_Item1"]["st_swap_ibws.Transfer_Seq"] = array();
		}
		$lookupTableLinks["SC_Item1"]["st_swap_ibws.Transfer_Seq"]["edit"] = array("table" => "ST_Swap_IBWS", "field" => "Transfer_Seq", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["st_swap_ibws.Transfer_Item"] )) {
			$lookupTableLinks["Parts"]["st_swap_ibws.Transfer_Item"] = array();
		}
		$lookupTableLinks["Parts"]["st_swap_ibws.Transfer_Item"]["edit"] = array("table" => "ST_Swap_IBWS", "field" => "Transfer_Item", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["st_ibws_rec_head_sp.Model_No"] )) {
			$lookupTableLinks["BD_Model"]["st_ibws_rec_head_sp.Model_No"] = array();
		}
		$lookupTableLinks["BD_Model"]["st_ibws_rec_head_sp.Model_No"]["edit"] = array("table" => "ST_IBWS_Rec_Head_Sp", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_ibws_isu_head_sp.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_ibws_isu_head_sp.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_ibws_isu_head_sp.Sc_No"]["edit"] = array("table" => "ST_IBWS_Isu_Head_Sp", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_ibws_isu_head_sp.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_ibws_isu_head_sp.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_ibws_isu_head_sp.Dept"]["edit"] = array("table" => "ST_IBWS_Isu_Head_Sp", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["st_ibws_isu_head_sp.Seq_No_Select"] )) {
			$lookupTableLinks["SC_Item1"]["st_ibws_isu_head_sp.Seq_No_Select"] = array();
		}
		$lookupTableLinks["SC_Item1"]["st_ibws_isu_head_sp.Seq_No_Select"]["edit"] = array("table" => "ST_IBWS_Isu_Head_Sp", "field" => "Seq_No_Select", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_ibws_isu_exframe_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_ibws_isu_exframe_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_ibws_isu_exframe_head.Dept"]["edit"] = array("table" => "ST_IBWS_Isu_Exframe_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_ibws_ret_head_sp.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_ibws_ret_head_sp.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_ibws_ret_head_sp.Sc_No"]["edit"] = array("table" => "ST_IBWS_Ret_Head_Sp", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_ibws_ret_head_sp.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_ibws_ret_head_sp.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_ibws_ret_head_sp.Seq_No"]["edit"] = array("table" => "ST_IBWS_Ret_Head_Sp", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_ibws_ret_head_sp.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_ibws_ret_head_sp.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_ibws_ret_head_sp.Dept"]["edit"] = array("table" => "ST_IBWS_Ret_Head_Sp", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_IBWS_Isu_Head_Sp"] ) ) {
			$lookupTableLinks["ST_IBWS_Isu_Head_Sp"] = array();
		}
		if( !isset( $lookupTableLinks["ST_IBWS_Isu_Head_Sp"]["st_ibws_ret_head_sp.Isu_Ref"] )) {
			$lookupTableLinks["ST_IBWS_Isu_Head_Sp"]["st_ibws_ret_head_sp.Isu_Ref"] = array();
		}
		$lookupTableLinks["ST_IBWS_Isu_Head_Sp"]["st_ibws_ret_head_sp.Isu_Ref"]["edit"] = array("table" => "ST_IBWS_Ret_Head_Sp", "field" => "Isu_Ref", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"] ) ) {
			$lookupTableLinks["Sc_Itemnot_Include"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Cat_ID"] )) {
			$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Cat_ID"] = array();
		}
		$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Cat_ID"]["edit"] = array("table" => "ST_Fixed_AdjLed_Rec_Head", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"] ) ) {
			$lookupTableLinks["Sc_Itemnot_Include"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Part_ID"] )) {
			$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Part_ID"] = array();
		}
		$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Part_ID"]["edit"] = array("table" => "ST_Fixed_AdjLed_Rec_Head", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"] ) ) {
			$lookupTableLinks["Sc_Itemnot_Include"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Sc_No"]["edit"] = array("table" => "ST_Fixed_AdjLed_Rec_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"] ) ) {
			$lookupTableLinks["Sc_Itemnot_Include"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Seq_No"] )) {
			$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Seq_No"] = array();
		}
		$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.Seq_No"]["edit"] = array("table" => "ST_Fixed_AdjLed_Rec_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"] ) ) {
			$lookupTableLinks["Sc_Itemnot_Include"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.sc_ini"] )) {
			$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.sc_ini"] = array();
		}
		$lookupTableLinks["Sc_Itemnot_Include"]["st_fixed_adjled_rec_head.sc_ini"]["edit"] = array("table" => "ST_Fixed_AdjLed_Rec_Head", "field" => "sc_ini", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_paint_isu_head.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_paint_isu_head.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_paint_isu_head.Dept"]["edit"] = array("table" => "ST_Paint_Isu_Head", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["st_paint_isu_item.Cat_ID"] )) {
			$lookupTableLinks["Parts"]["st_paint_isu_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts"]["st_paint_isu_item.Cat_ID"]["edit"] = array("table" => "ST_Paint_Isu_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_replfrm_isu_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_replfrm_isu_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_replfrm_isu_head.Sc_No"]["edit"] = array("table" => "ST_ReplFrm_Isu_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_replfrm_isu_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_replfrm_isu_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_replfrm_isu_head.Seq_No"]["edit"] = array("table" => "ST_ReplFrm_Isu_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_replfrm_isu_head.To_Sc"] )) {
			$lookupTableLinks["Sc_Head"]["st_replfrm_isu_head.To_Sc"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_replfrm_isu_head.To_Sc"]["edit"] = array("table" => "ST_ReplFrm_Isu_Head", "field" => "To_Sc", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_replfrm_isu_head.To_Seq"] )) {
			$lookupTableLinks["SC_Item"]["st_replfrm_isu_head.To_Seq"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_replfrm_isu_head.To_Seq"]["edit"] = array("table" => "ST_ReplFrm_Isu_Head", "field" => "To_Seq", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_swap_fixed.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_swap_fixed.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_swap_fixed.Sc_No"]["edit"] = array("table" => "ST_Swap_Fixed", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_swap_fixed.Transfer_SC"] )) {
			$lookupTableLinks["Sc_Head"]["st_swap_fixed.Transfer_SC"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_swap_fixed.Transfer_SC"]["edit"] = array("table" => "ST_Swap_Fixed", "field" => "Transfer_SC", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_INIREF1"] ) ) {
			$lookupTableLinks["SC_INIREF1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_INIREF1"]["st_swap_fixed.T_siniref"] )) {
			$lookupTableLinks["SC_INIREF1"]["st_swap_fixed.T_siniref"] = array();
		}
		$lookupTableLinks["SC_INIREF1"]["st_swap_fixed.T_siniref"]["edit"] = array("table" => "ST_Swap_Fixed", "field" => "T_siniref", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_INIREF1"] ) ) {
			$lookupTableLinks["SC_INIREF1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_INIREF1"]["st_swap_fixed.F_siniref"] )) {
			$lookupTableLinks["SC_INIREF1"]["st_swap_fixed.F_siniref"] = array();
		}
		$lookupTableLinks["SC_INIREF1"]["st_swap_fixed.F_siniref"]["edit"] = array("table" => "ST_Swap_Fixed", "field" => "F_siniref", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Department"] ) ) {
			$lookupTableLinks["ST_Department"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Department"]["st_c_isu_head_new.Dept"] )) {
			$lookupTableLinks["ST_Department"]["st_c_isu_head_new.Dept"] = array();
		}
		$lookupTableLinks["ST_Department"]["st_c_isu_head_new.Dept"]["edit"] = array("table" => "ST_C_Isu_Head_New", "field" => "Dept", "page" => "edit");
		if( !isset( $lookupTableLinks["ConsCat"] ) ) {
			$lookupTableLinks["ConsCat"] = array();
		}
		if( !isset( $lookupTableLinks["ConsCat"]["st_c_isu_item_new.CategoryID"] )) {
			$lookupTableLinks["ConsCat"]["st_c_isu_item_new.CategoryID"] = array();
		}
		$lookupTableLinks["ConsCat"]["st_c_isu_item_new.CategoryID"]["edit"] = array("table" => "ST_C_Isu_Item_New", "field" => "CategoryID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["st_c_isu_item_new.Part_ID"] )) {
			$lookupTableLinks["ST_Item"]["st_c_isu_item_new.Part_ID"] = array();
		}
		$lookupTableLinks["ST_Item"]["st_c_isu_item_new.Part_ID"]["edit"] = array("table" => "ST_C_Isu_Item_New", "field" => "Part_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["st_rep_ret_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["st_rep_ret_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["st_rep_ret_head.Sc_No"]["edit"] = array("table" => "ST_Rep_Ret_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["st_rep_ret_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["st_rep_ret_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["st_rep_ret_head.Seq_No"]["edit"] = array("table" => "ST_Rep_Ret_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Replacement_Item"] ) ) {
			$lookupTableLinks["Replacement_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Replacement_Item"]["st_repl_ret_item.Part_ID"] )) {
			$lookupTableLinks["Replacement_Item"]["st_repl_ret_item.Part_ID"] = array();
		}
		$lookupTableLinks["Replacement_Item"]["st_repl_ret_item.Part_ID"]["edit"] = array("table" => "ST_Repl_Ret_Item", "field" => "Part_ID", "page" => "edit");
}

?>