<?php
class ConnectionManager
{
	/**
	 * Cached Connection objects
	 * @type Array
	 */
	protected $cache = array();

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsData;

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsIdByName = array();

	
	/**
	 * An array storing the correspondence between project
	 * datasource tables names and connections ids
	 * @type Array
	 */	
	protected $_tablesConnectionIds;
	
	
	/**
	 * @constructor
	 */
	function __construct()
	{
		$this->_setConnectionsData();
		$this->_setTablesConnectionIds();
	}
	
	/**
	 * Get connection object by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function byTable( $tName )
	{
		$connId = $this->_tablesConnectionIds[ $tName ];
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection object by the connection name
	 * @param String connName
	 * @return Connection
	 */	
	public function byName( $connName )
	{
		$connId = $this->getIdByName( $connName );
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}
	
	/**
	 * Get connection id by the connection name
	 * @param String connName
	 * @return String
	 */	
	protected function getIdByName( $connName )
	{
		return $this->_connectionsIdByName[ $connName ];
	}
	
	/**
	 * Get connection object by the connection id 
	 * @param String connId
	 * @return Connection
	 */	
	public function byId( $connId )
	{
		if( !isset( $this->cache[ $connId ] ) )
			$this->cache[ $connId ] = $this->getConnection( $connId );

		return $this->cache[ $connId ];
	}
	
	/**
	 * Get the default db connection class
	 * @return Connection
	 */
	public function getDefault()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}

	/**
	 * Get the users table db connection 
	 * @return Connection
	 */	
	public function getForLogin()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}
	
	/**
	 * Get the log table db connection 
	 * @return Connection
	 */	
	public function getForAudit()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}
	
	/**
	 * Get the locking table db connection 
	 * @return Connection
	 */		
	public function getForLocking()
	{
		return $this->getDefault();
	}	
	
	/**
	 * Get the 'ug_groups' table db connection 
	 * @return Connection
	 */	
	public function getForUserGroups()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}		

	/**
	 * Get the saved searches table db connection 
	 * @return Connection
	 */	
	public function getForSavedSearches()
	{
		return $this->getDefault();
	}

	/**
	 * Get the webreports tables db connection 
	 * @return Connection
	 */		
	public function getForWebReports()
	{
		return $this->getDefault();
	}
	
	/**
	 * @param String connId
	 * @return Connection
	 */
	protected function getConnection( $connId )
	{
		include_once getabspath("connections/Connection.php");
		
		$data = $this->_connectionsData[ $connId ];	
		switch( $data["connStringType"] )
		{
			case "mysql":
				if( useMySQLiLib() )
				{
					include_once getabspath("connections/MySQLiConnection.php");
					return new MySQLiConnection( $data );
				}
				
				include_once getabspath("connections/MySQLConnection.php");	
				return new MySQLConnection( $data );	

			case "mssql":
			case "compact":
				if( useMSSQLWinConnect() )
				{
					include_once getabspath("connections/MSSQLWinConnection.php");
					return new MSSQLWinConnection( $data );
				}
				if( isSqlsrvExtLoaded() )
				{
					include_once getabspath("connections/MSSQLSrvConnection.php");	
					return new MSSQLSrvConnection( $data );
				}
				
				if( function_exists("mssql_connect") ) {
					include_once getabspath("connections/MSSQLUnixConnection.php");
					return new MSSQLUnixConnection( $data );			
				}

				if( class_exists("PDO") ) {
					include_once getabspath("connections/PDOConnection.php");
					$drivers = pdo_drivers();
					if( in_array( "sqlsrv", $drivers) )
					{
						$data["PDOString"] = "sqlsrv:Server=" . $data["connInfo"][0] . ";Database=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
					if( in_array( "dblib", $drivers) )
					{
						$data["PDOString"] = "dblib:host=" . $data["connInfo"][0] . ";dbname=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
				}
				echo "No SQL Server driver found in your PHP settings.";
				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
					echo "<br>To enable SQL Server support add the following line to php.ini file:";
					echo "<br>extension=php_com_dotnet.dll";
				}
				exit();

			case "msaccess":
			case "odbc":
			case "odbcdsn":
			case "custom":
			case "file":
				if( stripos($data["ODBCString"], 'Provider=') !== false )
				{
					include_once getabspath("connections/ADOConnection.php");
					return new ADOConnection( $data );
				}
				
				include_once getabspath("connections/ODBCConnection.php");
				return new ODBCConnection( $data );
			
			case "oracle":
				include_once getabspath("connections/OracleConnection.php");
				return new OracleConnection( $data );

			case "postgre":
				include_once getabspath("connections/PostgreConnection.php");
				return new PostgreConnection( $data );

			case "db2":
				include_once getabspath("connections/DB2Connection.php");
				return new DB2Connection( $data );

			case "informix":
				include_once getabspath("connections/InformixConnection.php");
				return new InformixConnection( $data );

			case "sqlite":
				include_once getabspath("connections/SQLite3Connection.php");
				return new SQLite3Connection( $data );
			case "pdo":
				include_once getabspath("connections/PDOConnection.php");
				return new PDOConnection( $data );
		}
	}

	public function getConectionsIds()
	{
		$connectionsIds = array();
		foreach ($this->_connectionsData as $connId => $data) {
			$connectionsIds[] = $connId;
		}

		return $connectionsIds;
	}

	/**
	 * Set the data representing the project's 
	 * db connection properties
	 */	 
	protected function _setConnectionsData()
	{
		// content of this function can be modified on demo account
		// variable names $data and $connectionsData are important

		$connectionsData = array();
		
		$data = array();
		$data["dbType"] = 0;
		$data["connId"] = "firefoxbd_at_localhost";
		$data["connName"] = "firefoxbd at erp.corvoltd.com";
		$data["connStringType"] = "mysql";
		$data["connectionString"] = "mysql;erp.corvoltd.com;Admin;5MQFX49p2Z8a@777;;firefoxbd;;1"; //currently unused

		$this->_connectionsIdByName["firefoxbd at erp.corvoltd.com"] = "firefoxbd_at_localhost";
		
		$data["connInfo"] = array();
		$data["ODBCUID"] = "Admin";
		$data["ODBCPWD"] = "5MQFX49p2Z8a@777";
		$data["leftWrap"] = "`";
		$data["rightWrap"] = "`";
		
		$data["DBPath"] = "db"; //currently unused	
		$data["useServerMapPath"] = 1; //currently unused
		
		$data["connInfo"][0] = "erp.corvoltd.com";
		$data["connInfo"][1] = "Admin";
		$data["connInfo"][2] = "5MQFX49p2Z8a@777";
		$data["connInfo"][3] = "";
		$data["connInfo"][4] = "firefoxbd";
		$data["connInfo"][5] = ""; //currently unused
		$data["connInfo"][6] = "1"; //currently unused
		$data["ODBCString"] = "DRIVER={MySQL ODBC 3.51 Driver};Server=erp.corvoltd.com;Uid=Admin;Pwd=5MQFX49p2Z8a@777;Database=firefoxbd;OPTION=3";
		// encription set
		$data["EncryptInfo"] = array();
		$data["EncryptInfo"]["mode"] = 0;
		$data["EncryptInfo"]["alg"]  = 128;
		$data["EncryptInfo"]["key"]  = "";

		$connectionsData["firefoxbd_at_localhost"] = $data;
		$this->_connectionsData = $connectionsData;
	}
	
	/**
	 * Set the data representing the correspondence between 
	 * the project's table names and db connections
	 */	 
	protected function _setTablesConnectionIds()
	{
		$connectionsIds = array();
		$connectionsIds["BD_Model"] = "firefoxbd_at_localhost";
		$connectionsIds["webusers"] = "firefoxbd_at_localhost";
		$connectionsIds["Customer"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Group"] = "firefoxbd_at_localhost";
		$connectionsIds["Supplier_Maintenance"] = "firefoxbd_at_localhost";
		$connectionsIds["Maintenance_Input"] = "firefoxbd_at_localhost";
		$connectionsIds["Maintenance_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Country"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts"] = "firefoxbd_at_localhost";
		$connectionsIds["Assets_Group"] = "firefoxbd_at_localhost";
		$connectionsIds["Assets_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Item_Unit"] = "firefoxbd_at_localhost";
		$connectionsIds["Supplier"] = "firefoxbd_at_localhost";
		$connectionsIds["ST_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["ST_Item_Carton"] = "firefoxbd_at_localhost";
		$connectionsIds["ST_Item_Chain"] = "firefoxbd_at_localhost";
		$connectionsIds["ST_Item_Bulk"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Group"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts1"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts11"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts111"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts1111"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts11111"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_A_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_A_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_A_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_A_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_C_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_C_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_C_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_C_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["Title"] = "firefoxbd_at_localhost";
		$connectionsIds["Fright"] = "firefoxbd_at_localhost";
		$connectionsIds["Loading_Ports"] = "firefoxbd_at_localhost";
		$connectionsIds["Destinations"] = "firefoxbd_at_localhost";
		$connectionsIds["Payterms_new"] = "firefoxbd_at_localhost";
		$connectionsIds["Currency"] = "firefoxbd_at_localhost";
		$connectionsIds["Time_Period"] = "firefoxbd_at_localhost";
		$connectionsIds["Shipping_Marks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_B_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_B_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_B_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_B_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_F_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_F_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_F_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_C_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_C_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_C_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_C_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_A_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_A_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_A_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_A_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Loc_F_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PC_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Ibws_Head_Inv"] = "firefoxbd_at_localhost";
		$connectionsIds["Ibws_Inv_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["Ibws_Inv_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Factory"] = "firefoxbd_at_localhost";
		$connectionsIds["Pc_Terms"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts2"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts21"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts211"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_R_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_R_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_R_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_R_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["Replcement_Req_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Fright_new"] = "firefoxbd_at_localhost";
		$connectionsIds["BL_Shipper"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["SC_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Replacement_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Paint_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Paint_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_Rc_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_Rc_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_Rc_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_Rc_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Rc_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Rc_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Rc_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Rc_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Rc_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rim_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rim_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rim_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["Forwaders"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rc_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rc_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rc_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rc_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Rc_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_A_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_A_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_A_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_A_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_A_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_A_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_A_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_A_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_A_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_A_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_C_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_C_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_C_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_C_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_C_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_C_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_C_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_C_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_C_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_C_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_R_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_R_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_R_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_R_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_R_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_R_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_R_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_R_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_R_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_R_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_B_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_B_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_B_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_B_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_B_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_B_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_B_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_B_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_B_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_B_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_B_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_B_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_B_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_B_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_B_Item_Ex"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_F_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_F_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_F_ItemData"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts3"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_Paint_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Paint_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Paint_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Paint_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Paint_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_Paint_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Paint_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Paint_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Paint_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Paint_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_Paint_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["admin_rights"] = "firefoxbd_at_localhost";
		$connectionsIds["admin_members"] = "firefoxbd_at_localhost";
		$connectionsIds["admin_users"] = "firefoxbd_at_localhost";
		$connectionsIds["ref_capital_invoicelist"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_B_List"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_C_List"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_A_List"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_Paint_List"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_R_List"] = "firefoxbd_at_localhost";
		$connectionsIds["ST_Item_Cat"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_C"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_B"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_A"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_R"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_Rc"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_Paint"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts31"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_Replace_Polnvlist"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_Replacement_Invlist1"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_Rc_List"] = "firefoxbd_at_localhost";
		$connectionsIds["Agent_Master"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_Sc_Iniinput"] = "firefoxbd_at_localhost";
		$connectionsIds["RCConsignee"] = "firefoxbd_at_localhost";
		$this->_tablesConnectionIds = $connectionsIds;
	}
	
	/**
	 * Check if It's possible to add to one table's sql query 
	 * an sql subquery to another table.
	 * Access doesn't support subqueries from the same table as main.
	 * @param String dataSourceTName1
	 * @param String dataSourceTName2
	 * @return Boolean
	 */
	public function checkTablesSubqueriesSupport( $dataSourceTName1, $dataSourceTName2 )
	{
		$connId1 = $this->_tablesConnectionIds[ $dataSourceTName1 ];
		$connId2 = $this->_tablesConnectionIds[ $dataSourceTName2 ];
		
		if( $connId1 != $connId2 )
			return false;

		if( $this->_connectionsData[ $connId1 ]["dbType"] == nDATABASE_Access && $dataSourceTName1 == $dataSourceTName2 )
			return false;
			
		return true;	
	}
	
	/**
	 * Close db connections
	 * @destructor
	 */
	function __desctruct() 
	{
		foreach( $this->cache as $connection )
		{
			$connection->close();
		}
	}
}
?>