<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("webusers");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblfirefoxbd_at_103_6_168_141__tbl0_China_Customer;
	var $tblfirefoxbd_at_103_6_168_141__ACT_Impvalue;
	var $tblfirefoxbd_at_103_6_168_141__BD_audit;
	var $tblfirefoxbd_at_103_6_168_141__BD_Model;
	var $tblfirefoxbd_at_103_6_168_141__BL_Shipper;
	var $tblfirefoxbd_at_103_6_168_141__Cable_LengthHead;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_Banks;
	var $tblfirefoxbd_at_103_6_168_141__Component_price_input;
	var $tblfirefoxbd_at_103_6_168_141__Component_Price_Master;
	var $tblfirefoxbd_at_103_6_168_141__Cust_Comment_View;
	var $tblfirefoxbd_at_103_6_168_141__Customer;
	var $tblfirefoxbd_at_103_6_168_141__Customer_Comments;
	var $tblfirefoxbd_at_103_6_168_141__Export_Coststatement_Head;
	var $tblfirefoxbd_at_103_6_168_141__Factory;
	var $tblfirefoxbd_at_103_6_168_141__ffxbderp_uggroups;
	var $tblfirefoxbd_at_103_6_168_141__ffxbderp_ugmembers;
	var $tblfirefoxbd_at_103_6_168_141__ffxbderp_ugrights;
	var $tblfirefoxbd_at_103_6_168_141__Fixed_Comments_Shortage;
	var $tblfirefoxbd_at_103_6_168_141__Fright;
	var $tblfirefoxbd_at_103_6_168_141__Ibws_payment_Duedates_Input;
	var $tblfirefoxbd_at_103_6_168_141__Imp_Paint_Remarks;
	var $tblfirefoxbd_at_103_6_168_141__Imp_PO;
	var $tblfirefoxbd_at_103_6_168_141__Item_Unit;
	var $tblfirefoxbd_at_103_6_168_141__Local_PO;
	var $tblfirefoxbd_at_103_6_168_141__Maker;
	var $tblfirefoxbd_at_103_6_168_141__Modelwise_Input;
	var $tblfirefoxbd_at_103_6_168_141__Modelwise_Input_Item;
	var $tblfirefoxbd_at_103_6_168_141__Modification_Apps;
	var $tblfirefoxbd_at_103_6_168_141__Modyfication_History;
	var $tblfirefoxbd_at_103_6_168_141__Packing_Material_Color;
	var $tblfirefoxbd_at_103_6_168_141__Packing_Materials_Component;
	var $tblfirefoxbd_at_103_6_168_141__Packing_Matrial_Master;
	var $tblfirefoxbd_at_103_6_168_141__Paint_Item_Final;
	var $tblfirefoxbd_at_103_6_168_141__Parts;
	var $tblfirefoxbd_at_103_6_168_141__Payterms_new;
	var $tblfirefoxbd_at_103_6_168_141__PC_Head;
	var $tblfirefoxbd_at_103_6_168_141__PC_Item;
	var $tblfirefoxbd_at_103_6_168_141__Pc_Terms;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_B_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_B_Item;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_F_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_F_Item;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_R_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_R_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_B_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_R_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_R_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Loc_F_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Loc_F_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Main;
	var $tblfirefoxbd_at_103_6_168_141__Reminder_Head;
	var $tblfirefoxbd_at_103_6_168_141__Sc_Head;
	var $tblfirefoxbd_at_103_6_168_141__SC_Item;
	var $tblfirefoxbd_at_103_6_168_141__Shipping_Marks;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Amendments;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Amendments_Item;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Comp;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Group;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Group_Item;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Item_Color;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Kids_Head;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Material;
	var $tblfirefoxbd_at_103_6_168_141__ST_C_Isu_Head;
	var $tblfirefoxbd_at_103_6_168_141__ST_C_Isu_Item;
	var $tblfirefoxbd_at_103_6_168_141__ST_Department;
	var $tblfirefoxbd_at_103_6_168_141__ST_Item;
	var $tblfirefoxbd_at_103_6_168_141__ST_Swap_IBWS;
	var $tblfirefoxbd_at_103_6_168_141__Supplier;
	var $tblfirefoxbd_at_103_6_168_141__Title;
	var $tblfirefoxbd_at_103_6_168_141__webusers;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "0_China_Customer", "varname" => "firefoxbd_at_103_6_168_141__tbl0_China_Customer", "altvarname" => "tbl0_China_Customer", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ACT_Impvalue", "varname" => "firefoxbd_at_103_6_168_141__ACT_Impvalue", "altvarname" => "ACT_Impvalue", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "BD_audit", "varname" => "firefoxbd_at_103_6_168_141__BD_audit", "altvarname" => "BD_audit", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "BD_Model", "varname" => "firefoxbd_at_103_6_168_141__BD_Model", "altvarname" => "BD_Model", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "BL_Shipper", "varname" => "firefoxbd_at_103_6_168_141__BL_Shipper", "altvarname" => "BL_Shipper", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Cable_LengthHead", "varname" => "firefoxbd_at_103_6_168_141__Cable_LengthHead", "altvarname" => "Cable_LengthHead", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Cash_Flow_Banks", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_Banks", "altvarname" => "Cash_Flow_Banks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Component_price_input", "varname" => "firefoxbd_at_103_6_168_141__Component_price_input", "altvarname" => "Component_price_input", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Component_Price_Master", "varname" => "firefoxbd_at_103_6_168_141__Component_Price_Master", "altvarname" => "Component_Price_Master", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Cust_Comment_View", "varname" => "firefoxbd_at_103_6_168_141__Cust_Comment_View", "altvarname" => "Cust_Comment_View", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Customer", "varname" => "firefoxbd_at_103_6_168_141__Customer", "altvarname" => "Customer", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Customer_Comments", "varname" => "firefoxbd_at_103_6_168_141__Customer_Comments", "altvarname" => "Customer_Comments", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Export_Coststatement_Head", "varname" => "firefoxbd_at_103_6_168_141__Export_Coststatement_Head", "altvarname" => "Export_Coststatement_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Factory", "varname" => "firefoxbd_at_103_6_168_141__Factory", "altvarname" => "Factory", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ffxbderp_uggroups", "varname" => "firefoxbd_at_103_6_168_141__ffxbderp_uggroups", "altvarname" => "ffxbderp_uggroups", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ffxbderp_ugmembers", "varname" => "firefoxbd_at_103_6_168_141__ffxbderp_ugmembers", "altvarname" => "ffxbderp_ugmembers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ffxbderp_ugrights", "varname" => "firefoxbd_at_103_6_168_141__ffxbderp_ugrights", "altvarname" => "ffxbderp_ugrights", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Fixed_Comments_Shortage", "varname" => "firefoxbd_at_103_6_168_141__Fixed_Comments_Shortage", "altvarname" => "Fixed_Comments_Shortage", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Fright", "varname" => "firefoxbd_at_103_6_168_141__Fright", "altvarname" => "Fright", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Ibws_payment_Duedates_Input", "varname" => "firefoxbd_at_103_6_168_141__Ibws_payment_Duedates_Input", "altvarname" => "Ibws_payment_Duedates_Input", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Imp_Paint_Remarks", "varname" => "firefoxbd_at_103_6_168_141__Imp_Paint_Remarks", "altvarname" => "Imp_Paint_Remarks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Imp_PO", "varname" => "firefoxbd_at_103_6_168_141__Imp_PO", "altvarname" => "Imp_PO", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Item_Unit", "varname" => "firefoxbd_at_103_6_168_141__Item_Unit", "altvarname" => "Item_Unit", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Local_PO", "varname" => "firefoxbd_at_103_6_168_141__Local_PO", "altvarname" => "Local_PO", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Maker", "varname" => "firefoxbd_at_103_6_168_141__Maker", "altvarname" => "Maker", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Modelwise_Input", "varname" => "firefoxbd_at_103_6_168_141__Modelwise_Input", "altvarname" => "Modelwise_Input", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Modelwise_Input_Item", "varname" => "firefoxbd_at_103_6_168_141__Modelwise_Input_Item", "altvarname" => "Modelwise_Input_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Modification_Apps", "varname" => "firefoxbd_at_103_6_168_141__Modification_Apps", "altvarname" => "Modification_Apps", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Modyfication_History", "varname" => "firefoxbd_at_103_6_168_141__Modyfication_History", "altvarname" => "Modyfication_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Packing_Material_Color", "varname" => "firefoxbd_at_103_6_168_141__Packing_Material_Color", "altvarname" => "Packing_Material_Color", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Packing_Materials_Component", "varname" => "firefoxbd_at_103_6_168_141__Packing_Materials_Component", "altvarname" => "Packing_Materials_Component", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Packing_Matrial_Master", "varname" => "firefoxbd_at_103_6_168_141__Packing_Matrial_Master", "altvarname" => "Packing_Matrial_Master", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Paint_Item_Final", "varname" => "firefoxbd_at_103_6_168_141__Paint_Item_Final", "altvarname" => "Paint_Item_Final", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Parts", "varname" => "firefoxbd_at_103_6_168_141__Parts", "altvarname" => "Parts", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Payterms_new", "varname" => "firefoxbd_at_103_6_168_141__Payterms_new", "altvarname" => "Payterms_new", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PC_Head", "varname" => "firefoxbd_at_103_6_168_141__PC_Head", "altvarname" => "PC_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PC_Item", "varname" => "firefoxbd_at_103_6_168_141__PC_Item", "altvarname" => "PC_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Pc_Terms", "varname" => "firefoxbd_at_103_6_168_141__Pc_Terms", "altvarname" => "Pc_Terms", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_A_Head", "altvarname" => "PI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_B_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_B_Head", "altvarname" => "PI_Imp_B_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_B_Item", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_B_Item", "altvarname" => "PI_Imp_B_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_C_Head", "altvarname" => "PI_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_F_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_F_Head", "altvarname" => "PI_Imp_F_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_F_Item", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_F_Item", "altvarname" => "PI_Imp_F_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_R_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_R_Head", "altvarname" => "PI_Imp_R_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_R_Item", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_R_Item", "altvarname" => "PI_Imp_R_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_A_Head", "altvarname" => "PO_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_B_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_B_Head", "altvarname" => "PO_Imp_B_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_C_Head", "altvarname" => "PO_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_Head", "altvarname" => "PO_Imp_F_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_Item", "altvarname" => "PO_Imp_F_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_R_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_R_Head", "altvarname" => "PO_Imp_R_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_R_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_R_Item", "altvarname" => "PO_Imp_R_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Loc_F_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Loc_F_Head", "altvarname" => "PO_Loc_F_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Loc_F_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Loc_F_Item", "altvarname" => "PO_Loc_F_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Head", "altvarname" => "PSI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Main", "altvarname" => "PSI_Imp_A_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Head", "altvarname" => "PSI_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Main", "altvarname" => "PSI_Imp_C_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Reminder_Head", "varname" => "firefoxbd_at_103_6_168_141__Reminder_Head", "altvarname" => "Reminder_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Sc_Head", "varname" => "firefoxbd_at_103_6_168_141__Sc_Head", "altvarname" => "Sc_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "SC_Item", "varname" => "firefoxbd_at_103_6_168_141__SC_Item", "altvarname" => "SC_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Shipping_Marks", "varname" => "firefoxbd_at_103_6_168_141__Shipping_Marks", "altvarname" => "Shipping_Marks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Amendments", "varname" => "firefoxbd_at_103_6_168_141__Spec_Amendments", "altvarname" => "Spec_Amendments", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Amendments_Item", "varname" => "firefoxbd_at_103_6_168_141__Spec_Amendments_Item", "altvarname" => "Spec_Amendments_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Comp", "varname" => "firefoxbd_at_103_6_168_141__Spec_Comp", "altvarname" => "Spec_Comp", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Group", "varname" => "firefoxbd_at_103_6_168_141__Spec_Group", "altvarname" => "Spec_Group", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Group_Item", "varname" => "firefoxbd_at_103_6_168_141__Spec_Group_Item", "altvarname" => "Spec_Group_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Item_Color", "varname" => "firefoxbd_at_103_6_168_141__Spec_Item_Color", "altvarname" => "Spec_Item_Color", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Kids_Head", "varname" => "firefoxbd_at_103_6_168_141__Spec_Kids_Head", "altvarname" => "Spec_Kids_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_Material", "varname" => "firefoxbd_at_103_6_168_141__Spec_Material", "altvarname" => "Spec_Material", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_C_Isu_Head", "varname" => "firefoxbd_at_103_6_168_141__ST_C_Isu_Head", "altvarname" => "ST_C_Isu_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_C_Isu_Item", "varname" => "firefoxbd_at_103_6_168_141__ST_C_Isu_Item", "altvarname" => "ST_C_Isu_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_Department", "varname" => "firefoxbd_at_103_6_168_141__ST_Department", "altvarname" => "ST_Department", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_Item", "varname" => "firefoxbd_at_103_6_168_141__ST_Item", "altvarname" => "ST_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_Swap_IBWS", "varname" => "firefoxbd_at_103_6_168_141__ST_Swap_IBWS", "altvarname" => "ST_Swap_IBWS", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Supplier", "varname" => "firefoxbd_at_103_6_168_141__Supplier", "altvarname" => "Supplier", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Title", "varname" => "firefoxbd_at_103_6_168_141__Title", "altvarname" => "Title", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "webusers", "varname" => "firefoxbd_at_103_6_168_141__webusers", "altvarname" => "webusers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( $schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection(\''. $tbl["connId"] .'\');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>