<?php
class ConnectionManager
{
	/**
	 * Cached Connection objects
	 * @type Array
	 */
	protected $cache = array();

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsData;

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsIdByName = array();

	
	/**
	 * An array storing the correspondence between project
	 * datasource tables names and connections ids
	 * @type Array
	 */	
	protected $_tablesConnectionIds;
	
	
	/**
	 * @constructor
	 */
	function __construct()
	{
		$this->_setConnectionsData();
		$this->_setTablesConnectionIds();
	}
	
	/**
	 * Get connection object by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function byTable( $tName )
	{
		$connId = $this->_tablesConnectionIds[ $tName ];
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection object by the connection name
	 * @param String connName
	 * @return Connection
	 */	
	public function byName( $connName )
	{
		$connId = $this->getIdByName( $connName );
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}
	
	/**
	 * Get connection id by the connection name
	 * @param String connName
	 * @return String
	 */	
	protected function getIdByName( $connName )
	{
		return $this->_connectionsIdByName[ $connName ];
	}
	
	/**
	 * Get connection object by the connection id 
	 * @param String connId
	 * @return Connection
	 */	
	public function byId( $connId )
	{
		if( !isset( $this->cache[ $connId ] ) )
			$this->cache[ $connId ] = $this->getConnection( $connId );

		return $this->cache[ $connId ];
	}
	
	/**
	 * Get the default db connection class
	 * @return Connection
	 */
	public function getDefault()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}

	/**
	 * Get the users table db connection 
	 * @return Connection
	 */	
	public function getForLogin()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}
	
	/**
	 * Get the log table db connection 
	 * @return Connection
	 */	
	public function getForAudit()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}
	
	/**
	 * Get the locking table db connection 
	 * @return Connection
	 */		
	public function getForLocking()
	{
		return $this->getDefault();
	}	
	
	/**
	 * Get the 'ug_groups' table db connection 
	 * @return Connection
	 */	
	public function getForUserGroups()
	{
		return $this->byId( "firefoxbd_at_localhost" );
	}		

	/**
	 * Get the saved searches table db connection 
	 * @return Connection
	 */	
	public function getForSavedSearches()
	{
		return $this->getDefault();
	}

	/**
	 * Get the webreports tables db connection 
	 * @return Connection
	 */		
	public function getForWebReports()
	{
		return $this->getDefault();
	}
	
	/**
	 * @param String connId
	 * @return Connection
	 */
	protected function getConnection( $connId )
	{
		include_once getabspath("connections/Connection.php");
		
		$data = $this->_connectionsData[ $connId ];	
		switch( $data["connStringType"] )
		{
			case "mysql":
				if( useMySQLiLib() )
				{
					include_once getabspath("connections/MySQLiConnection.php");
					return new MySQLiConnection( $data );
				}
				
				include_once getabspath("connections/MySQLConnection.php");	
				return new MySQLConnection( $data );	

			case "mssql":
			case "compact":
				if( useMSSQLWinConnect() )
				{
					include_once getabspath("connections/MSSQLWinConnection.php");
					return new MSSQLWinConnection( $data );
				}
				if( isSqlsrvExtLoaded() )
				{
					include_once getabspath("connections/MSSQLSrvConnection.php");	
					return new MSSQLSrvConnection( $data );
				}
				
				if( function_exists("mssql_connect") ) {
					include_once getabspath("connections/MSSQLUnixConnection.php");
					return new MSSQLUnixConnection( $data );			
				}

				if( class_exists("PDO") ) {
					include_once getabspath("connections/PDOConnection.php");
					$drivers = pdo_drivers();
					if( in_array( "sqlsrv", $drivers) )
					{
						$data["PDOString"] = "sqlsrv:Server=" . $data["connInfo"][0] . ";Database=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
					if( in_array( "dblib", $drivers) )
					{
						$data["PDOString"] = "dblib:host=" . $data["connInfo"][0] . ";dbname=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
				}
				echo "No SQL Server driver found in your PHP settings.";
				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
					echo "<br>To enable SQL Server support add the following line to php.ini file:";
					echo "<br>extension=php_com_dotnet.dll";
				}
				exit();

			case "msaccess":
			case "odbc":
			case "odbcdsn":
			case "custom":
			case "file":
				if( stripos($data["ODBCString"], 'Provider=') !== false )
				{
					include_once getabspath("connections/ADOConnection.php");
					return new ADOConnection( $data );
				}
				
				include_once getabspath("connections/ODBCConnection.php");
				return new ODBCConnection( $data );
			
			case "oracle":
				include_once getabspath("connections/OracleConnection.php");
				return new OracleConnection( $data );

			case "postgre":
				include_once getabspath("connections/PostgreConnection.php");
				return new PostgreConnection( $data );

			case "db2":
				include_once getabspath("connections/DB2Connection.php");
				return new DB2Connection( $data );

			case "informix":
				include_once getabspath("connections/InformixConnection.php");
				return new InformixConnection( $data );

			case "sqlite":
				include_once getabspath("connections/SQLite3Connection.php");
				return new SQLite3Connection( $data );
			case "pdo":
				include_once getabspath("connections/PDOConnection.php");
				return new PDOConnection( $data );
		}
	}

	public function getConectionsIds()
	{
		$connectionsIds = array();
		foreach ($this->_connectionsData as $connId => $data) {
			$connectionsIds[] = $connId;
		}

		return $connectionsIds;
	}

	/**
	 * Set the data representing the project's 
	 * db connection properties
	 */	 
	protected function _setConnectionsData()
	{
		// content of this function can be modified on demo account
		// variable names $data and $connectionsData are important

		$connectionsData = array();
		
		$data = array();
		$data["dbType"] = 0;
		$data["connId"] = "firefoxbd_at_localhost";
		$data["connName"] = "firefoxbd at 103.6.168.141";
		$data["connStringType"] = "mysql";
		$data["connectionString"] = "mysql;103.6.168.141;Admin;5MQFX49p2Z8a@777;;firefoxbd;;1"; //currently unused

		$this->_connectionsIdByName["firefoxbd at 103.6.168.141"] = "firefoxbd_at_localhost";
		
		$data["connInfo"] = array();
		$data["ODBCUID"] = "Admin";
		$data["ODBCPWD"] = "5MQFX49p2Z8a@777";
		$data["leftWrap"] = "`";
		$data["rightWrap"] = "`";
		
		$data["DBPath"] = "db"; //currently unused	
		$data["useServerMapPath"] = 1; //currently unused
		
		$data["connInfo"][0] = "103.6.168.141";
		$data["connInfo"][1] = "Admin";
		$data["connInfo"][2] = "5MQFX49p2Z8a@777";
		$data["connInfo"][3] = "";
		$data["connInfo"][4] = "firefoxbd";
		$data["connInfo"][5] = ""; //currently unused
		$data["connInfo"][6] = "1"; //currently unused
		$data["ODBCString"] = "DRIVER={MySQL ODBC 3.51 Driver};Server=103.6.168.141;Uid=Admin;Pwd=5MQFX49p2Z8a@777;Database=firefoxbd;OPTION=3";
		// encription set
		$data["EncryptInfo"] = array();
		$data["EncryptInfo"]["mode"] = 0;
		$data["EncryptInfo"]["alg"]  = 128;
		$data["EncryptInfo"]["key"]  = "";

		$connectionsData["firefoxbd_at_localhost"] = $data;
		$this->_connectionsData = $connectionsData;
	}
	
	/**
	 * Set the data representing the correspondence between 
	 * the project's table names and db connections
	 */	 
	protected function _setTablesConnectionIds()
	{
		$connectionsIds = array();
		$connectionsIds["Destinations"] = "firefoxbd_at_localhost";
		$connectionsIds["Loading_Ports"] = "firefoxbd_at_localhost";
		$connectionsIds["SC_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["Shipping_Marks"] = "firefoxbd_at_localhost";
		$connectionsIds["webusers"] = "firefoxbd_at_localhost";
		$connectionsIds["BD_Model"] = "firefoxbd_at_localhost";
		$connectionsIds["Payterms_new"] = "firefoxbd_at_localhost";
		$connectionsIds["Customer"] = "firefoxbd_at_localhost";
		$connectionsIds["Country"] = "firefoxbd_at_localhost";
		$connectionsIds["Region"] = "firefoxbd_at_localhost";
		$connectionsIds["Title"] = "firefoxbd_at_localhost";
		$connectionsIds["AFKT_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["BD_Bike_Model"] = "firefoxbd_at_localhost";
		$connectionsIds["Comp_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Category"] = "firefoxbd_at_localhost";
		$connectionsIds["Currency"] = "firefoxbd_at_localhost";
		$connectionsIds["BL_Shipper"] = "firefoxbd_at_localhost";
		$connectionsIds["Factory"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Paint_New"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_China_Sea_Frt"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_TTT_New"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Ckd"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Pkg"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Dep"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Fixed"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Var_OH"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_UP_Down"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Rimmaterials"] = "firefoxbd_at_localhost";
		$connectionsIds["BD_Meetings"] = "firefoxbd_at_localhost";
		$connectionsIds["Customer_Comments"] = "firefoxbd_at_localhost";
		$connectionsIds["Customer_Pkg_Report"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Group"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Type"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Material"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Group_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Fork_Master"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Price_List"] = "firefoxbd_at_localhost";
		$connectionsIds["Customer_Create_SC"] = "firefoxbd_at_localhost";
		$connectionsIds["User_Rights"] = "firefoxbd_at_localhost";
		$connectionsIds["PC_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PC_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Pc_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Pc_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Group"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Size"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Material"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Type"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Frame"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Brake"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Rimtype"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Decal"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Speed"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Gear"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Shifter"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Rim"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Fork"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Paint"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Spoke"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_En"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Tyre"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Pkg"] = "firefoxbd_at_localhost";
		$connectionsIds["Model_Valve"] = "firefoxbd_at_localhost";
		$connectionsIds["Term_From_After"] = "firefoxbd_at_localhost";
		$connectionsIds["Cash_Flow_DaillyItems"] = "firefoxbd_at_localhost";
		$connectionsIds["Cash_Flow_MainItems"] = "firefoxbd_at_localhost";
		$connectionsIds["Maker"] = "firefoxbd_at_localhost";
		$connectionsIds["Item_Unit"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Item_FW"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Item_RW"] = "firefoxbd_at_localhost";
		$connectionsIds["SC_Spec_Comp"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Reusable"] = "firefoxbd_at_localhost";
		$connectionsIds["Replacement_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Artwork_Master"] = "firefoxbd_at_localhost";
		$connectionsIds["IM_Master"] = "firefoxbd_at_localhost";
		$connectionsIds["Frame_Drawing_Master"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Item_Frsize"] = "firefoxbd_at_localhost";
		$connectionsIds["Gsp_Bom_costing"] = "firefoxbd_at_localhost";
		$connectionsIds["Ibws_Head_Inv"] = "firefoxbd_at_localhost";
		$connectionsIds["Ibws_Inv_Plus_Minus2"] = "firefoxbd_at_localhost";
		$connectionsIds["Ibws_Inv_Remarks2"] = "firefoxbd_at_localhost";
		$connectionsIds["Pc_Terms"] = "firefoxbd_at_localhost";
		$connectionsIds["BL_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["BL_Cont_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["BL_Cont_Inv"] = "firefoxbd_at_localhost";
		$connectionsIds["BD_Shipping_Advice"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Amendments"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Amendments_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Kids_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Sp_Kitem"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_History"] = "firefoxbd_at_localhost";
		$connectionsIds["Ex_Rate"] = "firefoxbd_at_localhost";
		$connectionsIds["Forwaders"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_Item_Color"] = "firefoxbd_at_localhost";
		$connectionsIds["CERT_Nutral"] = "firefoxbd_at_localhost";
		$connectionsIds["Cert_Content"] = "firefoxbd_at_localhost";
		$connectionsIds["Cert_Name"] = "firefoxbd_at_localhost";
		$connectionsIds["Cert_Title"] = "firefoxbd_at_localhost";
		$connectionsIds["Weldingstatus"] = "firefoxbd_at_localhost";
		$connectionsIds["Welding_Status"] = "firefoxbd_at_localhost";
		$connectionsIds["SC_Options"] = "firefoxbd_at_localhost";
		$connectionsIds["Agent_Master_Fty"] = "firefoxbd_at_localhost";
		$connectionsIds["Fright"] = "firefoxbd_at_localhost";
		$connectionsIds["Fty_Ports"] = "firefoxbd_at_localhost";
		$connectionsIds["Packing"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts"] = "firefoxbd_at_localhost";
		$connectionsIds["Container_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Container_Data"] = "firefoxbd_at_localhost";
		$connectionsIds["Exp_Inv_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_F_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_F_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_Imp_F_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["Imp_F_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["Supplier"] = "firefoxbd_at_localhost";
		$connectionsIds["Fixed_refer"] = "firefoxbd_at_localhost";
		$connectionsIds["Fixed_refer1"] = "firefoxbd_at_localhost";
		$connectionsIds["Fixed_refer2"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_F_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_F_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_F_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_F_Remarks"] = "firefoxbd_at_localhost";
		$connectionsIds["PSI_Imp_F_plusminus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_F_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_F_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_F_Pack"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_F_Plus_Minus"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_F_Rmks"] = "firefoxbd_at_localhost";
		$connectionsIds["PI_Imp_F_Pack_New"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts1D"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts1D1"] = "firefoxbd_at_localhost";
		$connectionsIds["Parts1D11"] = "firefoxbd_at_localhost";
		$connectionsIds["Fixed_InvRefpack"] = "firefoxbd_at_localhost";
		$connectionsIds["CusDec"] = "firefoxbd_at_localhost";
		$connectionsIds["CusDec1"] = "firefoxbd_at_localhost";
		$connectionsIds["Offer_Head"] = "firefoxbd_at_localhost";
		$connectionsIds["Offer_Item"] = "firefoxbd_at_localhost";
		$connectionsIds["Sc_Head1"] = "firefoxbd_at_localhost";
		$connectionsIds["Temp_SC"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_SC_BDBK"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_Sc_Bike"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_Sc_Comp"] = "firefoxbd_at_localhost";
		$connectionsIds["Offer_List"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_withrevision"] = "firefoxbd_at_localhost";
		$connectionsIds["Ref_BLNO"] = "firefoxbd_at_localhost";
		$connectionsIds["Forwaders_Local"] = "firefoxbd_at_localhost";
		$connectionsIds["ST_Item_Fixed"] = "firefoxbd_at_localhost";
		$connectionsIds["Agent_Master"] = "firefoxbd_at_localhost";
		$connectionsIds["admin_rights"] = "firefoxbd_at_localhost";
		$connectionsIds["admin_members"] = "firefoxbd_at_localhost";
		$connectionsIds["admin_users"] = "firefoxbd_at_localhost";
		$connectionsIds["Departments"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_withrevision1"] = "firefoxbd_at_localhost";
		$connectionsIds["Spec_withrevision2"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_F_List"] = "firefoxbd_at_localhost";
		$connectionsIds["PO_PSI_Imp_F"] = "firefoxbd_at_localhost";
		$connectionsIds["Applications"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Main"] = "firefoxbd_at_localhost";
		$connectionsIds["Decimal_Val"] = "firefoxbd_at_localhost";
		$connectionsIds["Cost_Customer"] = "firefoxbd_at_localhost";
		$connectionsIds["TC_Modelwise"] = "firefoxbd_at_localhost";
		$connectionsIds["BD_Model1"] = "firefoxbd_at_localhost";
		$connectionsIds["BD_Model11"] = "firefoxbd_at_localhost";
		$connectionsIds["Fixed_Comments_Shortage"] = "firefoxbd_at_localhost";
		$this->_tablesConnectionIds = $connectionsIds;
	}
	
	/**
	 * Check if It's possible to add to one table's sql query 
	 * an sql subquery to another table.
	 * Access doesn't support subqueries from the same table as main.
	 * @param String dataSourceTName1
	 * @param String dataSourceTName2
	 * @return Boolean
	 */
	public function checkTablesSubqueriesSupport( $dataSourceTName1, $dataSourceTName2 )
	{
		$connId1 = $this->_tablesConnectionIds[ $dataSourceTName1 ];
		$connId2 = $this->_tablesConnectionIds[ $dataSourceTName2 ];
		
		if( $connId1 != $connId2 )
			return false;

		if( $this->_connectionsData[ $connId1 ]["dbType"] == nDATABASE_Access && $dataSourceTName1 == $dataSourceTName2 )
			return false;
			
		return true;	
	}
	
	/**
	 * Close db connections
	 * @destructor
	 */
	function __desctruct() 
	{
		foreach( $this->cache as $connection )
		{
			$connection->close();
		}
	}
}
?>