<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("webusers");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblfirefoxbd_at_localhost__tbl0_China_Title;
	var $tblfirefoxbd_at_localhost__Agent_Master;
	var $tblfirefoxbd_at_localhost__BD_Model;
	var $tblfirefoxbd_at_localhost__corvoproject_audit;
	var $tblfirefoxbd_at_localhost__Currency;
	var $tblfirefoxbd_at_localhost__Customer;
	var $tblfirefoxbd_at_localhost__Destinations;
	var $tblfirefoxbd_at_localhost__Exp_Inv_Cont;
	var $tblfirefoxbd_at_localhost__Export_Advice_Item;
	var $tblfirefoxbd_at_localhost__ffxbderp_uggroups;
	var $tblfirefoxbd_at_localhost__ffxbderp_ugmembers;
	var $tblfirefoxbd_at_localhost__ffxbderp_ugrights;
	var $tblfirefoxbd_at_localhost__Fright;
	var $tblfirefoxbd_at_localhost__Imp_F_Remarks;
	var $tblfirefoxbd_at_localhost__Imp_PO_F_SC;
	var $tblfirefoxbd_at_localhost__Invoice_Contnew;
	var $tblfirefoxbd_at_localhost__Invoice_Ex_Item;
	var $tblfirefoxbd_at_localhost__Invoice_Ex_Pack;
	var $tblfirefoxbd_at_localhost__Invoice_Head;
	var $tblfirefoxbd_at_localhost__Invoice_item;
	var $tblfirefoxbd_at_localhost__Invoice_Pack;
	var $tblfirefoxbd_at_localhost__Invoice_Plus_Minus;
	var $tblfirefoxbd_at_localhost__Invoice_Remarks;
	var $tblfirefoxbd_at_localhost__Loading_Head;
	var $tblfirefoxbd_at_localhost__Loading_Ports;
	var $tblfirefoxbd_at_localhost__Parts;
	var $tblfirefoxbd_at_localhost__Payterms_new;
	var $tblfirefoxbd_at_localhost__Pc_Terms;
	var $tblfirefoxbd_at_localhost__PO_Imp_F_Head;
	var $tblfirefoxbd_at_localhost__PO_Imp_F_Item;
	var $tblfirefoxbd_at_localhost__PO_Imp_F_Plus_Minus;
	var $tblfirefoxbd_at_localhost__SC_Item;
	var $tblfirefoxbd_at_localhost__Shipping_Marks;
	var $tblfirefoxbd_at_localhost__SHP_Adv_Data;
	var $tblfirefoxbd_at_localhost__SHP_Adv_Head;
	var $tblfirefoxbd_at_localhost__ST_Item_Fixed;
	var $tblfirefoxbd_at_localhost__Supplier;
	var $tblfirefoxbd_at_localhost__Term_From_After;
	var $tblfirefoxbd_at_localhost__Title;
	var $tblfirefoxbd_at_localhost__webusers;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "0_China_Title", "varname" => "firefoxbd_at_localhost__tbl0_China_Title", "altvarname" => "tbl0_China_Title", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Agent_Master", "varname" => "firefoxbd_at_localhost__Agent_Master", "altvarname" => "Agent_Master", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "BD_Model", "varname" => "firefoxbd_at_localhost__BD_Model", "altvarname" => "BD_Model", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "corvoproject_audit", "varname" => "firefoxbd_at_localhost__corvoproject_audit", "altvarname" => "corvoproject_audit", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Currency", "varname" => "firefoxbd_at_localhost__Currency", "altvarname" => "Currency", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer", "varname" => "firefoxbd_at_localhost__Customer", "altvarname" => "Customer", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Destinations", "varname" => "firefoxbd_at_localhost__Destinations", "altvarname" => "Destinations", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Exp_Inv_Cont", "varname" => "firefoxbd_at_localhost__Exp_Inv_Cont", "altvarname" => "Exp_Inv_Cont", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Advice_Item", "varname" => "firefoxbd_at_localhost__Export_Advice_Item", "altvarname" => "Export_Advice_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_uggroups", "varname" => "firefoxbd_at_localhost__ffxbderp_uggroups", "altvarname" => "ffxbderp_uggroups", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_ugmembers", "varname" => "firefoxbd_at_localhost__ffxbderp_ugmembers", "altvarname" => "ffxbderp_ugmembers", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_ugrights", "varname" => "firefoxbd_at_localhost__ffxbderp_ugrights", "altvarname" => "ffxbderp_ugrights", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Fright", "varname" => "firefoxbd_at_localhost__Fright", "altvarname" => "Fright", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Imp_F_Remarks", "varname" => "firefoxbd_at_localhost__Imp_F_Remarks", "altvarname" => "Imp_F_Remarks", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Imp_PO_F_SC", "varname" => "firefoxbd_at_localhost__Imp_PO_F_SC", "altvarname" => "Imp_PO_F_SC", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Contnew", "varname" => "firefoxbd_at_localhost__Invoice_Contnew", "altvarname" => "Invoice_Contnew", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Ex_Item", "varname" => "firefoxbd_at_localhost__Invoice_Ex_Item", "altvarname" => "Invoice_Ex_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Ex_Pack", "varname" => "firefoxbd_at_localhost__Invoice_Ex_Pack", "altvarname" => "Invoice_Ex_Pack", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Head", "varname" => "firefoxbd_at_localhost__Invoice_Head", "altvarname" => "Invoice_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_item", "varname" => "firefoxbd_at_localhost__Invoice_item", "altvarname" => "Invoice_item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Pack", "varname" => "firefoxbd_at_localhost__Invoice_Pack", "altvarname" => "Invoice_Pack", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Plus_Minus", "varname" => "firefoxbd_at_localhost__Invoice_Plus_Minus", "altvarname" => "Invoice_Plus_Minus", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Remarks", "varname" => "firefoxbd_at_localhost__Invoice_Remarks", "altvarname" => "Invoice_Remarks", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Loading_Head", "varname" => "firefoxbd_at_localhost__Loading_Head", "altvarname" => "Loading_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Loading_Ports", "varname" => "firefoxbd_at_localhost__Loading_Ports", "altvarname" => "Loading_Ports", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Parts", "varname" => "firefoxbd_at_localhost__Parts", "altvarname" => "Parts", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Payterms_new", "varname" => "firefoxbd_at_localhost__Payterms_new", "altvarname" => "Payterms_new", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Pc_Terms", "varname" => "firefoxbd_at_localhost__Pc_Terms", "altvarname" => "Pc_Terms", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PO_Imp_F_Head", "varname" => "firefoxbd_at_localhost__PO_Imp_F_Head", "altvarname" => "PO_Imp_F_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PO_Imp_F_Item", "varname" => "firefoxbd_at_localhost__PO_Imp_F_Item", "altvarname" => "PO_Imp_F_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PO_Imp_F_Plus_Minus", "varname" => "firefoxbd_at_localhost__PO_Imp_F_Plus_Minus", "altvarname" => "PO_Imp_F_Plus_Minus", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "SC_Item", "varname" => "firefoxbd_at_localhost__SC_Item", "altvarname" => "SC_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Shipping_Marks", "varname" => "firefoxbd_at_localhost__Shipping_Marks", "altvarname" => "Shipping_Marks", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "SHP_Adv_Data", "varname" => "firefoxbd_at_localhost__SHP_Adv_Data", "altvarname" => "SHP_Adv_Data", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "SHP_Adv_Head", "varname" => "firefoxbd_at_localhost__SHP_Adv_Head", "altvarname" => "SHP_Adv_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ST_Item_Fixed", "varname" => "firefoxbd_at_localhost__ST_Item_Fixed", "altvarname" => "ST_Item_Fixed", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Supplier", "varname" => "firefoxbd_at_localhost__Supplier", "altvarname" => "Supplier", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Term_From_After", "varname" => "firefoxbd_at_localhost__Term_From_After", "altvarname" => "Term_From_After", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Title", "varname" => "firefoxbd_at_localhost__Title", "altvarname" => "Title", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "webusers", "varname" => "firefoxbd_at_localhost__webusers", "altvarname" => "webusers", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( $schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection(\''. $tbl["connId"] .'\');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>