<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["im_master.Customer_Name"] )) {
			$lookupTableLinks["Customer"]["im_master.Customer_Name"] = array();
		}
		$lookupTableLinks["Customer"]["im_master.Customer_Name"]["edit"] = array("table" => "IM_Master", "field" => "Customer_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["IM_Customer_Brand"] ) ) {
			$lookupTableLinks["IM_Customer_Brand"] = array();
		}
		if( !isset( $lookupTableLinks["IM_Customer_Brand"]["im_master.Cus_Brandname"] )) {
			$lookupTableLinks["IM_Customer_Brand"]["im_master.Cus_Brandname"] = array();
		}
		$lookupTableLinks["IM_Customer_Brand"]["im_master.Cus_Brandname"]["edit"] = array("table" => "IM_Master", "field" => "Cus_Brandname", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["frame_drawing_master.Model_Name"] )) {
			$lookupTableLinks["BD_Model"]["frame_drawing_master.Model_Name"] = array();
		}
		$lookupTableLinks["BD_Model"]["frame_drawing_master.Model_Name"]["edit"] = array("table" => "Frame_Drawing_Master", "field" => "Model_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Factory"] ) ) {
			$lookupTableLinks["Factory"] = array();
		}
		if( !isset( $lookupTableLinks["Factory"]["frame_drawing_master.FTY"] )) {
			$lookupTableLinks["Factory"]["frame_drawing_master.FTY"] = array();
		}
		$lookupTableLinks["Factory"]["frame_drawing_master.FTY"]["edit"] = array("table" => "Frame_Drawing_Master", "field" => "FTY", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["frame_drawing_master.Customer"] )) {
			$lookupTableLinks["Customer"]["frame_drawing_master.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["frame_drawing_master.Customer"]["edit"] = array("table" => "Frame_Drawing_Master", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["artwork_master.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["artwork_master.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["artwork_master.Sc_No"]["edit"] = array("table" => "Artwork_Master", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["artwork_master.Ref_Seq_No"] )) {
			$lookupTableLinks["SC_Item1"]["artwork_master.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item1"]["artwork_master.Ref_Seq_No"]["edit"] = array("table" => "Artwork_Master", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["artwork_master.Customer"] )) {
			$lookupTableLinks["Customer"]["artwork_master.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["artwork_master.Customer"]["edit"] = array("table" => "Artwork_Master", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["others_upload.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["others_upload.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["others_upload.Sc_No"]["edit"] = array("table" => "Others_Upload", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["others_upload.Ref_Seq_No"] )) {
			$lookupTableLinks["SC_Item1"]["others_upload.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item1"]["others_upload.Ref_Seq_No"]["edit"] = array("table" => "Others_Upload", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["others_upload.Customer"] )) {
			$lookupTableLinks["Customer"]["others_upload.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["others_upload.Customer"]["edit"] = array("table" => "Others_Upload", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Upload_Description"] ) ) {
			$lookupTableLinks["Upload_Description"] = array();
		}
		if( !isset( $lookupTableLinks["Upload_Description"]["others_upload.Description"] )) {
			$lookupTableLinks["Upload_Description"]["others_upload.Description"] = array();
		}
		$lookupTableLinks["Upload_Description"]["others_upload.Description"]["edit"] = array("table" => "Others_Upload", "field" => "Description", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Group"] ) ) {
			$lookupTableLinks["Spec_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Group"]["upload_spec_comp.Group_ID"] )) {
			$lookupTableLinks["Spec_Group"]["upload_spec_comp.Group_ID"] = array();
		}
		$lookupTableLinks["Spec_Group"]["upload_spec_comp.Group_ID"]["edit"] = array("table" => "Upload_Spec_Comp", "field" => "Group_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Group_Item"] ) ) {
			$lookupTableLinks["Spec_Group_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Group_Item"]["upload_spec_comp.Model_No"] )) {
			$lookupTableLinks["Spec_Group_Item"]["upload_spec_comp.Model_No"] = array();
		}
		$lookupTableLinks["Spec_Group_Item"]["upload_spec_comp.Model_No"]["edit"] = array("table" => "Upload_Spec_Comp", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["frame_drawing_item.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["frame_drawing_item.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["frame_drawing_item.Sc_No"]["edit"] = array("table" => "Frame_Drawing_Item", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item1"] ) ) {
			$lookupTableLinks["SC_Item1"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item1"]["frame_drawing_item.Ref_seq_No"] )) {
			$lookupTableLinks["SC_Item1"]["frame_drawing_item.Ref_seq_No"] = array();
		}
		$lookupTableLinks["SC_Item1"]["frame_drawing_item.Ref_seq_No"]["edit"] = array("table" => "Frame_Drawing_Item", "field" => "Ref_seq_No", "page" => "edit");
}

?>