<?php
date_default_timezone_set("Asia/Dhaka");
if($_POST["excel"]=="checkbox"){
	header('Content-type: application/ms-excel');
	header('Content-Disposition: attachment; filename=excelreport.xls');
}

require('dbcon.php');
$today=date("Y-m-d");
$where="";
$where="(Item_Code_Main BETWEEN '".$_POST['tubef']."' AND '".$_POST['tubet']."')";
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8" />
		<title>Tube Summary Report</title>
		<style>
			body{
				font-family:Century Gothic;
				font-size:14px;
			}
			b{
				font-size:16px;
			}
			td{
				padding:2px;
			}
		</style>
	</head>
	<body>
		<?php
		if($_POST['excel']!="checkbox"){
		?>
			<a href="menu.php">Home</a><br />
		<?php
		}
		?>
		<div><b>Tube Summary Report</b></div><br />
		<table border="1" cellpadding="0" cellspacing="0" style="text-align:center;">
			<tr>			
				<td rowspan="2">Item Code</td>
				<td rowspan="2">Length</td>
				<td rowspan="2">TEMP BIN Total SC Allocation Qty</td>
				<td rowspan="2">TEMP BIN Total PO Qty</td>
				<td rowspan="2">TRI BIN Total PO Qty</td>
				<td rowspan="2">Not Received Yet PO Qty</td>
				<td rowspan="2">Not Received Yet PO</td>
				<td rowspan="2">TRI GRN</td>
				<td rowspan="2">RR GRN</td>
				<td rowspan="2">TRI GIN</td>
				<td rowspan="2">RR GIN</td>
				<td>Substores stock as at</td>
				<td>TRI Physical Stock as at</td>
				<td>Cutting WIP</td>
				<td>Shortage/Gain Tube Qty</td>
				<td rowspan="2">New TEMP Balance</td>
				<td rowspan="2">Balance to Produce</td>
				<td rowspan="2">Updated Temp Balance</td>
			</tr>
			<tr>
				<td>A</td>
				<td>B</td>
				<td>C</td>
				<td>TRI GRN + RR GRN - (A+B+C)</td>
			</tr>
			<?php
			$sel=$mysqli->query("SELECT Item_Code_Main,Length FROM TRI_Tube_Master WHERE $where GROUP BY Item_Code_Main ORDER BY Item_Code_Main");
			while($row=$sel->fetch_assoc()){
				$Item_Code_Main=$row['Item_Code_Main'];
				$Length=$row['Length'];

				$selss=$mysqli->query("SELECT SUM(Qty) AS SCQty FROM ST_History_FOB_Tube WHERE DocNo='130' AND Part_ID='$Item_Code_Main'");
				$rowss=$selss->fetch_assoc();
				$SCQty=abs($rowss['SCQty']);
				$SCQtys=round($SCQty/($Length*1000),0);

				$selssb=$mysqli->query("SELECT SUM(Qty) AS POQty FROM ST_History_FOB_Tube WHERE DocNo='131' AND Part_ID='$Item_Code_Main'");
				$rowssb=$selssb->fetch_assoc();
				$POQty=$rowssb['POQty'];
				$POQtys=round($POQty/($Length*1000),0);

				$selssbsb=$mysqli->query("SELECT SUM(Qty*SUBSTR(Part_ID,POSITION('-' IN Part_ID)+1)*1000) AS Sub FROM TRI_Sub_ST_History_Tube WHERE (DocNo='115' OR DocNo='116') AND Part_ID LIKE '$Item_Code_Main%'");
				$rowssbsb=$selssbsb->fetch_assoc();
				$Sub=$rowssbsb['Sub'];
				$Subs=round($Sub/($Length*1000),0);

				if($POQty>0 || $SCQty>0){

					$selssc=$mysqli->query("SELECT SUM(Qty) AS TPOQty,SUM(Qty*Length*1000) AS TPOQtyr FROM TRI_ST_History,TRI_Tube_Master WHERE DocNo='31' AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_ST_History.Part_ID");
					$rowssc=$selssc->fetch_assoc();
					$TPOQty=$rowssc['TPOQty'];
					$TPOQtyr=$rowssc['TPOQtyr'];

					$selsscr=$mysqli->query("SELECT SUM(Qty) AS GRN,SUM(Qty*Length*1000) AS GRNr FROM TRI_ST_History,TRI_Tube_Master WHERE DocNo='195' AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_ST_History.Part_ID");
					$rowsscr=$selsscr->fetch_assoc();
					$GRN=$rowsscr['GRN'];
					$GRNr=$rowsscr['GRNr'];

					$selssci=$mysqli->query("SELECT SUM(Qty) AS GIN,SUM(Qty*Length*1000) AS GINr FROM TRI_ST_History,TRI_Tube_Master WHERE DocNo='196' AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_ST_History.Part_ID");
					$rowssci=$selssci->fetch_assoc();
					$GIN=abs($rowssci['GIN']);
					$GINr=abs($rowssci['GINr']);

					$selsscr=$mysqli->query("SELECT SUM(Qty) AS RGRN,SUM(Qty*Length*1000) AS RGRNr FROM TRI_ST_History,TRI_Tube_Master WHERE DocNo='525' AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_ST_History.Part_ID");
					$rowsscr=$selsscr->fetch_assoc();
					$RGRN=$rowsscr['RGRN'];
					$RGRNr=$rowsscr['RGRNr'];

					$selssci=$mysqli->query("SELECT SUM(Qty) AS RGIN,SUM(Qty*Length*1000) AS RGINr FROM TRI_ST_History,TRI_Tube_Master WHERE DocNo='526' AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_ST_History.Part_ID");
					$rowssci=$selssci->fetch_assoc();
					$RGIN=abs($rowssci['RGIN']);
					$RGINr=abs($rowssci['RGINr']);

					$selsscp=$mysqli->query("SELECT SUM(Qty) AS Physical,SUM(Qty*Length*1000) AS Physicalr FROM TRI_ST_History,TRI_Tube_Master WHERE (DocNo='195' OR DocNo='196') AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_ST_History.Part_ID");
					$rowsscp=$selsscp->fetch_assoc();
					$Physical=$rowsscp['Physical'];
					$Physicalr=$rowsscp['Physicalr'];

					$selssctt=$mysqli->query("SELECT SUM(Qty) AS Temp FROM ST_History_FOB_Tube WHERE (DocNo='130' OR DocNo='131' OR DocNo='132') AND Part_ID='$Item_Code_Main'");
					$rowssctt=$selssctt->fetch_assoc();
					$Temp=$rowssctt['Temp'];
					$Temps=round($Temp/($Length*1000),0);

					$PO=0; $POr=0; $pos=""; $ppo="";
					$selssctp=$mysqli->query("SELECT SUM(QTY) AS Qtyk,Length,PO_No,TRI_PO_Imp_B_Item.Item_Code FROM TRI_PO_Imp_B_Head,TRI_PO_Imp_B_Item,TRI_Tube_Master WHERE TRI_PO_Imp_B_Head.Internal=TRI_PO_Imp_B_Item.Internal AND Item_Code_Main='$Item_Code_Main' AND TRI_Tube_Master.Item_Code=TRI_PO_Imp_B_Item.Item_Code GROUP BY PO_No,TRI_PO_Imp_B_Item.Item_Code ORDER BY PO_No,TRI_PO_Imp_B_Item.Item_Code");
					while($rowssctp=$selssctp->fetch_assoc()){
						$PO_No=$rowssctp['PO_No'];
						$Qtyk=$rowssctp['Qtyk'];
						$Lengtht=$rowssctp['Length'];
						$Item_Code=$rowssctp['Item_Code'];
						$selssctps=$mysqli->query("SELECT SUM(ODTQTY) AS Qtys,Internal FROM TRI_PSI_Imp_B_Head,TRI_PSI_Imp_B_Item WHERE TRI_PSI_Imp_B_Head.LineNo=TRI_PSI_Imp_B_Item.LineNo AND CUSPAR='$Item_Code' AND PONUM='$PO_No'");
						$rowssctps=$selssctps->fetch_assoc();
						$Qtys=$rowssctps['Qtys'];
						$PI_Internal=$rowssctps['Internal'];
						if($Qtys==0 || $Qtys==""){
							$PO=$PO+$Qtys;
							$POr=$POr+($Qtys*$Lengtht*1000);
							if($ppo!=$PO_No){
								$ppo=$PO_No;
								if($pos!=""){
									$pos.=",".$PO_No;
								}
								else{
									$pos=$PO_No;
								}
							}
						}
						else if($Qtys<$Qtyk){
							$PO=$PO+($Qtyk-$Qtys);
							$POr=$POr+(($Qtyk-$Qtys)*$Lengtht*1000);
							if($ppo!=$PO_No){
								$ppo=$PO_No;
								if($pos!=""){
									$pos.=",".$PO_No;
								}
								else{
									$pos=$PO_No;
								}
							}
						}

						if($Qtys>0 && $Qtys!=""){
							$selgrr=$mysqli->query("SELECT Invoice_No FROM TRI_PI_Imp_B_Head WHERE PI_Internal='$PI_Internal'");
							$rowgrr=$selgrr->fetch_assoc();
							$Invoice_No=$rowgrr['Invoice_No'];
							if($mysqli->query("SELECT * FROM TRI_ST_B_Rec_Head WHERE Inv_No='$Invoice_No'")->num_rows==0){
								$PO=$PO+$Qtys;
								$POr=$POr+($Qtys*$Lengtht*1000);
								if($ppo!=$PO_No){
									$ppo=$PO_No;
									if($pos!=""){
										$pos.=",".$PO_No;
									}
									else{
										$pos=$PO_No;
									}
								}
							}
						}
					}

					$WIP=0;
					$selsscwip=$mysqli->query("SELECT TRI_Cutting_Wip_Head.Sc_No,TRI_Cutting_Wip_Head.Seq_No FROM TRI_Cutting_Wip_Head,TRI_Cutting_Wip_TimeTable,TRI_Cutting_Wip_Departments,ST_History_FOB_Tube WHERE TRI_Cutting_Wip_Head.Internal=TRI_Cutting_Wip_TimeTable.Internal AND TRI_Cutting_Wip_Departments.LineNo=TRI_Cutting_Wip_TimeTable.LineNo AND Department='Cutting-FT' AND Quantity>'0' AND TRI_Cutting_Wip_Head.Sc_No=ST_History_FOB_Tube.Pc_No AND TRI_Cutting_Wip_Head.Seq_No=ST_History_FOB_Tube.Seq_No AND DocNo='130' AND Part_ID='$Item_Code_Main' GROUP BY TRI_Cutting_Wip_Head.Sc_No,TRI_Cutting_Wip_Head.Seq_No");
					while($rowsscwip=$selsscwip->fetch_assoc()){
						$Sc_No=$rowsscwip['Sc_No'];
						$Seq_No=$rowsscwip['Seq_No'];

						$selswr=$mysqli->query("SELECT Quantity FROM TRI_SC_Item WHERE Sc_No='$Sc_No' AND Seq_No='$Seq_No'");
						$resultswr = $selswr->fetch_array();
						$Quantity=$resultswr['Quantity'];

						$selsdwr=$mysqli->query("SELECT SUM(Quantity) AS WIP FROM TRI_Cutting_Wip_Head,TRI_Cutting_Wip_TimeTable,TRI_Cutting_Wip_Departments WHERE Sc_No='$Sc_No' AND Seq_No='$Seq_No' AND TRI_Cutting_Wip_Head.Internal=TRI_Cutting_Wip_TimeTable.Internal AND TRI_Cutting_Wip_Departments.LineNo=TRI_Cutting_Wip_TimeTable.LineNo AND Department='Cutting-FT' AND Quantity>'0'");
						$resultdwr = $selsdwr->fetch_array();
						$WIPT=$resultdwr['WIP'];

						$sqlstrwhh= $mysqli->query("SELECT SUM(Qty) AS Qtyt FROM ST_History_FOB_Tube WHERE Part_ID='$Item_Code_Main' AND DocNo ='130' AND Pc_No='$Sc_No' AND Seq_No='$Seq_No'");
						$resultswrhh = $sqlstrwhh->fetch_array();
						$Qtyt=abs($resultswrhh['Qtyt']);
						$WIP=$WIP+round(($Qtyt/$Quantity)*$WIPT,0);
					}
					$WIPs=round($WIP/($Length*1000),0);

					$shortage=$GRN+$RGRN-($Physical+$WIPs+$Subs);
					$shortager=round($shortage*$Length*1000,0);

					$Bal_Prod=$SCQty-$WIP;
					$Bal_Prods=$SCQtys-$WIPs;

					$NTemp=($Physical-$Bal_Prods)+$PO;
					$NTempr=round($NTemp*$Length*1000,0);
			?>
					<tr>
						<td rowspan="2"><?php echo $Item_Code_Main; ?></td>
						<td>As MM</td>
						<td><?php if($SCQty>0){ echo number_format($SCQty,0); } ?></td>
						<td><?php if($POQty>0){ echo number_format($POQty,0); } ?></td>
						<td><?php if($TPOQtyr>0){ echo number_format($TPOQtyr,0); } ?></td>
						<td><?php if($POr>0){ echo number_format($POr,0); } ?></td>
						<td rowspan="2"><?php if($pos!=""){ echo $pos; } ?></td>
						<td><?php if($GRNr>0){ echo number_format($GRNr,0); } ?></td>
						<td><?php if($RGRNr>0){ echo number_format($RGRNr,0); } ?></td>
						<td><?php if($GINr>0){ echo number_format($GINr,0); } ?></td>
						<td><?php if($RGINr>0){ echo number_format($RGINr,0); } ?></td>
						<td><?php if($Sub>0){ echo number_format($Sub,0); } ?></td>
						<td><?php if($Physicalr!=0){ echo number_format($Physicalr,0); } ?></td>
						<td><?php if($WIP!=0){ echo number_format($WIP,0); } ?></td>
						<td><?php if($shortager!=0){ if($shortager<0){ echo "<span style='color:#ff0000'>".number_format($shortager,0)."</span>"; } else { echo number_format($shortager,0); } } ?></td>
						<td><?php if($Temp!=0){ if($Temp<0){ echo "<span style='color:#ff0000'>".number_format($Temp,0)."</span>"; } else { echo number_format($Temp,0); } } ?></td>
						<td><?php if($Bal_Prod!=0){ echo number_format($Bal_Prod,0); } ?></td>
						<td><?php if($NTempr!=0){ if($NTempr<0){ echo "<span style='color:#ff0000'>".number_format($NTempr,0)."</span>"; } else { echo number_format($NTempr,0); } } ?></td>
					</tr>
					<tr style="background-color: rgb(220, 230, 241);">
						<td>As Tubes (Pcs)</td>
						<td><?php if($SCQtys>0){ echo number_format($SCQtys,0); } ?></td>
						<td><?php if($POQtys>0){ echo number_format($POQtys,0); } ?></td>
						<td><?php if($TPOQty>0){ echo number_format($TPOQty,0); } ?></td>
						<td><?php if($PO>0){ echo number_format($PO,0); } ?></td>
						<td><?php if($GRN>0){ echo number_format($GRN,0); } ?></td>
						<td><?php if($RGRN>0){ echo number_format($RGRN,0); } ?></td>
						<td><?php if($GIN>0){ echo number_format($GIN,0); } ?></td>
						<td><?php if($RGIN>0){ echo number_format($RGIN,0); } ?></td>
						<td><?php if($Subs>0){ echo number_format($Subs,0); } ?></td>
						<td><?php if($Physical!=0){ echo number_format($Physical,0); } ?></td>
						<td><?php if($WIPs!=0){ echo number_format($WIPs,0); } ?></td>
						<td><?php if($shortage!=0){ if($shortage<0){ echo "<span style='color:#ff0000'>".number_format($shortage,0)."</span>"; } else { echo number_format($shortage,0); } } ?></td>
						<td><?php if($Temps!=0){ if($Temps<0){ echo "<span style='color:#ff0000'>".number_format($Temps,0)."</span>"; } else { echo number_format($Temps,0); } } ?></td>
						<td><?php if($Bal_Prods!=0){ echo number_format($Bal_Prods,0); } ?></td>
						<td><?php if($NTemp!=0){ if($NTemp<0){ echo "<span style='color:#ff0000'>".number_format($NTemp,0)."</span>"; } else { echo number_format($NTemp,0); } } ?></td>
					</tr>
			<?php
				}
			}
			?>
		</table>
	</body>
</html>