<?php
class AuditTrailTable
{
	var $logTableName="corvoproject_audit";
	var $params;
	
	var $strLogin="login";
	var $strFailLogin="failed login";
	var $strLogout="logout";
	var $strChPass="change password";
	var $strAdd="add";
	var $strEdit="edit";
	var $strDelete="delete";
	var $strAccess="access";
	var $strKeysHeader="---Keys";
	var $strFieldsHeader="---Fields";
	var $columnDate="Date";
	var $columnTime="Time";
	var $columnIP="IP";
	var $columnUser="User";
	var $columnTable="Table";
	var $columnAction="Action";
	var $columnKey="Key field";
	var $columnField="Field";
	var $columnOldValue="Old value";
	var $columnNewValue="New value";
	var $attLogin=0;
	var $timeLogin=0;
	var $maxFieldLength;

	/**
	 * @type Connection
	 */
	protected $connection;
	
	function __construct()
	{
		global $cman;
		global $auditMaxFieldLength;
		
		$this->connection = $cman->getForAudit();		
		$this->attLogin=3;
		$this->timeLogin=5;
		$userid="";
		if(@$_SESSION["UserID"])
			$userid=$_SESSION["UserID"];
			
		$this->params=array($_SERVER["REMOTE_ADDR"],$userid);
		
		$this->maxFieldLength = $auditMaxFieldLength;
	}
	
    function LogLogin($pUsername)
    {
		global $globalEvents;
		$retval=true;
		$table="webusers";
		$this->params[1]=$pUsername;
		$arr=array();
		$this->params=array($_SERVER["REMOTE_ADDR"],$_SESSION["UserID"]);
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strLogin, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$this->insert(now(), $this->params[0], $this->params[1], $table, $this->strLogin, "");
		}
		return $retval;
    }
	
    function LogLoginFailed($pUsername)
    {
		global $globalEvents;
		$retval=true;
		$table="webusers";
		$this->params[1]=$pUsername;
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strFailLogin, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$this->insert(now(), $this->params[0], $this->params[1], $table, $this->strFailLogin, "");
		}
		$this->params=array($_SERVER["REMOTE_ADDR"],"");
		return $retval;
    }
	
    function LogLogout()
    {
	global $globalEvents;
	if($_SESSION["UserID"]!="")
	{
		$retval=true;
		$table="webusers";
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strLogout, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$this->insert(now(), $this->params[0], $this->params[1], $table, $this->strLogout, "");
		}
		return $retval;
	}
    }
	
    function LogChPassword()
    {
		global $globalEvents;
		$retval=true;
		$table="webusers";
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strChPass, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$this->insert(now(), $this->params[0], $this->params[1], $table, $this->strChPass, "");
		}
		return $retval;
    }
	
    function LogAdd($str_table,$values,$keys)
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$pSet = new ProjectSettings($str_table);
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strAdd, $this->params, $table, $keys, $values, $arr);
		if($retval)
		{
			$str="";
			if(count($keys)>0)
			{
				$str.=$this->strKeysHeader."\r\n";
				foreach($keys as $idx=>$val)
					$str.=$idx." : ".$val."\r\n";
			}
			$strFields="";
			if($this->logValueEnable($str_table))
			{
				foreach($values as $idx=>$val)
				{
					if($val!="" && !array_key_exists($idx,$keys))
					{
						$strFields.=$idx." [new]: ";
						if(IsBinaryType($pSet->getFieldType($idx)))
							$v="<binary value>";
						else
						{
							$v = str_replace(array("\r\n","\n","\t")," ",$val);
							$v = $this->getMaxLengthSubstr( $v );
						}
						$strFields.=$v."\r\n";
					}
				}
			}
			if($strFields!="")
				$str.=$this->strFieldsHeader."\r\n".$strFields;
			
			$this->insert(now(), $this->params[0], $this->params[1], $str_table, $this->strAdd, $str);
		}
		return $retval;
    }
	
    function LogEdit($str_table,$newvalues,$oldvalues,$keys)
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$pSet = new ProjectSettings($str_table);
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strEdit, $this->params, $table, $keys, $newvalues, $oldvalues);
		if($retval)
		{
			$str="";
			if(count($keys)>0)
			{
				$str.=$this->strKeysHeader."\r\n";
				foreach($newvalues as $idx=>$val)
				{
					if(array_key_exists($idx,$keys))
					{
						if($val!=$oldvalues[$idx])
						{
							$str.=$idx." [old]: ".$oldvalues[$idx]."\r\n";
							$str.=$idx." [new]: ".$val."\r\n";
						}
						else
							$str.=$idx." : ".$val."\r\n";
					}
				}
			}
			$strFields="";
			if($this->logValueEnable($str_table))
			{
				$v="";
				foreach($newvalues as $idx=>$val)
				{
					$type=$pSet->getFieldType($idx);
					if(IsBinaryType($type))
						continue;
					if(IsDateFieldType($type))
					{
						$newvalue=format_datetime_custom(db2time($newvalues[$idx]),"yyyy-MM-dd HH:mm:ss");
						$oldvalue=format_datetime_custom(db2time($oldvalues[$idx]),"yyyy-MM-dd HH:mm:ss");
					}
					else
					{
						$newvalue=$newvalues[$idx];
						$oldvalue=$oldvalues[$idx];
					}
					if($newvalue!=$oldvalue && !array_key_exists($idx,$keys))
					{
						$strFields.=$idx." [old]: ";
						if(IsBinaryType($type))
							$v="<binary value>";
						else
						{
							$v = str_replace(array("\r\n","\n","\t")," ",$oldvalue);
							$v = $this->getMaxLengthSubstr( $v );
						}
						$strFields.=$v."\r\n";
												
						$strFields.=$idx." [new]: ";
						if(IsBinaryType($type))
							$v="<binary value>";
						else
						{
							$v = str_replace(array("\r\n","\n","\t")," ",$newvalue);
							$v = $this->getMaxLengthSubstr( $v );
						}
						$strFields.=$v."\r\n";
					}
				}
				$v="";
			}
			if($strFields!="")
				$str.=$this->strFieldsHeader."\r\n".$strFields;
			
			$this->insert(now(), $this->params[0], $this->params[1], $str_table, $this->strEdit, $str);
		}
		return $retval;
    }
	
    function LogDelete($str_table,$values,$keys)
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$pSet = new ProjectSettings($str_table);
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strDelete, $this->params, $table, $keys, $values, $arr);
		if($retval)
		{
			$str="";
			if(count($keys)>0)
			{
				$str.=$this->strKeysHeader."\r\n";
				foreach($keys as $idx=>$val)
					$str.=$idx." : ".$val."\r\n";
			}
			$strFields="";
			if($this->logValueEnable($str_table))
			{
				$v="";
				foreach($values as $idx=>$val)
				{
					if($val!="" && !array_key_exists($idx,$keys))
					{
						$strFields.=$idx." [old]: ";
						if(IsBinaryType($pSet->getFieldType($idx)))
							$v="<binary value>";
						else
						{	
							$v = str_replace(array("\r\n","\n","\t")," ",$val);
							$v = $this->getMaxLengthSubstr( $v );
						}
						$strFields.=$v."\r\n";
					}
				}
			}
			if($strFields!="")
				$str.=$this->strFieldsHeader."\r\n".$strFields;
			
			$this->insert(now(), $this->params[0], $this->params[1], $str_table, $this->strDelete, $str);
		}
		return $retval;
    }
    
    function LogAddEvent($message,$description="",$stable="")
    {
		global $globalEvents;
		$retval=true;
		$table=$stable;
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($message, $this->params, $table, $keys, $values, $arr);
		if($retval)
		{
			$this->insert(now(), $this->params[0], $this->params[1], $stable, $message, $description);
		}
		return $retval;
    }
	
    function LoginSuccessful()
    {
		if($this->attLogin>0 && $this->timeLogin>0)
		{
			$where = $this->connection->addFieldWrappers("ip"). "=" .$this->connection->prepareString($_SERVER["REMOTE_ADDR"]). 
				" AND " .$this->connection->addFieldWrappers("action"). "=" .$this->connection->prepareString($this->strAccess);
			$sql = "DELETE FROM " .$this->connection->addTableWrappers( $this->logTableName ). " WHERE " .$where;
			
			$this->connection->exec( $sql );
		}
		
    }
	
    function LoginUnsuccessful($pUsername)
    {
		if($this->attLogin>0 && $this->timeLogin>0)
		{
			$this->insert(now(), $_SERVER["REMOTE_ADDR"], $pUsername, "", $this->strAccess, "");
		}
    }
    
	function LoginAccess()
	{
		if( $this->attLogin > 0 && $this->timeLogin > 0 )
		{
			$where = $this->connection->addFieldWrappers("ip"). "=" .$this->connection->prepareString($_SERVER["REMOTE_ADDR"]). 
				" AND " .$this->connection->addFieldWrappers("action"). "=".$this->connection->prepareString("access");
			$orderBy = $this->connection->addFieldWrappers("id")." asc";
			$sql = "SELECT * FROM " .$this->connection->addTableWrappers( $this->logTableName ). " WHERE " .$where. " ORDER BY " .$orderBy;
			
			$qResult = $this->connection->query( $sql );
			
			$i = 0;
			while( $data = $qResult->fetchAssoc() )
			{
				if( secondsPassedFrom($data["datetime"]) / 60 <= $this->timeLogin )
				{
					if($i==0)
						$firstAccess=$data["datetime"];
					$i+=1;
				}
			}
			
			if( $i >= $this->attLogin )
				return ceil($this->timeLogin-secondsPassedFrom($firstAccess) / 60);
		}

		return false;
	}
	
	function logValueEnable($table)
	{
		if($table=="Destinations")
		{
			return true;
		}
		if($table=="Loading_Ports")
		{
			return true;
		}
		if($table=="SC_Item")
		{
			return true;
		}
		if($table=="Sc_Head")
		{
			return true;
		}
		if($table=="Sc_Plus_Minus")
		{
			return true;
		}
		if($table=="Sc_Remarks")
		{
			return true;
		}
		if($table=="Shipping_Marks")
		{
			return true;
		}
		if($table=="webusers")
		{
			return true;
		}
		if($table=="BD_Model")
		{
			return true;
		}
		if($table=="Payterms_new")
		{
			return true;
		}
		if($table=="Customer")
		{
			return true;
		}
		if($table=="Country")
		{
			return true;
		}
		if($table=="Region")
		{
			return true;
		}
		if($table=="Title")
		{
			return true;
		}
		if($table=="AFKT_Item")
		{
			return true;
		}
		if($table=="BD_Bike_Model")
		{
			return true;
		}
		if($table=="Comp_Item")
		{
			return true;
		}
		if($table=="Category")
		{
			return true;
		}
		if($table=="Currency")
		{
			return true;
		}
		if($table=="BL_Shipper")
		{
			return true;
		}
		if($table=="Factory")
		{
			return true;
		}
		if($table=="Cost_Paint_New")
		{
			return true;
		}
		if($table=="Cost_China_Sea_Frt")
		{
			return true;
		}
		if($table=="Cost_TTT_New")
		{
			return true;
		}
		if($table=="Cost_Ckd")
		{
			return true;
		}
		if($table=="Cost_Pkg")
		{
			return true;
		}
		if($table=="Cost_Dep")
		{
			return true;
		}
		if($table=="Cost_Fixed")
		{
			return true;
		}
		if($table=="Cost_Var_OH")
		{
			return true;
		}
		if($table=="Cost_UP_Down")
		{
			return true;
		}
		if($table=="Cost_Rimmaterials")
		{
			return true;
		}
		if($table=="BD_Meetings")
		{
			return true;
		}
		if($table=="Customer_Comments")
		{
			return true;
		}
		if($table=="Customer_Pkg_Report")
		{
			return true;
		}
		if($table=="Spec_Group")
		{
			return true;
		}
		if($table=="Spec_Type")
		{
			return true;
		}
		if($table=="Spec_Material")
		{
			return true;
		}
		if($table=="Spec_Group_Item")
		{
			return true;
		}
		if($table=="Fork_Master")
		{
			return true;
		}
		if($table=="Spec_Price_List")
		{
			return true;
		}
		if($table=="Customer_Create_SC")
		{
			return true;
		}
		if($table=="User_Rights")
		{
			return true;
		}
		if($table=="PC_Head")
		{
			return true;
		}
		if($table=="PC_Item")
		{
			return true;
		}
		if($table=="Pc_Plus_Minus")
		{
			return true;
		}
		if($table=="Pc_Remarks")
		{
			return true;
		}
		if($table=="Model_Group")
		{
			return true;
		}
		if($table=="Model_Size")
		{
			return true;
		}
		if($table=="Model_Material")
		{
			return true;
		}
		if($table=="Model_Type")
		{
			return true;
		}
		if($table=="Model_Frame")
		{
			return true;
		}
		if($table=="Model_Brake")
		{
			return true;
		}
		if($table=="Model_Rimtype")
		{
			return true;
		}
		if($table=="Model_Decal")
		{
			return true;
		}
		if($table=="Model_Speed")
		{
			return true;
		}
		if($table=="Model_Gear")
		{
			return true;
		}
		if($table=="Model_Shifter")
		{
			return true;
		}
		if($table=="Model_Rim")
		{
			return true;
		}
		if($table=="Model_Fork")
		{
			return true;
		}
		if($table=="Model_Paint")
		{
			return true;
		}
		if($table=="Model_Spoke")
		{
			return true;
		}
		if($table=="Model_En")
		{
			return true;
		}
		if($table=="Model_Tyre")
		{
			return true;
		}
		if($table=="Model_Pkg")
		{
			return true;
		}
		if($table=="Model_Valve")
		{
			return true;
		}
		if($table=="Term_From_After")
		{
			return true;
		}
		if($table=="Cash_Flow_DaillyItems")
		{
			return true;
		}
		if($table=="Cash_Flow_MainItems")
		{
			return true;
		}
		if($table=="Maker")
		{
			return true;
		}
		if($table=="Item_Unit")
		{
			return true;
		}
		if($table=="Sc_Item_FW")
		{
			return true;
		}
		if($table=="Sc_Item_RW")
		{
			return true;
		}
		if($table=="SC_Spec_Comp")
		{
			return true;
		}
		if($table=="Sc_Reusable")
		{
			return true;
		}
		if($table=="Replacement_Item")
		{
			return true;
		}
		if($table=="Artwork_Master")
		{
			return true;
		}
		if($table=="IM_Master")
		{
			return true;
		}
		if($table=="Frame_Drawing_Master")
		{
			return true;
		}
		if($table=="Spec_Item_Frsize")
		{
			return true;
		}
		if($table=="Gsp_Bom_costing")
		{
			return true;
		}
		if($table=="Ibws_Head_Inv")
		{
			return true;
		}
		if($table=="Ibws_Inv_Plus_Minus2")
		{
			return true;
		}
		if($table=="Ibws_Inv_Remarks2")
		{
			return true;
		}
		if($table=="Pc_Terms")
		{
			return true;
		}
		if($table=="BL_Head")
		{
			return true;
		}
		if($table=="BL_Cont_Item")
		{
			return true;
		}
		if($table=="BL_Cont_Inv")
		{
			return true;
		}
		if($table=="BD_Shipping_Advice")
		{
			return true;
		}
		if($table=="Spec_Amendments")
		{
			return true;
		}
		if($table=="Spec_Amendments_Item")
		{
			return true;
		}
		if($table=="Spec_Kids_Head")
		{
			return true;
		}
		if($table=="Sp_Kitem")
		{
			return true;
		}
		if($table=="Spec_History")
		{
			return true;
		}
		if($table=="Ex_Rate")
		{
			return true;
		}
		if($table=="Forwaders")
		{
			return true;
		}
		if($table=="Spec_Item_Color")
		{
			return true;
		}
		if($table=="CERT_Nutral")
		{
			return true;
		}
		if($table=="Cert_Content")
		{
			return true;
		}
		if($table=="Cert_Name")
		{
			return true;
		}
		if($table=="Cert_Title")
		{
			return true;
		}
		if($table=="Weldingstatus")
		{
			return true;
		}
		if($table=="Welding_Status")
		{
			return true;
		}
		if($table=="SC_Options")
		{
			return true;
		}
		if($table=="Agent_Master_Fty")
		{
			return true;
		}
		if($table=="Fright")
		{
			return true;
		}
		if($table=="Fty_Ports")
		{
			return true;
		}
		if($table=="Packing")
		{
			return true;
		}
		if($table=="Parts")
		{
			return true;
		}
		if($table=="Container_Head")
		{
			return true;
		}
		if($table=="Container_Data")
		{
			return true;
		}
		if($table=="Exp_Inv_Main")
		{
			return true;
		}
		if($table=="PO_Imp_F_Head")
		{
			return true;
		}
		if($table=="PO_Imp_F_Item")
		{
			return true;
		}
		if($table=="PO_Imp_F_Plus_Minus")
		{
			return true;
		}
		if($table=="Imp_F_Remarks")
		{
			return true;
		}
		if($table=="Supplier")
		{
			return true;
		}
		if($table=="Fixed_refer")
		{
			return true;
		}
		if($table=="Fixed_refer1")
		{
			return true;
		}
		if($table=="Fixed_refer2")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Main")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Head")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Item")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Remarks")
		{
			return true;
		}
		if($table=="PSI_Imp_F_plusminus")
		{
			return true;
		}
		if($table=="PI_Imp_F_Head")
		{
			return true;
		}
		if($table=="PI_Imp_F_Item")
		{
			return true;
		}
		if($table=="PI_Imp_F_Pack")
		{
			return true;
		}
		if($table=="PI_Imp_F_Plus_Minus")
		{
			return true;
		}
		if($table=="PI_Imp_F_Rmks")
		{
			return true;
		}
		if($table=="PI_Imp_F_Pack_New")
		{
			return true;
		}
		if($table=="Parts1D")
		{
			return true;
		}
		if($table=="Parts1D1")
		{
			return true;
		}
		if($table=="Parts1D11")
		{
			return true;
		}
		if($table=="Fixed_InvRefpack")
		{
			return true;
		}
		if($table=="CusDec")
		{
			return true;
		}
		if($table=="CusDec1")
		{
			return true;
		}
		if($table=="Offer_Head")
		{
			return true;
		}
		if($table=="Offer_Item")
		{
			return true;
		}
		if($table=="Sc_Head1")
		{
			return true;
		}
		if($table=="Temp_SC")
		{
			return true;
		}
		if($table=="Ref_SC_BDBK")
		{
			return true;
		}
		if($table=="Ref_Sc_Bike")
		{
			return true;
		}
		if($table=="Ref_Sc_Comp")
		{
			return true;
		}
		if($table=="Offer_List")
		{
			return true;
		}
		if($table=="Spec_withrevision")
		{
			return true;
		}
		if($table=="Ref_BLNO")
		{
			return true;
		}
		if($table=="Forwaders_Local")
		{
			return true;
		}
		if($table=="ST_Item_Fixed")
		{
			return true;
		}
		if($table=="Agent_Master")
		{
			return true;
		}
		if($table=="admin_rights")
		{
			return true;
		}
		if($table=="admin_members")
		{
			return true;
		}
		if($table=="admin_users")
		{
			return true;
		}
		if($table=="Departments")
		{
			return true;
		}
		if($table=="Spec_withrevision1")
		{
			return true;
		}
		if($table=="Spec_withrevision2")
		{
			return true;
		}
		if($table=="PO_PSI_Imp_F_List")
		{
			return true;
		}
		if($table=="PO_PSI_Imp_F")
		{
			return true;
		}
		if($table=="Applications")
		{
			return true;
		}
		if($table=="Cost_Main")
		{
			return true;
		}
		if($table=="Decimal_Val")
		{
			return false;
		}
		if($table=="Cost_Customer")
		{
			return false;
		}
		if($table=="TC_Modelwise")
		{
			return false;
		}
		if($table=="BD_Model1")
		{
			return true;
		}
		if($table=="BD_Model11")
		{
			return true;
		}
		if($table=="Fixed_Comments_Shortage")
		{
			return false;
		}
	}
	
	protected function insert($datetime, $ip, $user, $table, $action, $description)
	{
		$sql = "INSERT INTO " .$this->connection->addTableWrappers( $this->logTableName ).
			" (" .$this->connection->addFieldWrappers("datetime").
			"," .$this->connection->addFieldWrappers("ip").
			"," .$this->connection->addFieldWrappers("user").
			"," .$this->connection->addFieldWrappers("table"). 
			"," .$this->connection->addFieldWrappers("action").
			"," .$this->connection->addFieldWrappers("description").
			") VALUES (" .$this->connection->addDateQuotes($datetime).
			"," .$this->connection->prepareString($ip). 
			"," .$this->connection->prepareString($user).
			"," .$this->connection->prepareString($table).
			"," .$this->connection->prepareString($action). 
			"," .$this->connection->prepareString($description).
			")";
		
		return $this->connection->exec( $sql );
	}
	
	protected function getMaxLengthSubstr( $value )
	{		
		if( $this->maxFieldLength && strlen($value) > $this->maxFieldLength )
			return runner_substr($value, 0, $this->maxFieldLength);
		
		return $value;
	}	
}

class AuditTrailFile
{
	var $logfile="audit.log";
	var $strLogin="login";
	var $strFailLogin="failed login";
	var $strLogout="logout";
	var $strChPass="change password";
	var $strAdd="add";
	var $strEdit="edit";
	var $strDelete="delete";
	var $strAccess="access";
	var $strKeysHeader="---Keys";
	var $strFieldsHeader="---Fields";
	var $columnDate="Date";
	var $columnTime="Time";
	var $columnIP="IP";
	var $columnUser="User";
	var $columnTable="Table";
	var $columnAction="Action";
	var $columnKey="Key field";
	var $columnField="Field";
	var $columnOldValue="Old value";
	var $columnNewValue="New value";
	var $params;
	var $maxFieldLength;
	
	function __construct()
	{
		global $auditMaxFieldLength;
		
		$userid = "";
		if(@$_SESSION["UserID"])
			$userid = $_SESSION["UserID"];
		
		$this->params = array($_SERVER["REMOTE_ADDR"], $userid);
		
		$this->maxFieldLength = $auditMaxFieldLength;
	}
	
    function LogLogin($pUsername)
    {
				global $globalEvents;
		$retval=true;
		$table="webusers";
		$this->params[1]=$pUsername;
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strLogin, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strLogin."\r\n";
			$this->writeToLogFile( $str );
		}
		return $retval;
    }
	
    function LogLoginFailed($pUsername)
    {
				global $globalEvents;
		$retval=true;
		$table="webusers";
		$this->params[1]=$pUsername;
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strFailLogin, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strFailLogin."\r\n";
			$this->writeToLogFile( $str );
		}
		return $retval;
    }
	
    function LogLogout()
    {
		global $globalEvents;
		if($_SESSION["UserID"]!="")
		{
			$retval=true;
			$table="webusers";
			$arr=array();
			if($globalEvents->exists("OnAuditLog"))
				$retval=$globalEvents->OnAuditLog($this->strLogout, $this->params, $table, $arr, $arr, $arr);
			if($retval)
			{
				$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strLogout."\r\n";
				$this->writeToLogFile( $str );
			}
			return $retval;
		}
    }
	
    function LogChPassword()
    {
		global $globalEvents;
		$retval=true;
		$table="webusers";
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strChPass, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strChPass."\r\n";
			$this->writeToLogFile( $str );
		}
		return $retval;
    }
	
    function LogAdd($str_table,$values,$keys)
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$pSet = new ProjectSettings($str_table);
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strAdd, $this->params, $table, $keys, $values, $arr);
		if($retval)
		{
			if(count($keys)>0)
			{
				$key="";
				foreach($keys as $idx=>$val)
				{
					if($key!="")
						$key.=",";
					$key.=$val;
				}
			}

			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strAdd.chr(9).$key;
			$str_add="";
			if($this->logValueEnable($str_table))
			{
				foreach($values as $idx=>$val)
				{
					if($val!="" && !array_key_exists($idx,$keys))
					{
						$v="";
						if(IsBinaryType($pSet->getFieldType($idx)))
							$v="<binary value>"."\r\n";
						else
						{
							$v = str_replace(array("\r\n","\n","\t")," ",$val);
							$v = $this->getMaxLengthSubstr( $v );
						}
						$str_add.=$str.chr(9).$idx.chr(9).chr(9).$v."\r\n";
					}
				}
			}
			else
				$str_add.=$str."\r\n";
			
			$this->writeToLogFile( $str_add );
		}
		return $retval;
    }
	
    function LogEdit($str_table,$newvalues,$oldvalues,$keys)
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$pSet = new ProjectSettings($str_table);
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strEdit, $this->params, $table, $keys, $newvalues, $oldvalues);
		if($retval)
		{
			if(count($keys)>0)
			{
				$key="";
				foreach($keys as $idx=>$val)
				{
					if($key!="")
						$key.=",";
					$key.=$val;
				}
			}

			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strEdit.chr(9).$key;
			$putsValue=true;
			$str_add="";
			if($this->logValueEnable($str_table))
			{
				foreach($newvalues as $idx=>$val)
				{
					$type=$pSet->getFieldType($idx);
					if(IsBinaryType($type))
						continue;
					if(IsDateFieldType($type))
					{
						$newvalue=format_datetime_custom(db2time($newvalues[$idx]),"yyyy-MM-dd HH:mm:ss");
						$oldvalue=format_datetime_custom(db2time($oldvalues[$idx]),"yyyy-MM-dd HH:mm:ss");
					}
					else
					{
						$newvalue=$newvalues[$idx];
						$oldvalue=$oldvalues[$idx];
					}
					if($newvalue!=$oldvalue)
					{
						$v1="";
						if(IsBinaryType($type))
							$v1="<binary value>";
						else
						{
							$v1 = str_replace(array("\r\n","\n","\t")," ",$oldvalue);
							$v = $this->getMaxLengthSubstr( $v );
						}
						
						$v2="";
						if(IsBinaryType($type))
							$v2="<binary value>";
						else
						{
							$v2 = str_replace(array("\r\n","\n","\t")," ",$newvalue);
							$v2 = $this->getMaxLengthSubstr( $v2 );
						}
						$str_add.=$str.chr(9).$idx.chr(9).$v1.chr(9).$v2."\r\n";
					}
				}
			}
			else
				$str_add.=$str."\r\n";
			$this->writeToLogFile( $str_add );
		}
		return $retval;
    }
	
    function LogDelete($str_table,$values,$keys)
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$pSet = new ProjectSettings($str_table);
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($this->strDelete, $this->params, $table, $keys, $values, $arr);
		if($retval)
		{
			if(count($keys)>0)
			{
				$key="";
				foreach($keys as $idx=>$val)
				{
					if($key!="")
						$key.=",";
					$key.=$val;
				}
			}
			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$this->params[0].chr(9).$this->params[1].chr(9).$table.chr(9).$this->strDelete.chr(9).$key;
			$str_add="";
			if($this->logValueEnable($str_table))
			{
				foreach($values as $idx=>$val)
				{
					$v="";
					if(IsBinaryType($pSet->getFieldType($idx)))
						$v="<binary value>";
					else
					{
						$v = str_replace(array("\r\n","\n","\t")," ",$val);
						$v = $this->getMaxLengthSubstr( $v );
					}
					$str_add.=$str.chr(9).$idx.chr(9).$v."\r\n";
				}
			}
			else
				$str_add=$str."\r\n";
				
			$this->writeToLogFile( $str_add );
		}
		return $retval;
    }
	
	function writeToLogFile( $str )
	{
		$p=strrpos($this->logfile,".");
		$logfileName=runner_substr($this->logfile,0,$p);
		$logfileExt=runner_substr($this->logfile,$p+1, strlen($this->logfile)-1);
		$tn=$logfileName."_".format_datetime_custom(db2time(now()),"yyyyMMdd").".".$logfileExt;
		
		$fullname = getabspath($tn);
		$fsize = 0;
		if (file_exists($fullname)){
			$fsize = filesize($fullname);
		}
		$str_to_append = "";
		if( !$fsize )
		{
			$str_to_append = $this->columnDate.chr(9).$this->columnTime.chr(9).$this->columnIP.chr(9).$this->columnUser.chr(9).$this->columnTable.chr(9).$this->columnAction.chr(9).$this->columnKey.chr(9).$this->columnField.chr(9).$this->columnOldValue.chr(9).$this->columnNewValue."\r\n";
		}
		$str_to_append .= $str;
		append_to_file( $fullname, $str_to_append );
		
	}
	
	function LogAddEvent($message,$description="",$str_table="")
    {
		global $globalEvents;
		$retval=true;
		$table=$str_table;
		$arr=array();
		if($globalEvents->exists("OnAuditLog"))
			$retval=$globalEvents->OnAuditLog($message, $this->params, $table, $arr, $arr, $arr);
		if($retval)
		{
			$str=format_datetime_custom(db2time(now()),"MMM dd,yyyy").chr(9).format_datetime_custom(db2time(now()),"HH:mm:ss").chr(9).$params[0].chr(9).$params[1].chr(9).$table.chr(9).$message.chr(9).$description."\r\n";
			$this->writeToLogFile( $str );
		}
		return $retval;
    }
    
    function LoginAccess()
	{
		return false;
	}
	
	function LoginSuccessful()
    {
		return true;
    }
	
    function LoginUnsuccessful($pUsername)
    {	
		return true;
	}
	
	function logValueEnable($table)
	{
		if($table=="Destinations")
		{
			return true;
		}
		if($table=="Loading_Ports")
		{
			return true;
		}
		if($table=="SC_Item")
		{
			return true;
		}
		if($table=="Sc_Head")
		{
			return true;
		}
		if($table=="Sc_Plus_Minus")
		{
			return true;
		}
		if($table=="Sc_Remarks")
		{
			return true;
		}
		if($table=="Shipping_Marks")
		{
			return true;
		}
		if($table=="webusers")
		{
			return true;
		}
		if($table=="BD_Model")
		{
			return true;
		}
		if($table=="Payterms_new")
		{
			return true;
		}
		if($table=="Customer")
		{
			return true;
		}
		if($table=="Country")
		{
			return true;
		}
		if($table=="Region")
		{
			return true;
		}
		if($table=="Title")
		{
			return true;
		}
		if($table=="AFKT_Item")
		{
			return true;
		}
		if($table=="BD_Bike_Model")
		{
			return true;
		}
		if($table=="Comp_Item")
		{
			return true;
		}
		if($table=="Category")
		{
			return true;
		}
		if($table=="Currency")
		{
			return true;
		}
		if($table=="BL_Shipper")
		{
			return true;
		}
		if($table=="Factory")
		{
			return true;
		}
		if($table=="Cost_Paint_New")
		{
			return true;
		}
		if($table=="Cost_China_Sea_Frt")
		{
			return true;
		}
		if($table=="Cost_TTT_New")
		{
			return true;
		}
		if($table=="Cost_Ckd")
		{
			return true;
		}
		if($table=="Cost_Pkg")
		{
			return true;
		}
		if($table=="Cost_Dep")
		{
			return true;
		}
		if($table=="Cost_Fixed")
		{
			return true;
		}
		if($table=="Cost_Var_OH")
		{
			return true;
		}
		if($table=="Cost_UP_Down")
		{
			return true;
		}
		if($table=="Cost_Rimmaterials")
		{
			return true;
		}
		if($table=="BD_Meetings")
		{
			return true;
		}
		if($table=="Customer_Comments")
		{
			return true;
		}
		if($table=="Customer_Pkg_Report")
		{
			return true;
		}
		if($table=="Spec_Group")
		{
			return true;
		}
		if($table=="Spec_Type")
		{
			return true;
		}
		if($table=="Spec_Material")
		{
			return true;
		}
		if($table=="Spec_Group_Item")
		{
			return true;
		}
		if($table=="Fork_Master")
		{
			return true;
		}
		if($table=="Spec_Price_List")
		{
			return true;
		}
		if($table=="Customer_Create_SC")
		{
			return true;
		}
		if($table=="User_Rights")
		{
			return true;
		}
		if($table=="PC_Head")
		{
			return true;
		}
		if($table=="PC_Item")
		{
			return true;
		}
		if($table=="Pc_Plus_Minus")
		{
			return true;
		}
		if($table=="Pc_Remarks")
		{
			return true;
		}
		if($table=="Model_Group")
		{
			return true;
		}
		if($table=="Model_Size")
		{
			return true;
		}
		if($table=="Model_Material")
		{
			return true;
		}
		if($table=="Model_Type")
		{
			return true;
		}
		if($table=="Model_Frame")
		{
			return true;
		}
		if($table=="Model_Brake")
		{
			return true;
		}
		if($table=="Model_Rimtype")
		{
			return true;
		}
		if($table=="Model_Decal")
		{
			return true;
		}
		if($table=="Model_Speed")
		{
			return true;
		}
		if($table=="Model_Gear")
		{
			return true;
		}
		if($table=="Model_Shifter")
		{
			return true;
		}
		if($table=="Model_Rim")
		{
			return true;
		}
		if($table=="Model_Fork")
		{
			return true;
		}
		if($table=="Model_Paint")
		{
			return true;
		}
		if($table=="Model_Spoke")
		{
			return true;
		}
		if($table=="Model_En")
		{
			return true;
		}
		if($table=="Model_Tyre")
		{
			return true;
		}
		if($table=="Model_Pkg")
		{
			return true;
		}
		if($table=="Model_Valve")
		{
			return true;
		}
		if($table=="Term_From_After")
		{
			return true;
		}
		if($table=="Cash_Flow_DaillyItems")
		{
			return true;
		}
		if($table=="Cash_Flow_MainItems")
		{
			return true;
		}
		if($table=="Maker")
		{
			return true;
		}
		if($table=="Item_Unit")
		{
			return true;
		}
		if($table=="Sc_Item_FW")
		{
			return true;
		}
		if($table=="Sc_Item_RW")
		{
			return true;
		}
		if($table=="SC_Spec_Comp")
		{
			return true;
		}
		if($table=="Sc_Reusable")
		{
			return true;
		}
		if($table=="Replacement_Item")
		{
			return true;
		}
		if($table=="Artwork_Master")
		{
			return true;
		}
		if($table=="IM_Master")
		{
			return true;
		}
		if($table=="Frame_Drawing_Master")
		{
			return true;
		}
		if($table=="Spec_Item_Frsize")
		{
			return true;
		}
		if($table=="Gsp_Bom_costing")
		{
			return true;
		}
		if($table=="Ibws_Head_Inv")
		{
			return true;
		}
		if($table=="Ibws_Inv_Plus_Minus2")
		{
			return true;
		}
		if($table=="Ibws_Inv_Remarks2")
		{
			return true;
		}
		if($table=="Pc_Terms")
		{
			return true;
		}
		if($table=="BL_Head")
		{
			return true;
		}
		if($table=="BL_Cont_Item")
		{
			return true;
		}
		if($table=="BL_Cont_Inv")
		{
			return true;
		}
		if($table=="BD_Shipping_Advice")
		{
			return true;
		}
		if($table=="Spec_Amendments")
		{
			return true;
		}
		if($table=="Spec_Amendments_Item")
		{
			return true;
		}
		if($table=="Spec_Kids_Head")
		{
			return true;
		}
		if($table=="Sp_Kitem")
		{
			return true;
		}
		if($table=="Spec_History")
		{
			return true;
		}
		if($table=="Ex_Rate")
		{
			return true;
		}
		if($table=="Forwaders")
		{
			return true;
		}
		if($table=="Spec_Item_Color")
		{
			return true;
		}
		if($table=="CERT_Nutral")
		{
			return true;
		}
		if($table=="Cert_Content")
		{
			return true;
		}
		if($table=="Cert_Name")
		{
			return true;
		}
		if($table=="Cert_Title")
		{
			return true;
		}
		if($table=="Weldingstatus")
		{
			return true;
		}
		if($table=="Welding_Status")
		{
			return true;
		}
		if($table=="SC_Options")
		{
			return true;
		}
		if($table=="Agent_Master_Fty")
		{
			return true;
		}
		if($table=="Fright")
		{
			return true;
		}
		if($table=="Fty_Ports")
		{
			return true;
		}
		if($table=="Packing")
		{
			return true;
		}
		if($table=="Parts")
		{
			return true;
		}
		if($table=="Container_Head")
		{
			return true;
		}
		if($table=="Container_Data")
		{
			return true;
		}
		if($table=="Exp_Inv_Main")
		{
			return true;
		}
		if($table=="PO_Imp_F_Head")
		{
			return true;
		}
		if($table=="PO_Imp_F_Item")
		{
			return true;
		}
		if($table=="PO_Imp_F_Plus_Minus")
		{
			return true;
		}
		if($table=="Imp_F_Remarks")
		{
			return true;
		}
		if($table=="Supplier")
		{
			return true;
		}
		if($table=="Fixed_refer")
		{
			return true;
		}
		if($table=="Fixed_refer1")
		{
			return true;
		}
		if($table=="Fixed_refer2")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Main")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Head")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Item")
		{
			return true;
		}
		if($table=="PSI_Imp_F_Remarks")
		{
			return true;
		}
		if($table=="PSI_Imp_F_plusminus")
		{
			return true;
		}
		if($table=="PI_Imp_F_Head")
		{
			return true;
		}
		if($table=="PI_Imp_F_Item")
		{
			return true;
		}
		if($table=="PI_Imp_F_Pack")
		{
			return true;
		}
		if($table=="PI_Imp_F_Plus_Minus")
		{
			return true;
		}
		if($table=="PI_Imp_F_Rmks")
		{
			return true;
		}
		if($table=="PI_Imp_F_Pack_New")
		{
			return true;
		}
		if($table=="Parts1D")
		{
			return true;
		}
		if($table=="Parts1D1")
		{
			return true;
		}
		if($table=="Parts1D11")
		{
			return true;
		}
		if($table=="Fixed_InvRefpack")
		{
			return true;
		}
		if($table=="CusDec")
		{
			return true;
		}
		if($table=="CusDec1")
		{
			return true;
		}
		if($table=="Offer_Head")
		{
			return true;
		}
		if($table=="Offer_Item")
		{
			return true;
		}
		if($table=="Sc_Head1")
		{
			return true;
		}
		if($table=="Temp_SC")
		{
			return true;
		}
		if($table=="Ref_SC_BDBK")
		{
			return true;
		}
		if($table=="Ref_Sc_Bike")
		{
			return true;
		}
		if($table=="Ref_Sc_Comp")
		{
			return true;
		}
		if($table=="Offer_List")
		{
			return true;
		}
		if($table=="Spec_withrevision")
		{
			return true;
		}
		if($table=="Ref_BLNO")
		{
			return true;
		}
		if($table=="Forwaders_Local")
		{
			return true;
		}
		if($table=="ST_Item_Fixed")
		{
			return true;
		}
		if($table=="Agent_Master")
		{
			return true;
		}
		if($table=="admin_rights")
		{
			return true;
		}
		if($table=="admin_members")
		{
			return true;
		}
		if($table=="admin_users")
		{
			return true;
		}
		if($table=="Departments")
		{
			return true;
		}
		if($table=="Spec_withrevision1")
		{
			return true;
		}
		if($table=="Spec_withrevision2")
		{
			return true;
		}
		if($table=="PO_PSI_Imp_F_List")
		{
			return true;
		}
		if($table=="PO_PSI_Imp_F")
		{
			return true;
		}
		if($table=="Applications")
		{
			return true;
		}
		if($table=="Cost_Main")
		{
			return true;
		}
		if($table=="Decimal_Val")
		{
			return false;
		}
		if($table=="Cost_Customer")
		{
			return false;
		}
		if($table=="TC_Modelwise")
		{
			return false;
		}
		if($table=="BD_Model1")
		{
			return true;
		}
		if($table=="BD_Model11")
		{
			return true;
		}
		if($table=="Fixed_Comments_Shortage")
		{
			return false;
		}
	}
	
	protected function getMaxLengthSubstr( $value )
	{		
		if( $this->maxFieldLength && strlen($value) > $this->maxFieldLength )
			return runner_substr($value, 0, $this->maxFieldLength);
		
		return $value;
	}
}
?>