<?php
class ConnectionManager
{
	/**
	 * Cached Connection objects
	 * @type Array
	 */
	protected $cache = array();

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsData;

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsIdByName = array();

	
	/**
	 * An array storing the correspondence between project
	 * datasource tables names and connections ids
	 * @type Array
	 */	
	protected $_tablesConnectionIds;
	
	
	/**
	 * @constructor
	 */
	function __construct()
	{
		$this->_setConnectionsData();
		$this->_setTablesConnectionIds();
	}
	
	/**
	 * Get connection object by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function byTable( $tName )
	{
		$connId = $this->_tablesConnectionIds[ $tName ];
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection object by the connection name
	 * @param String connName
	 * @return Connection
	 */	
	public function byName( $connName )
	{
		$connId = $this->getIdByName( $connName );
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}
	
	/**
	 * Get connection id by the connection name
	 * @param String connName
	 * @return String
	 */	
	protected function getIdByName( $connName )
	{
		return $this->_connectionsIdByName[ $connName ];
	}
	
	/**
	 * Get connection object by the connection id 
	 * @param String connId
	 * @return Connection
	 */	
	public function byId( $connId )
	{
		if( !isset( $this->cache[ $connId ] ) )
			$this->cache[ $connId ] = $this->getConnection( $connId );

		return $this->cache[ $connId ];
	}
	
	/**
	 * Get the default db connection class
	 * @return Connection
	 */
	public function getDefault()
	{
		return $this->byId( "firefoxbd_at_103_6_168_141" );
	}

	/**
	 * Get the users table db connection 
	 * @return Connection
	 */	
	public function getForLogin()
	{
		return $this->byId( "firefoxbd_at_103_6_168_141" );
	}
	
	/**
	 * Get the log table db connection 
	 * @return Connection
	 */	
	public function getForAudit()
	{
		return $this->byId( "firefoxbd_at_103_6_168_141" );
	}
	
	/**
	 * Get the locking table db connection 
	 * @return Connection
	 */		
	public function getForLocking()
	{
		return $this->getDefault();
	}	
	
	/**
	 * Get the 'ug_groups' table db connection 
	 * @return Connection
	 */	
	public function getForUserGroups()
	{
		return $this->byId( "firefoxbd_at_103_6_168_141" );
	}		

	/**
	 * Get the saved searches table db connection 
	 * @return Connection
	 */	
	public function getForSavedSearches()
	{
		return $this->getDefault();
	}

	/**
	 * Get the webreports tables db connection 
	 * @return Connection
	 */		
	public function getForWebReports()
	{
		return $this->getDefault();
	}
	
	/**
	 * @param String connId
	 * @return Connection
	 */
	protected function getConnection( $connId )
	{
		include_once getabspath("connections/Connection.php");
		
		$data = $this->_connectionsData[ $connId ];	
		switch( $data["connStringType"] )
		{
			case "mysql":
				if( useMySQLiLib() )
				{
					include_once getabspath("connections/MySQLiConnection.php");
					return new MySQLiConnection( $data );
				}
				
				include_once getabspath("connections/MySQLConnection.php");	
				return new MySQLConnection( $data );	

			case "mssql":
			case "compact":
				if( useMSSQLWinConnect() )
				{
					include_once getabspath("connections/MSSQLWinConnection.php");
					return new MSSQLWinConnection( $data );
				}
				if( isSqlsrvExtLoaded() )
				{
					include_once getabspath("connections/MSSQLSrvConnection.php");	
					return new MSSQLSrvConnection( $data );
				}
				
				if( function_exists("mssql_connect") ) {
					include_once getabspath("connections/MSSQLUnixConnection.php");
					return new MSSQLUnixConnection( $data );			
				}

				if( class_exists("PDO") ) {
					include_once getabspath("connections/PDOConnection.php");
					$drivers = pdo_drivers();
					if( in_array( "sqlsrv", $drivers) )
					{
						$data["PDOString"] = "sqlsrv:Server=" . $data["connInfo"][0] . ";Database=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
					if( in_array( "dblib", $drivers) )
					{
						$data["PDOString"] = "dblib:host=" . $data["connInfo"][0] . ";dbname=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
				}
				echo "No SQL Server driver found in your PHP settings.";
				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
					echo "<br>To enable SQL Server support add the following line to php.ini file:";
					echo "<br>extension=php_com_dotnet.dll";
				}
				exit();

			case "msaccess":
			case "odbc":
			case "odbcdsn":
			case "custom":
			case "file":
				if( stripos($data["ODBCString"], 'Provider=') !== false )
				{
					include_once getabspath("connections/ADOConnection.php");
					return new ADOConnection( $data );
				}
				
				include_once getabspath("connections/ODBCConnection.php");
				return new ODBCConnection( $data );
			
			case "oracle":
				include_once getabspath("connections/OracleConnection.php");
				return new OracleConnection( $data );

			case "postgre":
				include_once getabspath("connections/PostgreConnection.php");
				return new PostgreConnection( $data );

			case "db2":
				include_once getabspath("connections/DB2Connection.php");
				return new DB2Connection( $data );

			case "informix":
				include_once getabspath("connections/InformixConnection.php");
				return new InformixConnection( $data );

			case "sqlite":
				include_once getabspath("connections/SQLite3Connection.php");
				return new SQLite3Connection( $data );
			case "pdo":
				include_once getabspath("connections/PDOConnection.php");
				return new PDOConnection( $data );
		}
	}

	public function getConectionsIds()
	{
		$connectionsIds = array();
		foreach ($this->_connectionsData as $connId => $data) {
			$connectionsIds[] = $connId;
		}

		return $connectionsIds;
	}

	/**
	 * Set the data representing the project's 
	 * db connection properties
	 */	 
	protected function _setConnectionsData()
	{
		// content of this function can be modified on demo account
		// variable names $data and $connectionsData are important

		$connectionsData = array();
		
		$data = array();
		$data["dbType"] = 0;
		$data["connId"] = "firefoxbd_at_103_6_168_141";
		$data["connName"] = "firefoxbd at 103.6.168.141";
		$data["connStringType"] = "mysql";
		$data["connectionString"] = "mysql;103.6.168.141;Admin;5MQFX49p2Z8a@777;;firefoxbd;;1"; //currently unused

		$this->_connectionsIdByName["firefoxbd at 103.6.168.141"] = "firefoxbd_at_103_6_168_141";
		
		$data["connInfo"] = array();
		$data["ODBCUID"] = "Admin";
		$data["ODBCPWD"] = "5MQFX49p2Z8a@777";
		$data["leftWrap"] = "`";
		$data["rightWrap"] = "`";
		
		$data["DBPath"] = "db"; //currently unused	
		$data["useServerMapPath"] = 1; //currently unused
		
		$data["connInfo"][0] = "103.6.168.141";
		$data["connInfo"][1] = "Admin";
		$data["connInfo"][2] = "5MQFX49p2Z8a@777";
		$data["connInfo"][3] = "";
		$data["connInfo"][4] = "firefoxbd";
		$data["connInfo"][5] = ""; //currently unused
		$data["connInfo"][6] = "1"; //currently unused
		$data["ODBCString"] = "DRIVER={MySQL ODBC 3.51 Driver};Server=103.6.168.141;Uid=Admin;Pwd=5MQFX49p2Z8a@777;Database=firefoxbd;OPTION=3";
		// encription set
		$data["EncryptInfo"] = array();
		$data["EncryptInfo"]["mode"] = 0;
		$data["EncryptInfo"]["alg"]  = 128;
		$data["EncryptInfo"]["key"]  = "";

		$connectionsData["firefoxbd_at_103_6_168_141"] = $data;
		$this->_connectionsData = $connectionsData;
	}
	
	/**
	 * Set the data representing the correspondence between 
	 * the project's table names and db connections
	 */	 
	protected function _setTablesConnectionIds()
	{
		$connectionsIds = array();
		$connectionsIds["ST_Department"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Adj_Reason"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Ret_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Rec_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Adj_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Cap_Ret_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["webusers"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PI_Imp_A_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PO_Loc_A_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Assets_Group"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Assets_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Rec_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Ret_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Ret_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Adj_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Item_Location"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ConsCat"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["SC_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PI_Imp_C_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PO_Loc_C_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Repl_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Rep_Rec_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Repl_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Repl_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Repl_Adj_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PI_Imp_R_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Sc_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Replacement_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Rec_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PO_Loc_B_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["BulkInv_Ref"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Rim_DeliveryNote_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Bulk_refcat"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Ret_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Ret_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_B_Adj_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Item_Bulk"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["SC_Item1"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Rec_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Ret_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Ret_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_F_Adj_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Item_Fixed"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Rec_Head_New"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Rec_Item_New"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_PC3_Rec_Head_New"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_PC3_Rec_Item_New"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Rec_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["CusDec"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Ret_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Ret_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Adj_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Parts"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["BD_Model"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Swap_IBWS"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Ref_Ibwspc3"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Ref_IBWS_Vehicles"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Rec_Head_Sp"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Rec_Item_Sp"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Isu_Head_Sp"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Isu_Item_Sp"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Ref_Ibwsreccont"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Isu_Exframe_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Isu_Exframe_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Ret_Head_Sp"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_IBWS_Ret_Item_Sp"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Fixed_AdjLed_Rec_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Sc_Itemnot_Include"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Paint_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Paint_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_ReplFrm_Isu_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_ReplFrm_Isu_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Swap_Fixed"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["SC_INIREF"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["SC_INIREF1"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Isu_Head_New"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_C_Isu_Item_New"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Component_QC_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Component_QC_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["admin_rights"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["admin_members"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["admin_users"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PO_Loc_F_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["PI_Imp_Paint_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Rep_Ret_Head"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["ST_Repl_Ret_Item"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Ref_Fixed_Inv1"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Ref_Stores_Isuscseq"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Ref_Parts"] = "firefoxbd_at_103_6_168_141";
		$connectionsIds["Imp_PO_F_SC"] = "firefoxbd_at_103_6_168_141";
		$this->_tablesConnectionIds = $connectionsIds;
	}
	
	/**
	 * Check if It's possible to add to one table's sql query 
	 * an sql subquery to another table.
	 * Access doesn't support subqueries from the same table as main.
	 * @param String dataSourceTName1
	 * @param String dataSourceTName2
	 * @return Boolean
	 */
	public function checkTablesSubqueriesSupport( $dataSourceTName1, $dataSourceTName2 )
	{
		$connId1 = $this->_tablesConnectionIds[ $dataSourceTName1 ];
		$connId2 = $this->_tablesConnectionIds[ $dataSourceTName2 ];
		
		if( $connId1 != $connId2 )
			return false;

		if( $this->_connectionsData[ $connId1 ]["dbType"] == nDATABASE_Access && $dataSourceTName1 == $dataSourceTName2 )
			return false;
			
		return true;	
	}
	
	/**
	 * Close db connections
	 * @destructor
	 */
	function __desctruct() 
	{
		foreach( $this->cache as $connection )
		{
			$connection->close();
		}
	}
}
?>