<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["invoice_head.iFrom"] )) {
			$lookupTableLinks["Loading_Ports"]["invoice_head.iFrom"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["invoice_head.iFrom"]["edit"] = array("table" => "Invoice_Head", "field" => "iFrom", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["invoice_head.iTo"] )) {
			$lookupTableLinks["Destinations"]["invoice_head.iTo"] = array();
		}
		$lookupTableLinks["Destinations"]["invoice_head.iTo"]["edit"] = array("table" => "Invoice_Head", "field" => "iTo", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["invoice_head.for_account"] )) {
			$lookupTableLinks["Customer"]["invoice_head.for_account"] = array();
		}
		$lookupTableLinks["Customer"]["invoice_head.for_account"]["edit"] = array("table" => "Invoice_Head", "field" => "for_account", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["invoice_head.Term"] )) {
			$lookupTableLinks["Pc_Terms"]["invoice_head.Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["invoice_head.Term"]["edit"] = array("table" => "Invoice_Head", "field" => "Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["invoice_head.Dest"] )) {
			$lookupTableLinks["Destinations"]["invoice_head.Dest"] = array();
		}
		$lookupTableLinks["Destinations"]["invoice_head.Dest"]["edit"] = array("table" => "Invoice_Head", "field" => "Dest", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["invoice_head.Title_Id"] )) {
			$lookupTableLinks["Title"]["invoice_head.Title_Id"] = array();
		}
		$lookupTableLinks["Title"]["invoice_head.Title_Id"]["edit"] = array("table" => "Invoice_Head", "field" => "Title_Id", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["invoice_head.Currency"] )) {
			$lookupTableLinks["Currency"]["invoice_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["invoice_head.Currency"]["edit"] = array("table" => "Invoice_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["invoice_head.cust_id_pkg"] )) {
			$lookupTableLinks["Customer"]["invoice_head.cust_id_pkg"] = array();
		}
		$lookupTableLinks["Customer"]["invoice_head.cust_id_pkg"]["edit"] = array("table" => "Invoice_Head", "field" => "cust_id_pkg", "page" => "edit");
		if( !isset( $lookupTableLinks["Term_From_After"] ) ) {
			$lookupTableLinks["Term_From_After"] = array();
		}
		if( !isset( $lookupTableLinks["Term_From_After"]["invoice_head.Term_from_after"] )) {
			$lookupTableLinks["Term_From_After"]["invoice_head.Term_from_after"] = array();
		}
		$lookupTableLinks["Term_From_After"]["invoice_head.Term_from_after"]["edit"] = array("table" => "Invoice_Head", "field" => "Term_from_after", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["invoice_head.Pay_Term_New"] )) {
			$lookupTableLinks["Payterms_new"]["invoice_head.Pay_Term_New"] = array();
		}
		$lookupTableLinks["Payterms_new"]["invoice_head.Pay_Term_New"]["edit"] = array("table" => "Invoice_Head", "field" => "Pay_Term_New", "page" => "edit");
		if( !isset( $lookupTableLinks["Agent_Master"] ) ) {
			$lookupTableLinks["Agent_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Agent_Master"]["invoice_head.Cus_Option"] )) {
			$lookupTableLinks["Agent_Master"]["invoice_head.Cus_Option"] = array();
		}
		$lookupTableLinks["Agent_Master"]["invoice_head.Cus_Option"]["edit"] = array("table" => "Invoice_Head", "field" => "Cus_Option", "page" => "edit");
		if( !isset( $lookupTableLinks["Agent_Master"] ) ) {
			$lookupTableLinks["Agent_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Agent_Master"]["invoice_head.Cus_Option1"] )) {
			$lookupTableLinks["Agent_Master"]["invoice_head.Cus_Option1"] = array();
		}
		$lookupTableLinks["Agent_Master"]["invoice_head.Cus_Option1"]["edit"] = array("table" => "Invoice_Head", "field" => "Cus_Option1", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["invoice_item.Article"] )) {
			$lookupTableLinks["BD_Model"]["invoice_item.Article"] = array();
		}
		$lookupTableLinks["BD_Model"]["invoice_item.Article"]["edit"] = array("table" => "Invoice_item", "field" => "Article", "page" => "edit");
		if( !isset( $lookupTableLinks["Exp_Inv_Cont"] ) ) {
			$lookupTableLinks["Exp_Inv_Cont"] = array();
		}
		if( !isset( $lookupTableLinks["Exp_Inv_Cont"]["invoice_ex_pack.CNTR_No"] )) {
			$lookupTableLinks["Exp_Inv_Cont"]["invoice_ex_pack.CNTR_No"] = array();
		}
		$lookupTableLinks["Exp_Inv_Cont"]["invoice_ex_pack.CNTR_No"]["edit"] = array("table" => "Invoice_Ex_Pack", "field" => "CNTR_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["invoice_remarks.Email2"] )) {
			$lookupTableLinks["Shipping_Marks"]["invoice_remarks.Email2"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["invoice_remarks.Email2"]["edit"] = array("table" => "Invoice_Remarks", "field" => "Email2", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["shp_adv_head.PayTerms"] )) {
			$lookupTableLinks["Payterms_new"]["shp_adv_head.PayTerms"] = array();
		}
		$lookupTableLinks["Payterms_new"]["shp_adv_head.PayTerms"]["edit"] = array("table" => "SHP_Adv_Head", "field" => "PayTerms", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["ref_taiwan_shipping_head.Customer"] )) {
			$lookupTableLinks["Customer"]["ref_taiwan_shipping_head.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["ref_taiwan_shipping_head.Customer"]["edit"] = array("table" => "Ref_Taiwan_Shipping_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["ref_taiwan_shipping_advice.Model_No"] )) {
			$lookupTableLinks["BD_Model"]["ref_taiwan_shipping_advice.Model_No"] = array();
		}
		$lookupTableLinks["BD_Model"]["ref_taiwan_shipping_advice.Model_No"]["edit"] = array("table" => "Ref_Taiwan_Shipping_Advice", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_f_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_f_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_f_head.TitleID"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_imp_f_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_imp_f_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_imp_f_head.SupID"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["po_imp_f_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright"]["po_imp_f_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright"]["po_imp_f_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_f_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_f_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_f_head.Destination"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_f_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_f_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_f_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_f_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_f_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_f_head.Port"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_f_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_f_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_f_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_f_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_f_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_f_head.Currency"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["po_imp_f_head.Issued_by"] )) {
			$lookupTableLinks["webusers"]["po_imp_f_head.Issued_by"] = array();
		}
		$lookupTableLinks["webusers"]["po_imp_f_head.Issued_by"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Issued_by", "page" => "edit");
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"] ) ) {
			$lookupTableLinks["Imp_PO_F_SC"] = array();
		}
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.PCNo"] )) {
			$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.PCNo"] = array();
		}
		$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.PCNo"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "PCNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"] ) ) {
			$lookupTableLinks["Imp_PO_F_SC"] = array();
		}
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.SeqNo"] )) {
			$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.SeqNo"] = array();
		}
		$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.SeqNo"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "SeqNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"] ) ) {
			$lookupTableLinks["Imp_PO_F_SC"] = array();
		}
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.Cat_ID"] )) {
			$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.Cat_ID"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Fixed"] ) ) {
			$lookupTableLinks["ST_Item_Fixed"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Fixed"]["po_imp_f_item.Item_Code"] )) {
			$lookupTableLinks["ST_Item_Fixed"]["po_imp_f_item.Item_Code"] = array();
		}
		$lookupTableLinks["ST_Item_Fixed"]["po_imp_f_item.Item_Code"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"] ) ) {
			$lookupTableLinks["Imp_PO_F_SC"] = array();
		}
		if( !isset( $lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.SiniRef"] )) {
			$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.SiniRef"] = array();
		}
		$lookupTableLinks["Imp_PO_F_SC"]["po_imp_f_item.SiniRef"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "SiniRef", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["invoice_ex_item.Part_Id"] )) {
			$lookupTableLinks["Parts"]["invoice_ex_item.Part_Id"] = array();
		}
		$lookupTableLinks["Parts"]["invoice_ex_item.Part_Id"]["edit"] = array("table" => "Invoice_Ex_Item", "field" => "Part_Id", "page" => "edit");
}

?>