<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Defect_Departments"] ) ) {
			$lookupTableLinks["Defect_Departments"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Departments"]["defect_analysis_head.Department"] )) {
			$lookupTableLinks["Defect_Departments"]["defect_analysis_head.Department"] = array();
		}
		$lookupTableLinks["Defect_Departments"]["defect_analysis_head.Department"]["edit"] = array("table" => "Defect_Analysis_Head", "field" => "Department", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["defect_analysis_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["defect_analysis_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["defect_analysis_head.Sc_No"]["edit"] = array("table" => "Defect_Analysis_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["defect_analysis_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["defect_analysis_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["defect_analysis_head.Seq_No"]["edit"] = array("table" => "Defect_Analysis_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["defect_analysis_head.Model_Name"] )) {
			$lookupTableLinks["BD_Model"]["defect_analysis_head.Model_Name"] = array();
		}
		$lookupTableLinks["BD_Model"]["defect_analysis_head.Model_Name"]["edit"] = array("table" => "Defect_Analysis_Head", "field" => "Model_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Departments"] ) ) {
			$lookupTableLinks["Defect_Departments"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Departments"]["defect_analysis_item.Department"] )) {
			$lookupTableLinks["Defect_Departments"]["defect_analysis_item.Department"] = array();
		}
		$lookupTableLinks["Defect_Departments"]["defect_analysis_item.Department"]["edit"] = array("table" => "Defect_Analysis_Item", "field" => "Department", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Master"] ) ) {
			$lookupTableLinks["Defect_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Master"]["defect_analysis_item.Defect"] )) {
			$lookupTableLinks["Defect_Master"]["defect_analysis_item.Defect"] = array();
		}
		$lookupTableLinks["Defect_Master"]["defect_analysis_item.Defect"]["edit"] = array("table" => "Defect_Analysis_Item", "field" => "Defect", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Emp_Master"] ) ) {
			$lookupTableLinks["Defect_Emp_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Emp_Master"]["defect_analysis_item.Emp"] )) {
			$lookupTableLinks["Defect_Emp_Master"]["defect_analysis_item.Emp"] = array();
		}
		$lookupTableLinks["Defect_Emp_Master"]["defect_analysis_item.Emp"]["edit"] = array("table" => "Defect_Analysis_Item", "field" => "Emp", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Emp_Master"] ) ) {
			$lookupTableLinks["Defect_Emp_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Emp_Master"]["defect_analysis_item.Qc_Emp"] )) {
			$lookupTableLinks["Defect_Emp_Master"]["defect_analysis_item.Qc_Emp"] = array();
		}
		$lookupTableLinks["Defect_Emp_Master"]["defect_analysis_item.Qc_Emp"]["edit"] = array("table" => "Defect_Analysis_Item", "field" => "Qc_Emp", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Departments"] ) ) {
			$lookupTableLinks["Defect_Departments"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Departments"]["defect_emp_master.Department"] )) {
			$lookupTableLinks["Defect_Departments"]["defect_emp_master.Department"] = array();
		}
		$lookupTableLinks["Defect_Departments"]["defect_emp_master.Department"]["edit"] = array("table" => "Defect_Emp_Master", "field" => "Department", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Master"] ) ) {
			$lookupTableLinks["Defect_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Master"]["defect_action.Defect"] )) {
			$lookupTableLinks["Defect_Master"]["defect_action.Defect"] = array();
		}
		$lookupTableLinks["Defect_Master"]["defect_action.Defect"]["edit"] = array("table" => "Defect_Action", "field" => "Defect", "page" => "edit");
		if( !isset( $lookupTableLinks["Defect_Departments"] ) ) {
			$lookupTableLinks["Defect_Departments"] = array();
		}
		if( !isset( $lookupTableLinks["Defect_Departments"]["defect_master.Department"] )) {
			$lookupTableLinks["Defect_Departments"]["defect_master.Department"] = array();
		}
		$lookupTableLinks["Defect_Departments"]["defect_master.Department"]["edit"] = array("table" => "Defect_Master", "field" => "Department", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["wip_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["wip_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["wip_head.Cst_ID"]["edit"] = array("table" => "Wip_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["wip_head.Model"] )) {
			$lookupTableLinks["BD_Model"]["wip_head.Model"] = array();
		}
		$lookupTableLinks["BD_Model"]["wip_head.Model"]["edit"] = array("table" => "Wip_Head", "field" => "Model", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["wip_paint_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["wip_paint_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["wip_paint_head.Sc_No"]["edit"] = array("table" => "Wip_Paint_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["wip_paint_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["wip_paint_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["wip_paint_head.Seq_No"]["edit"] = array("table" => "Wip_Paint_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["wip_paint_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["wip_paint_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["wip_paint_head.Cst_ID"]["edit"] = array("table" => "Wip_Paint_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["wip_paint_head.Model"] )) {
			$lookupTableLinks["BD_Model"]["wip_paint_head.Model"] = array();
		}
		$lookupTableLinks["BD_Model"]["wip_paint_head.Model"]["edit"] = array("table" => "Wip_Paint_Head", "field" => "Model", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["local_sales_item.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["local_sales_item.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["local_sales_item.Sc_No"]["edit"] = array("table" => "Local_Sales_Item", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["local_sales_item.Model"] )) {
			$lookupTableLinks["BD_Model"]["local_sales_item.Model"] = array();
		}
		$lookupTableLinks["BD_Model"]["local_sales_item.Model"]["edit"] = array("table" => "Local_Sales_Item", "field" => "Model", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Scinfo"] ) ) {
			$lookupTableLinks["Ref_Scinfo"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Scinfo"]["local_sales_item.Ref_Seq_No"] )) {
			$lookupTableLinks["Ref_Scinfo"]["local_sales_item.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["Ref_Scinfo"]["local_sales_item.Ref_Seq_No"]["edit"] = array("table" => "Local_Sales_Item", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["crtn_mesurement.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["crtn_mesurement.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["crtn_mesurement.Sc_No"]["edit"] = array("table" => "CRTN_Mesurement", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Scinfo"] ) ) {
			$lookupTableLinks["Ref_Scinfo"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Scinfo"]["crtn_mesurement.Ref_Seq_No"] )) {
			$lookupTableLinks["Ref_Scinfo"]["crtn_mesurement.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["Ref_Scinfo"]["crtn_mesurement.Ref_Seq_No"]["edit"] = array("table" => "CRTN_Mesurement", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["crtn_mesurement.Model_Name"] )) {
			$lookupTableLinks["BD_Model"]["crtn_mesurement.Model_Name"] = array();
		}
		$lookupTableLinks["BD_Model"]["crtn_mesurement.Model_Name"]["edit"] = array("table" => "CRTN_Mesurement", "field" => "Model_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Att_Members"] ) ) {
			$lookupTableLinks["Att_Members"] = array();
		}
		if( !isset( $lookupTableLinks["Att_Members"]["att_dailly.Member"] )) {
			$lookupTableLinks["Att_Members"]["att_dailly.Member"] = array();
		}
		$lookupTableLinks["Att_Members"]["att_dailly.Member"]["edit"] = array("table" => "Att_Dailly", "field" => "Member", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["comments_shortage.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["comments_shortage.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["comments_shortage.Location"]["edit"] = array("table" => "Comments_Shortage", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Location"] ) ) {
			$lookupTableLinks["ST_Item_Location"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Location"]["comments_shortage_bulk.Location"] )) {
			$lookupTableLinks["ST_Item_Location"]["comments_shortage_bulk.Location"] = array();
		}
		$lookupTableLinks["ST_Item_Location"]["comments_shortage_bulk.Location"]["edit"] = array("table" => "Comments_Shortage_Bulk", "field" => "Location", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Procheck"] ) ) {
			$lookupTableLinks["Ref_Procheck"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Procheck"]["pro_checklist_head.PC_NO"] )) {
			$lookupTableLinks["Ref_Procheck"]["pro_checklist_head.PC_NO"] = array();
		}
		$lookupTableLinks["Ref_Procheck"]["pro_checklist_head.PC_NO"]["edit"] = array("table" => "Pro_Checklist_Head", "field" => "PC_NO", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Procheck"] ) ) {
			$lookupTableLinks["Ref_Procheck"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Procheck"]["pro_checklist_head.Seq_No"] )) {
			$lookupTableLinks["Ref_Procheck"]["pro_checklist_head.Seq_No"] = array();
		}
		$lookupTableLinks["Ref_Procheck"]["pro_checklist_head.Seq_No"]["edit"] = array("table" => "Pro_Checklist_Head", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Pro_Checklist_ConsiderItems"] ) ) {
			$lookupTableLinks["Pro_Checklist_ConsiderItems"] = array();
		}
		if( !isset( $lookupTableLinks["Pro_Checklist_ConsiderItems"]["pro_checklist_ibws.Item_Code"] )) {
			$lookupTableLinks["Pro_Checklist_ConsiderItems"]["pro_checklist_ibws.Item_Code"] = array();
		}
		$lookupTableLinks["Pro_Checklist_ConsiderItems"]["pro_checklist_ibws.Item_Code"]["edit"] = array("table" => "Pro_Checklist_IBWS", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Pro_Checklist_Departments"] ) ) {
			$lookupTableLinks["Pro_Checklist_Departments"] = array();
		}
		if( !isset( $lookupTableLinks["Pro_Checklist_Departments"]["pro_checklist_ibws.Department"] )) {
			$lookupTableLinks["Pro_Checklist_Departments"]["pro_checklist_ibws.Department"] = array();
		}
		$lookupTableLinks["Pro_Checklist_Departments"]["pro_checklist_ibws.Department"]["edit"] = array("table" => "Pro_Checklist_IBWS", "field" => "Department", "page" => "edit");
		if( !isset( $lookupTableLinks["To_Time"] ) ) {
			$lookupTableLinks["To_Time"] = array();
		}
		if( !isset( $lookupTableLinks["To_Time"]["ot_master.OT_Start_Time"] )) {
			$lookupTableLinks["To_Time"]["ot_master.OT_Start_Time"] = array();
		}
		$lookupTableLinks["To_Time"]["ot_master.OT_Start_Time"]["edit"] = array("table" => "OT_Master", "field" => "OT_Start_Time", "page" => "edit");
		if( !isset( $lookupTableLinks["Att_Departments"] ) ) {
			$lookupTableLinks["Att_Departments"] = array();
		}
		if( !isset( $lookupTableLinks["Att_Departments"]["ot_emp_time.Department"] )) {
			$lookupTableLinks["Att_Departments"]["ot_emp_time.Department"] = array();
		}
		$lookupTableLinks["Att_Departments"]["ot_emp_time.Department"]["edit"] = array("table" => "OT_Emp_Time", "field" => "Department", "page" => "edit");
		if( !isset( $lookupTableLinks["To_Time"] ) ) {
			$lookupTableLinks["To_Time"] = array();
		}
		if( !isset( $lookupTableLinks["To_Time"]["ot_emp_time.To_time"] )) {
			$lookupTableLinks["To_Time"]["ot_emp_time.To_time"] = array();
		}
		$lookupTableLinks["To_Time"]["ot_emp_time.To_time"]["edit"] = array("table" => "OT_Emp_Time", "field" => "To_time", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To1"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To1"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To1"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To1", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To2"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To2"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To2"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To2", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To3"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To3"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To3"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To3", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To4"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To4"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To4"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To4", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To5"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To5"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To5"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To5", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["reminder_head_bd.BD_Model"] )) {
			$lookupTableLinks["BD_Model"]["reminder_head_bd.BD_Model"] = array();
		}
		$lookupTableLinks["BD_Model"]["reminder_head_bd.BD_Model"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "BD_Model", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["reminder_head_bd.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["reminder_head_bd.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["reminder_head_bd.Sc_No"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To6"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To6"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To6"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To6", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To7"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To7"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To7"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To7", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["reminder_head_bd.To8"] )) {
			$lookupTableLinks["webusers"]["reminder_head_bd.To8"] = array();
		}
		$lookupTableLinks["webusers"]["reminder_head_bd.To8"]["edit"] = array("table" => "Reminder_Head_BD", "field" => "To8", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["replcement_req_head.Issued_by"] )) {
			$lookupTableLinks["webusers"]["replcement_req_head.Issued_by"] = array();
		}
		$lookupTableLinks["webusers"]["replcement_req_head.Issued_by"]["edit"] = array("table" => "Replcement_Req_Head", "field" => "Issued_by", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["replcement_req_head.Mode"] )) {
			$lookupTableLinks["Fright"]["replcement_req_head.Mode"] = array();
		}
		$lookupTableLinks["Fright"]["replcement_req_head.Mode"]["edit"] = array("table" => "Replcement_Req_Head", "field" => "Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["replcement_req_head.Customer"] )) {
			$lookupTableLinks["Customer"]["replcement_req_head.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["replcement_req_head.Customer"]["edit"] = array("table" => "Replcement_Req_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["CusDec"] ) ) {
			$lookupTableLinks["CusDec"] = array();
		}
		if( !isset( $lookupTableLinks["CusDec"]["replcement_req_head.CNT_No"] )) {
			$lookupTableLinks["CusDec"]["replcement_req_head.CNT_No"] = array();
		}
		$lookupTableLinks["CusDec"]["replcement_req_head.CNT_No"]["edit"] = array("table" => "Replcement_Req_Head", "field" => "CNT_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["replacement_item_bd.Pc_NO"] )) {
			$lookupTableLinks["Sc_Head"]["replacement_item_bd.Pc_NO"] = array();
		}
		$lookupTableLinks["Sc_Head"]["replacement_item_bd.Pc_NO"]["edit"] = array("table" => "Replacement_Item_BD", "field" => "Pc_NO", "page" => "edit");
		if( !isset( $lookupTableLinks["Replacement_Item"] ) ) {
			$lookupTableLinks["Replacement_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Replacement_Item"]["replacement_item_bd.Item"] )) {
			$lookupTableLinks["Replacement_Item"]["replacement_item_bd.Item"] = array();
		}
		$lookupTableLinks["Replacement_Item"]["replacement_item_bd.Item"]["edit"] = array("table" => "Replacement_Item_BD", "field" => "Item", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Artwork1"] ) ) {
			$lookupTableLinks["Ref_Artwork1"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Artwork1"]["replacement_item_bd.Ref_Seq_No"] )) {
			$lookupTableLinks["Ref_Artwork1"]["replacement_item_bd.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["Ref_Artwork1"]["replacement_item_bd.Ref_Seq_No"]["edit"] = array("table" => "Replacement_Item_BD", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Att_Members"] ) ) {
			$lookupTableLinks["Att_Members"] = array();
		}
		if( !isset( $lookupTableLinks["Att_Members"]["att_department_emp.Emp_Cat"] )) {
			$lookupTableLinks["Att_Members"]["att_department_emp.Emp_Cat"] = array();
		}
		$lookupTableLinks["Att_Members"]["att_department_emp.Emp_Cat"]["edit"] = array("table" => "Att_Department_Emp", "field" => "Emp_Cat", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["qc_comments_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["qc_comments_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["qc_comments_head.Sc_No"]["edit"] = array("table" => "QC_Comments_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item2"] ) ) {
			$lookupTableLinks["SC_Item2"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item2"]["qc_comments_head.Seq_No"] )) {
			$lookupTableLinks["SC_Item2"]["qc_comments_head.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item2"]["qc_comments_head.Seq_No"]["edit"] = array("table" => "QC_Comments_Head", "field" => "Seq_No", "page" => "edit");
}

?>