<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Travel_Passenger"] ) ) {
			$lookupTableLinks["Travel_Passenger"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Passenger"]["travel_flight_head.Passenger_Name"] )) {
			$lookupTableLinks["Travel_Passenger"]["travel_flight_head.Passenger_Name"] = array();
		}
		$lookupTableLinks["Travel_Passenger"]["travel_flight_head.Passenger_Name"]["edit"] = array("table" => "Travel_Flight_Head", "field" => "Passenger_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Agent"] ) ) {
			$lookupTableLinks["Travel_Agent"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Agent"]["travel_flight_head.Travel_Agent"] )) {
			$lookupTableLinks["Travel_Agent"]["travel_flight_head.Travel_Agent"] = array();
		}
		$lookupTableLinks["Travel_Agent"]["travel_flight_head.Travel_Agent"]["edit"] = array("table" => "Travel_Flight_Head", "field" => "Travel_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Aero_Class"] ) ) {
			$lookupTableLinks["Travel_Aero_Class"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Aero_Class"]["travel_flight_head.Class_Name"] )) {
			$lookupTableLinks["Travel_Aero_Class"]["travel_flight_head.Class_Name"] = array();
		}
		$lookupTableLinks["Travel_Aero_Class"]["travel_flight_head.Class_Name"]["edit"] = array("table" => "Travel_Flight_Head", "field" => "Class_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Destination"] ) ) {
			$lookupTableLinks["Travel_Destination"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Destination"]["travel_flight_item.Dest_From"] )) {
			$lookupTableLinks["Travel_Destination"]["travel_flight_item.Dest_From"] = array();
		}
		$lookupTableLinks["Travel_Destination"]["travel_flight_item.Dest_From"]["edit"] = array("table" => "Travel_Flight_Item", "field" => "Dest_From", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Destination"] ) ) {
			$lookupTableLinks["Travel_Destination"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Destination"]["travel_flight_item.Dest_To"] )) {
			$lookupTableLinks["Travel_Destination"]["travel_flight_item.Dest_To"] = array();
		}
		$lookupTableLinks["Travel_Destination"]["travel_flight_item.Dest_To"]["edit"] = array("table" => "Travel_Flight_Item", "field" => "Dest_To", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Aero_Class"] ) ) {
			$lookupTableLinks["Travel_Aero_Class"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Aero_Class"]["travel_flight_item.Class_Name"] )) {
			$lookupTableLinks["Travel_Aero_Class"]["travel_flight_item.Class_Name"] = array();
		}
		$lookupTableLinks["Travel_Aero_Class"]["travel_flight_item.Class_Name"]["edit"] = array("table" => "Travel_Flight_Item", "field" => "Class_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Passenger"] ) ) {
			$lookupTableLinks["Travel_Passenger"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Passenger"]["expiary_trips.Passenger_Name"] )) {
			$lookupTableLinks["Travel_Passenger"]["expiary_trips.Passenger_Name"] = array();
		}
		$lookupTableLinks["Travel_Passenger"]["expiary_trips.Passenger_Name"]["edit"] = array("table" => "Expiary_Trips", "field" => "Passenger_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Destination"] ) ) {
			$lookupTableLinks["Travel_Destination"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Destination"]["expiary_trips_items.Dest_From"] )) {
			$lookupTableLinks["Travel_Destination"]["expiary_trips_items.Dest_From"] = array();
		}
		$lookupTableLinks["Travel_Destination"]["expiary_trips_items.Dest_From"]["edit"] = array("table" => "Expiary_Trips_Items", "field" => "Dest_From", "page" => "edit");
		if( !isset( $lookupTableLinks["Travel_Destination"] ) ) {
			$lookupTableLinks["Travel_Destination"] = array();
		}
		if( !isset( $lookupTableLinks["Travel_Destination"]["expiary_trips_items.Dest_To"] )) {
			$lookupTableLinks["Travel_Destination"]["expiary_trips_items.Dest_To"] = array();
		}
		$lookupTableLinks["Travel_Destination"]["expiary_trips_items.Dest_To"]["edit"] = array("table" => "Expiary_Trips_Items", "field" => "Dest_To", "page" => "edit");
}

?>