<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Container_Size"] ) ) {
			$lookupTableLinks["Container_Size"] = array();
		}
		if( !isset( $lookupTableLinks["Container_Size"]["exp_inv_main.SZ1"] )) {
			$lookupTableLinks["Container_Size"]["exp_inv_main.SZ1"] = array();
		}
		$lookupTableLinks["Container_Size"]["exp_inv_main.SZ1"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "SZ1", "page" => "edit");
		if( !isset( $lookupTableLinks["Container_Size"] ) ) {
			$lookupTableLinks["Container_Size"] = array();
		}
		if( !isset( $lookupTableLinks["Container_Size"]["exp_inv_main.SZ2"] )) {
			$lookupTableLinks["Container_Size"]["exp_inv_main.SZ2"] = array();
		}
		$lookupTableLinks["Container_Size"]["exp_inv_main.SZ2"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "SZ2", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["exp_inv_main.TitleID"] )) {
			$lookupTableLinks["Title"]["exp_inv_main.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["exp_inv_main.TitleID"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["exp_inv_main.ByOrdAcOf"] )) {
			$lookupTableLinks["Title"]["exp_inv_main.ByOrdAcOf"] = array();
		}
		$lookupTableLinks["Title"]["exp_inv_main.ByOrdAcOf"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "ByOrdAcOf", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["exp_inv_main.BuyerID"] )) {
			$lookupTableLinks["Customer"]["exp_inv_main.BuyerID"] = array();
		}
		$lookupTableLinks["Customer"]["exp_inv_main.BuyerID"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "BuyerID", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["exp_inv_main.PortOfLoading"] )) {
			$lookupTableLinks["Loading_Ports"]["exp_inv_main.PortOfLoading"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["exp_inv_main.PortOfLoading"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "PortOfLoading", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["exp_inv_main.PortOfDischarge"] )) {
			$lookupTableLinks["Destinations"]["exp_inv_main.PortOfDischarge"] = array();
		}
		$lookupTableLinks["Destinations"]["exp_inv_main.PortOfDischarge"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "PortOfDischarge", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["exp_inv_main.FinalDest"] )) {
			$lookupTableLinks["Destinations"]["exp_inv_main.FinalDest"] = array();
		}
		$lookupTableLinks["Destinations"]["exp_inv_main.FinalDest"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "FinalDest", "page" => "edit");
		if( !isset( $lookupTableLinks["Sh_Company"] ) ) {
			$lookupTableLinks["Sh_Company"] = array();
		}
		if( !isset( $lookupTableLinks["Sh_Company"]["exp_inv_main.ShpgLine"] )) {
			$lookupTableLinks["Sh_Company"]["exp_inv_main.ShpgLine"] = array();
		}
		$lookupTableLinks["Sh_Company"]["exp_inv_main.ShpgLine"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "ShpgLine", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["exp_inv_main.NotifyParty"] )) {
			$lookupTableLinks["Title"]["exp_inv_main.NotifyParty"] = array();
		}
		$lookupTableLinks["Title"]["exp_inv_main.NotifyParty"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "NotifyParty", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["exp_inv_main.ForwarderName"] )) {
			$lookupTableLinks["Forwaders"]["exp_inv_main.ForwarderName"] = array();
		}
		$lookupTableLinks["Forwaders"]["exp_inv_main.ForwarderName"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "ForwarderName", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["exp_inv_main.PYMT_Term"] )) {
			$lookupTableLinks["Payterms_new"]["exp_inv_main.PYMT_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["exp_inv_main.PYMT_Term"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "PYMT_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["exp_inv_main.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["exp_inv_main.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["exp_inv_main.SHPG_Term"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Agent_Master"] ) ) {
			$lookupTableLinks["Agent_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Agent_Master"]["exp_inv_main.Cust_Agent"] )) {
			$lookupTableLinks["Agent_Master"]["exp_inv_main.Cust_Agent"] = array();
		}
		$lookupTableLinks["Agent_Master"]["exp_inv_main.Cust_Agent"]["edit"] = array("table" => "Exp_Inv_Main", "field" => "Cust_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["exp_inv_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["exp_inv_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["exp_inv_head.Sc_No"]["edit"] = array("table" => "Exp_Inv_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["exp_inv_item.Article"] )) {
			$lookupTableLinks["BD_Model"]["exp_inv_item.Article"] = array();
		}
		$lookupTableLinks["BD_Model"]["exp_inv_item.Article"]["edit"] = array("table" => "Exp_Inv_Item", "field" => "Article", "page" => "edit");
		if( !isset( $lookupTableLinks["Exp_Inv_Cont"] ) ) {
			$lookupTableLinks["Exp_Inv_Cont"] = array();
		}
		if( !isset( $lookupTableLinks["Exp_Inv_Cont"]["exp_inv_ex_pack.CNTR_No"] )) {
			$lookupTableLinks["Exp_Inv_Cont"]["exp_inv_ex_pack.CNTR_No"] = array();
		}
		$lookupTableLinks["Exp_Inv_Cont"]["exp_inv_ex_pack.CNTR_No"]["edit"] = array("table" => "Exp_Inv_Ex_Pack", "field" => "CNTR_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Exp_Inv_Cont"] ) ) {
			$lookupTableLinks["Exp_Inv_Cont"] = array();
		}
		if( !isset( $lookupTableLinks["Exp_Inv_Cont"]["exp_inv_pack.CNTR_No"] )) {
			$lookupTableLinks["Exp_Inv_Cont"]["exp_inv_pack.CNTR_No"] = array();
		}
		$lookupTableLinks["Exp_Inv_Cont"]["exp_inv_pack.CNTR_No"]["edit"] = array("table" => "Exp_Inv_Pack", "field" => "CNTR_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Factory"] ) ) {
			$lookupTableLinks["Factory"] = array();
		}
		if( !isset( $lookupTableLinks["Factory"]["pc_head.fty_ID"] )) {
			$lookupTableLinks["Factory"]["pc_head.fty_ID"] = array();
		}
		$lookupTableLinks["Factory"]["pc_head.fty_ID"]["edit"] = array("table" => "PC_Head", "field" => "fty_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["pc_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["pc_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["pc_head.Cst_ID"]["edit"] = array("table" => "PC_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["ibws_bd.Model_Name"] )) {
			$lookupTableLinks["BD_Model"]["ibws_bd.Model_Name"] = array();
		}
		$lookupTableLinks["BD_Model"]["ibws_bd.Model_Name"]["edit"] = array("table" => "ibws_bd", "field" => "Model_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["ibws_bd_ssp.Model_No"] )) {
			$lookupTableLinks["BD_Model"]["ibws_bd_ssp.Model_No"] = array();
		}
		$lookupTableLinks["BD_Model"]["ibws_bd_ssp.Model_No"]["edit"] = array("table" => "ibws_bd_ssp", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["ibws_head_inv.PayTerms1"] )) {
			$lookupTableLinks["Payterms_new"]["ibws_head_inv.PayTerms1"] = array();
		}
		$lookupTableLinks["Payterms_new"]["ibws_head_inv.PayTerms1"]["edit"] = array("table" => "Ibws_Head_Inv", "field" => "PayTerms1", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["st_item.Category"] )) {
			$lookupTableLinks["Parts"]["st_item.Category"] = array();
		}
		$lookupTableLinks["Parts"]["st_item.Category"]["edit"] = array("table" => "ST_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["assets_item.Category"] )) {
			$lookupTableLinks["Assets_Group"]["assets_item.Category"] = array();
		}
		$lookupTableLinks["Assets_Group"]["assets_item.Category"]["edit"] = array("table" => "Assets_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["CusDec"] ) ) {
			$lookupTableLinks["CusDec"] = array();
		}
		if( !isset( $lookupTableLinks["CusDec"]["request_imp_permit_item.Inv_No"] )) {
			$lookupTableLinks["CusDec"]["request_imp_permit_item.Inv_No"] = array();
		}
		$lookupTableLinks["CusDec"]["request_imp_permit_item.Inv_No"]["edit"] = array("table" => "Request_Imp_Permit_Item", "field" => "Inv_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Import_Items"] ) ) {
			$lookupTableLinks["Import_Items"] = array();
		}
		if( !isset( $lookupTableLinks["Import_Items"]["request_imp_permit_item.Description"] )) {
			$lookupTableLinks["Import_Items"]["request_imp_permit_item.Description"] = array();
		}
		$lookupTableLinks["Import_Items"]["request_imp_permit_item.Description"]["edit"] = array("table" => "Request_Imp_Permit_Item", "field" => "Description", "page" => "edit");
		if( !isset( $lookupTableLinks["TRI_Exp_Inv_Main"] ) ) {
			$lookupTableLinks["TRI_Exp_Inv_Main"] = array();
		}
		if( !isset( $lookupTableLinks["TRI_Exp_Inv_Main"]["request_imp_permit_item.TRI_Inv"] )) {
			$lookupTableLinks["TRI_Exp_Inv_Main"]["request_imp_permit_item.TRI_Inv"] = array();
		}
		$lookupTableLinks["TRI_Exp_Inv_Main"]["request_imp_permit_item.TRI_Inv"]["edit"] = array("table" => "Request_Imp_Permit_Item", "field" => "TRI_Inv", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item_Model13"] ) ) {
			$lookupTableLinks["SC_Item_Model13"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item_Model13"]["export_coststatement_head.Sc_No"] )) {
			$lookupTableLinks["SC_Item_Model13"]["export_coststatement_head.Sc_No"] = array();
		}
		$lookupTableLinks["SC_Item_Model13"]["export_coststatement_head.Sc_No"]["edit"] = array("table" => "Export_Coststatement_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["fgs_stock.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["fgs_stock.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["fgs_stock.Sc_No"]["edit"] = array("table" => "FGS_Stock", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item_Model11"] ) ) {
			$lookupTableLinks["SC_Item_Model11"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item_Model11"]["fgs_stock.Ref_Seq_No"] )) {
			$lookupTableLinks["SC_Item_Model11"]["fgs_stock.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item_Model11"]["fgs_stock.Ref_Seq_No"]["edit"] = array("table" => "FGS_Stock", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["FGS_Reason"] ) ) {
			$lookupTableLinks["FGS_Reason"] = array();
		}
		if( !isset( $lookupTableLinks["FGS_Reason"]["fgs_stock.Reason"] )) {
			$lookupTableLinks["FGS_Reason"]["fgs_stock.Reason"] = array();
		}
		$lookupTableLinks["FGS_Reason"]["fgs_stock.Reason"]["edit"] = array("table" => "FGS_Stock", "field" => "Reason", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["export_shipping_advise.Customer"] )) {
			$lookupTableLinks["Customer"]["export_shipping_advise.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["export_shipping_advise.Customer"]["edit"] = array("table" => "Export_Shipping_Advise", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["export_advice_item.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["export_advice_item.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["export_advice_item.Sc_No"]["edit"] = array("table" => "Export_Advice_Item", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["export_advice_item.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["export_advice_item.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["export_advice_item.Seq_No"]["edit"] = array("table" => "Export_Advice_Item", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["export_advice_item.Model_No"] )) {
			$lookupTableLinks["BD_Model"]["export_advice_item.Model_No"] = array();
		}
		$lookupTableLinks["BD_Model"]["export_advice_item.Model_No"]["edit"] = array("table" => "Export_Advice_Item", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Factory"] ) ) {
			$lookupTableLinks["Factory"] = array();
		}
		if( !isset( $lookupTableLinks["Factory"]["ref_importinvlist.SUPPLCode"] )) {
			$lookupTableLinks["Factory"]["ref_importinvlist.SUPPLCode"] = array();
		}
		$lookupTableLinks["Factory"]["ref_importinvlist.SUPPLCode"]["edit"] = array("table" => "Ref_Importinvlist", "field" => "SUPPLCode", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["exp_inv_ex_item.Part_Id"] )) {
			$lookupTableLinks["Parts"]["exp_inv_ex_item.Part_Id"] = array();
		}
		$lookupTableLinks["Parts"]["exp_inv_ex_item.Part_Id"]["edit"] = array("table" => "Exp_Inv_Ex_Item", "field" => "Part_Id", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["shipping_head_contlist.From"] )) {
			$lookupTableLinks["Loading_Ports"]["shipping_head_contlist.From"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["shipping_head_contlist.From"]["edit"] = array("table" => "shipping_head_contlist", "field" => "From", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["shipping_head_contlist.PayTerms"] )) {
			$lookupTableLinks["Payterms_new"]["shipping_head_contlist.PayTerms"] = array();
		}
		$lookupTableLinks["Payterms_new"]["shipping_head_contlist.PayTerms"]["edit"] = array("table" => "shipping_head_contlist", "field" => "PayTerms", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["shipping_head_contlist.BuyerID"] )) {
			$lookupTableLinks["Customer"]["shipping_head_contlist.BuyerID"] = array();
		}
		$lookupTableLinks["Customer"]["shipping_head_contlist.BuyerID"]["edit"] = array("table" => "shipping_head_contlist", "field" => "BuyerID", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["shp_adv_head.From"] )) {
			$lookupTableLinks["Loading_Ports"]["shp_adv_head.From"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["shp_adv_head.From"]["edit"] = array("table" => "SHP_Adv_Head", "field" => "From", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["shp_adv_head.PayTerms"] )) {
			$lookupTableLinks["Payterms_new"]["shp_adv_head.PayTerms"] = array();
		}
		$lookupTableLinks["Payterms_new"]["shp_adv_head.PayTerms"]["edit"] = array("table" => "SHP_Adv_Head", "field" => "PayTerms", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["shp_adv_head.BuyerID"] )) {
			$lookupTableLinks["Customer"]["shp_adv_head.BuyerID"] = array();
		}
		$lookupTableLinks["Customer"]["shp_adv_head.BuyerID"]["edit"] = array("table" => "SHP_Adv_Head", "field" => "BuyerID", "page" => "edit");
}

?>