<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Cash_Flow_MainItems"] ) ) {
			$lookupTableLinks["Cash_Flow_MainItems"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_MainItems"]["cash_flow_daillyitems.Main_Item"] )) {
			$lookupTableLinks["Cash_Flow_MainItems"]["cash_flow_daillyitems.Main_Item"] = array();
		}
		$lookupTableLinks["Cash_Flow_MainItems"]["cash_flow_daillyitems.Main_Item"]["edit"] = array("table" => "Cash_Flow_DaillyItems", "field" => "Main_Item", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category"] ) ) {
			$lookupTableLinks["Utility_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category"]["utility_subcategory.Category"] )) {
			$lookupTableLinks["Utility_Category"]["utility_subcategory.Category"] = array();
		}
		$lookupTableLinks["Utility_Category"]["utility_subcategory.Category"]["edit"] = array("table" => "Utility_SubCategory", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Sub"] ) ) {
			$lookupTableLinks["Utility_Sub"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Sub"]["utility_subcategory.Sub"] )) {
			$lookupTableLinks["Utility_Sub"]["utility_subcategory.Sub"] = array();
		}
		$lookupTableLinks["Utility_Sub"]["utility_subcategory.Sub"]["edit"] = array("table" => "Utility_SubCategory", "field" => "Sub", "page" => "edit");
		if( !isset( $lookupTableLinks["Exp_Inv_Main"] ) ) {
			$lookupTableLinks["Exp_Inv_Main"] = array();
		}
		if( !isset( $lookupTableLinks["Exp_Inv_Main"]["export_cost_head.Exp_Inv"] )) {
			$lookupTableLinks["Exp_Inv_Main"]["export_cost_head.Exp_Inv"] = array();
		}
		$lookupTableLinks["Exp_Inv_Main"]["export_cost_head.Exp_Inv"]["edit"] = array("table" => "Export_Cost_Head", "field" => "Exp_Inv", "page" => "edit");
		if( !isset( $lookupTableLinks["Export_Cost_Category"] ) ) {
			$lookupTableLinks["Export_Cost_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Export_Cost_Category"]["export_cost_item.Category"] )) {
			$lookupTableLinks["Export_Cost_Category"]["export_cost_item.Category"] = array();
		}
		$lookupTableLinks["Export_Cost_Category"]["export_cost_item.Category"]["edit"] = array("table" => "Export_Cost_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["export_cost_payment_head.Supplier_ID"] )) {
			$lookupTableLinks["Forwaders"]["export_cost_payment_head.Supplier_ID"] = array();
		}
		$lookupTableLinks["Forwaders"]["export_cost_payment_head.Supplier_ID"]["edit"] = array("table" => "Export_Cost_Payment_Head", "field" => "Supplier_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Export_Cost_Category"] ) ) {
			$lookupTableLinks["Export_Cost_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Export_Cost_Category"]["export_cost_payment_head.Category"] )) {
			$lookupTableLinks["Export_Cost_Category"]["export_cost_payment_head.Category"] = array();
		}
		$lookupTableLinks["Export_Cost_Category"]["export_cost_payment_head.Category"]["edit"] = array("table" => "Export_Cost_Payment_Head", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["export_cost_payment_head.Forwader_ID"] )) {
			$lookupTableLinks["Forwaders"]["export_cost_payment_head.Forwader_ID"] = array();
		}
		$lookupTableLinks["Forwaders"]["export_cost_payment_head.Forwader_ID"]["edit"] = array("table" => "Export_Cost_Payment_Head", "field" => "Forwader_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Exp_Inv_Main"] ) ) {
			$lookupTableLinks["Exp_Inv_Main"] = array();
		}
		if( !isset( $lookupTableLinks["Exp_Inv_Main"]["export_cost_payment_item.Export_Inv"] )) {
			$lookupTableLinks["Exp_Inv_Main"]["export_cost_payment_item.Export_Inv"] = array();
		}
		$lookupTableLinks["Exp_Inv_Main"]["export_cost_payment_item.Export_Inv"]["edit"] = array("table" => "Export_Cost_Payment_Item", "field" => "Export_Inv", "page" => "edit");
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"] ) ) {
			$lookupTableLinks["Request_Imp_Permit_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_head.BL_No"] )) {
			$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_head.BL_No"] = array();
		}
		$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_head.BL_No"]["edit"] = array("table" => "Import_Cost_Head", "field" => "BL_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"] ) ) {
			$lookupTableLinks["Request_Imp_Permit_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_head.IP_No"] )) {
			$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_head.IP_No"] = array();
		}
		$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_head.IP_No"]["edit"] = array("table" => "Import_Cost_Head", "field" => "IP_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Import_Cost_Category"] ) ) {
			$lookupTableLinks["Import_Cost_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Import_Cost_Category"]["import_cost_item.Category"] )) {
			$lookupTableLinks["Import_Cost_Category"]["import_cost_item.Category"] = array();
		}
		$lookupTableLinks["Import_Cost_Category"]["import_cost_item.Category"]["edit"] = array("table" => "Import_Cost_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Import_Suppliers"] ) ) {
			$lookupTableLinks["Import_Suppliers"] = array();
		}
		if( !isset( $lookupTableLinks["Import_Suppliers"]["import_cost_payment_head.Supplier_ID"] )) {
			$lookupTableLinks["Import_Suppliers"]["import_cost_payment_head.Supplier_ID"] = array();
		}
		$lookupTableLinks["Import_Suppliers"]["import_cost_payment_head.Supplier_ID"]["edit"] = array("table" => "Import_Cost_Payment_Head", "field" => "Supplier_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Import_Cost_Category"] ) ) {
			$lookupTableLinks["Import_Cost_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Import_Cost_Category"]["import_cost_payment_head.Category"] )) {
			$lookupTableLinks["Import_Cost_Category"]["import_cost_payment_head.Category"] = array();
		}
		$lookupTableLinks["Import_Cost_Category"]["import_cost_payment_head.Category"]["edit"] = array("table" => "Import_Cost_Payment_Head", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"] ) ) {
			$lookupTableLinks["Request_Imp_Permit_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_payment_item.BL_No"] )) {
			$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_payment_item.BL_No"] = array();
		}
		$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_payment_item.BL_No"]["edit"] = array("table" => "Import_Cost_Payment_Item", "field" => "BL_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"] ) ) {
			$lookupTableLinks["Request_Imp_Permit_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_payment_item.IP_No"] )) {
			$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_payment_item.IP_No"] = array();
		}
		$lookupTableLinks["Request_Imp_Permit_Head"]["import_cost_payment_item.IP_No"]["edit"] = array("table" => "Import_Cost_Payment_Item", "field" => "IP_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category"] ) ) {
			$lookupTableLinks["Utility_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category"]["utility_head.Category"] )) {
			$lookupTableLinks["Utility_Category"]["utility_head.Category"] = array();
		}
		$lookupTableLinks["Utility_Category"]["utility_head.Category"]["edit"] = array("table" => "Utility_Head", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_SubCategory"] ) ) {
			$lookupTableLinks["Utility_SubCategory"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_SubCategory"]["utility_head.Sub_Category"] )) {
			$lookupTableLinks["Utility_SubCategory"]["utility_head.Sub_Category"] = array();
		}
		$lookupTableLinks["Utility_SubCategory"]["utility_head.Sub_Category"]["edit"] = array("table" => "Utility_Head", "field" => "Sub_Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Sub"] ) ) {
			$lookupTableLinks["Utility_Sub"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Sub"]["utility_head.Sub"] )) {
			$lookupTableLinks["Utility_Sub"]["utility_head.Sub"] = array();
		}
		$lookupTableLinks["Utility_Sub"]["utility_head.Sub"]["edit"] = array("table" => "Utility_Head", "field" => "Sub", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category"] ) ) {
			$lookupTableLinks["Utility_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category"]["utility_budget_item.Category"] )) {
			$lookupTableLinks["Utility_Category"]["utility_budget_item.Category"] = array();
		}
		$lookupTableLinks["Utility_Category"]["utility_budget_item.Category"]["edit"] = array("table" => "Utility_Budget_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_SubCategory"] ) ) {
			$lookupTableLinks["Utility_SubCategory"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_SubCategory"]["utility_budget_item.Subcategory"] )) {
			$lookupTableLinks["Utility_SubCategory"]["utility_budget_item.Subcategory"] = array();
		}
		$lookupTableLinks["Utility_SubCategory"]["utility_budget_item.Subcategory"]["edit"] = array("table" => "Utility_Budget_Item", "field" => "Subcategory", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Sub"] ) ) {
			$lookupTableLinks["Utility_Sub"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Sub"]["utility_budget_item.Sub"] )) {
			$lookupTableLinks["Utility_Sub"]["utility_budget_item.Sub"] = array();
		}
		$lookupTableLinks["Utility_Sub"]["utility_budget_item.Sub"]["edit"] = array("table" => "Utility_Budget_Item", "field" => "Sub", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category"] ) ) {
			$lookupTableLinks["Utility_Category"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category"]["cash_flow_head_new.Category"] )) {
			$lookupTableLinks["Utility_Category"]["cash_flow_head_new.Category"] = array();
		}
		$lookupTableLinks["Utility_Category"]["cash_flow_head_new.Category"]["edit"] = array("table" => "Cash_Flow_Head_New", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_newutilitycat"] ) ) {
			$lookupTableLinks["Ref_newutilitycat"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_newutilitycat"]["cash_flow_head_new.Sub_Category"] )) {
			$lookupTableLinks["Ref_newutilitycat"]["cash_flow_head_new.Sub_Category"] = array();
		}
		$lookupTableLinks["Ref_newutilitycat"]["cash_flow_head_new.Sub_Category"]["edit"] = array("table" => "Cash_Flow_Head_New", "field" => "Sub_Category", "page" => "edit");
}

?>