<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("webusers");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblfirefoxbd_at_localhost__Cash_Flow_DaillyItems;
	var $tblfirefoxbd_at_localhost__Cash_Flow_Head_Main_New;
	var $tblfirefoxbd_at_localhost__Cash_Flow_Head_New;
	var $tblfirefoxbd_at_localhost__Cash_Flow_MainItems;
	var $tblfirefoxbd_at_localhost__corvoproject_audit;
	var $tblfirefoxbd_at_localhost__corvoproject_ugrights;
	var $tblfirefoxbd_at_localhost__Exp_Inv_Main;
	var $tblfirefoxbd_at_localhost__Export_Cost_Category;
	var $tblfirefoxbd_at_localhost__Export_Cost_Head;
	var $tblfirefoxbd_at_localhost__Export_Cost_Item;
	var $tblfirefoxbd_at_localhost__Export_Cost_Payment_Head;
	var $tblfirefoxbd_at_localhost__Export_Cost_Payment_Item;
	var $tblfirefoxbd_at_localhost__Export_Heading;
	var $tblfirefoxbd_at_localhost__ffxbderp_uggroups;
	var $tblfirefoxbd_at_localhost__ffxbderp_ugmembers;
	var $tblfirefoxbd_at_localhost__ffxbderp_ugrights;
	var $tblfirefoxbd_at_localhost__Forwaders;
	var $tblfirefoxbd_at_localhost__Forwaders_Local;
	var $tblfirefoxbd_at_localhost__Import_Cost_Category;
	var $tblfirefoxbd_at_localhost__Import_Cost_Head;
	var $tblfirefoxbd_at_localhost__Import_Cost_Item;
	var $tblfirefoxbd_at_localhost__Import_Cost_Payment_Head;
	var $tblfirefoxbd_at_localhost__Import_Cost_Payment_Item;
	var $tblfirefoxbd_at_localhost__Import_Heading;
	var $tblfirefoxbd_at_localhost__Import_Suppliers;
	var $tblfirefoxbd_at_localhost__Request_Imp_Permit_Head;
	var $tblfirefoxbd_at_localhost__Utility_Budget_Head;
	var $tblfirefoxbd_at_localhost__Utility_Budget_Item;
	var $tblfirefoxbd_at_localhost__Utility_Category;
	var $tblfirefoxbd_at_localhost__Utility_Head;
	var $tblfirefoxbd_at_localhost__Utility_Sub;
	var $tblfirefoxbd_at_localhost__Utility_SubCategory;
	var $tblfirefoxbd_at_localhost__webusers;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "Cash_Flow_DaillyItems", "varname" => "firefoxbd_at_localhost__Cash_Flow_DaillyItems", "altvarname" => "Cash_Flow_DaillyItems", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_Head_Main_New", "varname" => "firefoxbd_at_localhost__Cash_Flow_Head_Main_New", "altvarname" => "Cash_Flow_Head_Main_New", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_Head_New", "varname" => "firefoxbd_at_localhost__Cash_Flow_Head_New", "altvarname" => "Cash_Flow_Head_New", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_MainItems", "varname" => "firefoxbd_at_localhost__Cash_Flow_MainItems", "altvarname" => "Cash_Flow_MainItems", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "corvoproject_audit", "varname" => "firefoxbd_at_localhost__corvoproject_audit", "altvarname" => "corvoproject_audit", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "corvoproject_ugrights", "varname" => "firefoxbd_at_localhost__corvoproject_ugrights", "altvarname" => "corvoproject_ugrights", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Exp_Inv_Main", "varname" => "firefoxbd_at_localhost__Exp_Inv_Main", "altvarname" => "Exp_Inv_Main", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Cost_Category", "varname" => "firefoxbd_at_localhost__Export_Cost_Category", "altvarname" => "Export_Cost_Category", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Cost_Head", "varname" => "firefoxbd_at_localhost__Export_Cost_Head", "altvarname" => "Export_Cost_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Cost_Item", "varname" => "firefoxbd_at_localhost__Export_Cost_Item", "altvarname" => "Export_Cost_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Cost_Payment_Head", "varname" => "firefoxbd_at_localhost__Export_Cost_Payment_Head", "altvarname" => "Export_Cost_Payment_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Cost_Payment_Item", "varname" => "firefoxbd_at_localhost__Export_Cost_Payment_Item", "altvarname" => "Export_Cost_Payment_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Export_Heading", "varname" => "firefoxbd_at_localhost__Export_Heading", "altvarname" => "Export_Heading", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_uggroups", "varname" => "firefoxbd_at_localhost__ffxbderp_uggroups", "altvarname" => "ffxbderp_uggroups", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_ugmembers", "varname" => "firefoxbd_at_localhost__ffxbderp_ugmembers", "altvarname" => "ffxbderp_ugmembers", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_ugrights", "varname" => "firefoxbd_at_localhost__ffxbderp_ugrights", "altvarname" => "ffxbderp_ugrights", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Forwaders", "varname" => "firefoxbd_at_localhost__Forwaders", "altvarname" => "Forwaders", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Forwaders_Local", "varname" => "firefoxbd_at_localhost__Forwaders_Local", "altvarname" => "Forwaders_Local", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Cost_Category", "varname" => "firefoxbd_at_localhost__Import_Cost_Category", "altvarname" => "Import_Cost_Category", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Cost_Head", "varname" => "firefoxbd_at_localhost__Import_Cost_Head", "altvarname" => "Import_Cost_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Cost_Item", "varname" => "firefoxbd_at_localhost__Import_Cost_Item", "altvarname" => "Import_Cost_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Cost_Payment_Head", "varname" => "firefoxbd_at_localhost__Import_Cost_Payment_Head", "altvarname" => "Import_Cost_Payment_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Cost_Payment_Item", "varname" => "firefoxbd_at_localhost__Import_Cost_Payment_Item", "altvarname" => "Import_Cost_Payment_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Heading", "varname" => "firefoxbd_at_localhost__Import_Heading", "altvarname" => "Import_Heading", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Import_Suppliers", "varname" => "firefoxbd_at_localhost__Import_Suppliers", "altvarname" => "Import_Suppliers", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Request_Imp_Permit_Head", "varname" => "firefoxbd_at_localhost__Request_Imp_Permit_Head", "altvarname" => "Request_Imp_Permit_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Budget_Head", "varname" => "firefoxbd_at_localhost__Utility_Budget_Head", "altvarname" => "Utility_Budget_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Budget_Item", "varname" => "firefoxbd_at_localhost__Utility_Budget_Item", "altvarname" => "Utility_Budget_Item", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Category", "varname" => "firefoxbd_at_localhost__Utility_Category", "altvarname" => "Utility_Category", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Head", "varname" => "firefoxbd_at_localhost__Utility_Head", "altvarname" => "Utility_Head", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Sub", "varname" => "firefoxbd_at_localhost__Utility_Sub", "altvarname" => "Utility_Sub", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_SubCategory", "varname" => "firefoxbd_at_localhost__Utility_SubCategory", "altvarname" => "Utility_SubCategory", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "webusers", "varname" => "firefoxbd_at_localhost__webusers", "altvarname" => "webusers", "connId" => "firefoxbd_at_localhost", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( $schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection(\''. $tbl["connId"] .'\');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>