<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("webusers");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblfirefoxbd_at_103_6_168_141__Acc_DrCr_Base;
	var $tblfirefoxbd_at_103_6_168_141__Acc_DrCr_Credit_Head;
	var $tblfirefoxbd_at_103_6_168_141__Acc_DrCr_Credit_Item;
	var $tblfirefoxbd_at_103_6_168_141__Acc_DrCr_Debit_Head;
	var $tblfirefoxbd_at_103_6_168_141__Acc_DrCr_Debit_Item;
	var $tblfirefoxbd_at_103_6_168_141__Agent_Master;
	var $tblfirefoxbd_at_103_6_168_141__BD_audit;
	var $tblfirefoxbd_at_103_6_168_141__BD_Reimbursement;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_Banks;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_CashInHand;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_CashInHand_Item;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_IncomeOthers;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_Loan;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_OthersExpence;
	var $tblfirefoxbd_at_103_6_168_141__Cash_Flow_Payments_Expences;
	var $tblfirefoxbd_at_103_6_168_141__Combine_FTY_Supplier;
	var $tblfirefoxbd_at_103_6_168_141__Currency;
	var $tblfirefoxbd_at_103_6_168_141__Customer;
	var $tblfirefoxbd_at_103_6_168_141__Factory;
	var $tblfirefoxbd_at_103_6_168_141__ffxbderp_uggroups;
	var $tblfirefoxbd_at_103_6_168_141__ffxbderp_ugmembers;
	var $tblfirefoxbd_at_103_6_168_141__ffxbderp_ugrights;
	var $tblfirefoxbd_at_103_6_168_141__Freight_IBWS;
	var $tblfirefoxbd_at_103_6_168_141__IBWS_Bcharge;
	var $tblfirefoxbd_at_103_6_168_141__IBWS_Inv_SCwise;
	var $tblfirefoxbd_at_103_6_168_141__IBWS_Inv_SCwisespttl;
	var $tblfirefoxbd_at_103_6_168_141__IBWS_Payment_Main;
	var $tblfirefoxbd_at_103_6_168_141__Merchandiser;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_B_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_F_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_Paint_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_R_Head;
	var $tblfirefoxbd_at_103_6_168_141__Po_Bulk_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Bulk_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Bulk_Pay;
	var $tblfirefoxbd_at_103_6_168_141__Po_Cap_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Cap_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Cap_Pay;
	var $tblfirefoxbd_at_103_6_168_141__Po_Con_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Con_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Con_Pay;
	var $tblfirefoxbd_at_103_6_168_141__Po_Fixed_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Fixed_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Fixed_Pay;
	var $tblfirefoxbd_at_103_6_168_141__Po_Paint_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Paint_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Paint_Pay;
	var $tblfirefoxbd_at_103_6_168_141__Po_Rc_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Rc_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Rc_Pay;
	var $tblfirefoxbd_at_103_6_168_141__Po_Rep_Bankcharge;
	var $tblfirefoxbd_at_103_6_168_141__Po_Repl_Freight;
	var $tblfirefoxbd_at_103_6_168_141__Po_Repl_Pay;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_B_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_B_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_B_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_F_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_F_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_F_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_Paint_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_Paint_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_Paint_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_R_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_R_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_R_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_Rc_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_Rc_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_Rc_Main;
	var $tblfirefoxbd_at_103_6_168_141__Supplier;
	var $tblfirefoxbd_at_103_6_168_141__Title;
	var $tblfirefoxbd_at_103_6_168_141__Utility_Budget_Head_TW;
	var $tblfirefoxbd_at_103_6_168_141__Utility_Budget_Item_TW;
	var $tblfirefoxbd_at_103_6_168_141__Utility_Category;
	var $tblfirefoxbd_at_103_6_168_141__Utility_Category_TW;
	var $tblfirefoxbd_at_103_6_168_141__Utility_Head_TW;
	var $tblfirefoxbd_at_103_6_168_141__Utility_SubCategory;
	var $tblfirefoxbd_at_103_6_168_141__Utility_SubCategory_TW;
	var $tblfirefoxbd_at_103_6_168_141__webusers;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "Acc_DrCr_Base", "varname" => "firefoxbd_at_103_6_168_141__Acc_DrCr_Base", "altvarname" => "Acc_DrCr_Base", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Acc_DrCr_Credit_Head", "varname" => "firefoxbd_at_103_6_168_141__Acc_DrCr_Credit_Head", "altvarname" => "Acc_DrCr_Credit_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Acc_DrCr_Credit_Item", "varname" => "firefoxbd_at_103_6_168_141__Acc_DrCr_Credit_Item", "altvarname" => "Acc_DrCr_Credit_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Acc_DrCr_Debit_Head", "varname" => "firefoxbd_at_103_6_168_141__Acc_DrCr_Debit_Head", "altvarname" => "Acc_DrCr_Debit_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Acc_DrCr_Debit_Item", "varname" => "firefoxbd_at_103_6_168_141__Acc_DrCr_Debit_Item", "altvarname" => "Acc_DrCr_Debit_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Agent_Master", "varname" => "firefoxbd_at_103_6_168_141__Agent_Master", "altvarname" => "Agent_Master", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "BD_audit", "varname" => "firefoxbd_at_103_6_168_141__BD_audit", "altvarname" => "BD_audit", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "BD_Reimbursement", "varname" => "firefoxbd_at_103_6_168_141__BD_Reimbursement", "altvarname" => "BD_Reimbursement", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_Banks", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_Banks", "altvarname" => "Cash_Flow_Banks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_CashInHand", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_CashInHand", "altvarname" => "Cash_Flow_CashInHand", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_CashInHand_Item", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_CashInHand_Item", "altvarname" => "Cash_Flow_CashInHand_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_IncomeOthers", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_IncomeOthers", "altvarname" => "Cash_Flow_IncomeOthers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_Loan", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_Loan", "altvarname" => "Cash_Flow_Loan", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_OthersExpence", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_OthersExpence", "altvarname" => "Cash_Flow_OthersExpence", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cash_Flow_Payments_Expences", "varname" => "firefoxbd_at_103_6_168_141__Cash_Flow_Payments_Expences", "altvarname" => "Cash_Flow_Payments_Expences", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Combine_FTY_Supplier", "varname" => "firefoxbd_at_103_6_168_141__Combine_FTY_Supplier", "altvarname" => "Combine_FTY_Supplier", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Currency", "varname" => "firefoxbd_at_103_6_168_141__Currency", "altvarname" => "Currency", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer", "varname" => "firefoxbd_at_103_6_168_141__Customer", "altvarname" => "Customer", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Factory", "varname" => "firefoxbd_at_103_6_168_141__Factory", "altvarname" => "Factory", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_uggroups", "varname" => "firefoxbd_at_103_6_168_141__ffxbderp_uggroups", "altvarname" => "ffxbderp_uggroups", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_ugmembers", "varname" => "firefoxbd_at_103_6_168_141__ffxbderp_ugmembers", "altvarname" => "ffxbderp_ugmembers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "ffxbderp_ugrights", "varname" => "firefoxbd_at_103_6_168_141__ffxbderp_ugrights", "altvarname" => "ffxbderp_ugrights", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Freight_IBWS", "varname" => "firefoxbd_at_103_6_168_141__Freight_IBWS", "altvarname" => "Freight_IBWS", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "IBWS_Bcharge", "varname" => "firefoxbd_at_103_6_168_141__IBWS_Bcharge", "altvarname" => "IBWS_Bcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "IBWS_Inv_SCwise", "varname" => "firefoxbd_at_103_6_168_141__IBWS_Inv_SCwise", "altvarname" => "IBWS_Inv_SCwise", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "IBWS_Inv_SCwisespttl", "varname" => "firefoxbd_at_103_6_168_141__IBWS_Inv_SCwisespttl", "altvarname" => "IBWS_Inv_SCwisespttl", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "IBWS_Payment_Main", "varname" => "firefoxbd_at_103_6_168_141__IBWS_Payment_Main", "altvarname" => "IBWS_Payment_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Merchandiser", "varname" => "firefoxbd_at_103_6_168_141__Merchandiser", "altvarname" => "Merchandiser", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_A_Head", "altvarname" => "PI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PI_Imp_B_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_B_Head", "altvarname" => "PI_Imp_B_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PI_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_C_Head", "altvarname" => "PI_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PI_Imp_F_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_F_Head", "altvarname" => "PI_Imp_F_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PI_Imp_Paint_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_Paint_Head", "altvarname" => "PI_Imp_Paint_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PI_Imp_R_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_R_Head", "altvarname" => "PI_Imp_R_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Bulk_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Bulk_Bankcharge", "altvarname" => "Po_Bulk_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Bulk_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Bulk_Freight", "altvarname" => "Po_Bulk_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Bulk_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Bulk_Pay", "altvarname" => "Po_Bulk_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Cap_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Cap_Bankcharge", "altvarname" => "Po_Cap_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Cap_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Cap_Freight", "altvarname" => "Po_Cap_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Cap_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Cap_Pay", "altvarname" => "Po_Cap_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Con_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Con_Bankcharge", "altvarname" => "Po_Con_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Con_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Con_Freight", "altvarname" => "Po_Con_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Con_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Con_Pay", "altvarname" => "Po_Con_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Fixed_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Fixed_Bankcharge", "altvarname" => "Po_Fixed_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Fixed_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Fixed_Freight", "altvarname" => "Po_Fixed_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Fixed_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Fixed_Pay", "altvarname" => "Po_Fixed_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Paint_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Paint_Bankcharge", "altvarname" => "Po_Paint_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Paint_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Paint_Freight", "altvarname" => "Po_Paint_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Paint_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Paint_Pay", "altvarname" => "Po_Paint_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Rc_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Rc_Bankcharge", "altvarname" => "Po_Rc_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Rc_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Rc_Freight", "altvarname" => "Po_Rc_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Rc_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Rc_Pay", "altvarname" => "Po_Rc_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Rep_Bankcharge", "varname" => "firefoxbd_at_103_6_168_141__Po_Rep_Bankcharge", "altvarname" => "Po_Rep_Bankcharge", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Repl_Freight", "varname" => "firefoxbd_at_103_6_168_141__Po_Repl_Freight", "altvarname" => "Po_Repl_Freight", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Po_Repl_Pay", "varname" => "firefoxbd_at_103_6_168_141__Po_Repl_Pay", "altvarname" => "Po_Repl_Pay", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Head", "altvarname" => "PSI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Item", "altvarname" => "PSI_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Main", "altvarname" => "PSI_Imp_A_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_B_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_B_Head", "altvarname" => "PSI_Imp_B_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_B_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_B_Item", "altvarname" => "PSI_Imp_B_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_B_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_B_Main", "altvarname" => "PSI_Imp_B_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Head", "altvarname" => "PSI_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Item", "altvarname" => "PSI_Imp_C_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Main", "altvarname" => "PSI_Imp_C_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_F_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_F_Head", "altvarname" => "PSI_Imp_F_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_F_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_F_Item", "altvarname" => "PSI_Imp_F_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_F_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_F_Main", "altvarname" => "PSI_Imp_F_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_Paint_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_Paint_Head", "altvarname" => "PSI_Imp_Paint_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_Paint_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_Paint_Item", "altvarname" => "PSI_Imp_Paint_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_Paint_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_Paint_Main", "altvarname" => "PSI_Imp_Paint_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_R_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_R_Head", "altvarname" => "PSI_Imp_R_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_R_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_R_Item", "altvarname" => "PSI_Imp_R_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_R_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_R_Main", "altvarname" => "PSI_Imp_R_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_Rc_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_Rc_Head", "altvarname" => "PSI_Imp_Rc_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_Rc_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_Rc_Item", "altvarname" => "PSI_Imp_Rc_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "PSI_Imp_Rc_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_Rc_Main", "altvarname" => "PSI_Imp_Rc_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Supplier", "varname" => "firefoxbd_at_103_6_168_141__Supplier", "altvarname" => "Supplier", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Title", "varname" => "firefoxbd_at_103_6_168_141__Title", "altvarname" => "Title", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Budget_Head_TW", "varname" => "firefoxbd_at_103_6_168_141__Utility_Budget_Head_TW", "altvarname" => "Utility_Budget_Head_TW", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Budget_Item_TW", "varname" => "firefoxbd_at_103_6_168_141__Utility_Budget_Item_TW", "altvarname" => "Utility_Budget_Item_TW", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Category", "varname" => "firefoxbd_at_103_6_168_141__Utility_Category", "altvarname" => "Utility_Category", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Category_TW", "varname" => "firefoxbd_at_103_6_168_141__Utility_Category_TW", "altvarname" => "Utility_Category_TW", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_Head_TW", "varname" => "firefoxbd_at_103_6_168_141__Utility_Head_TW", "altvarname" => "Utility_Head_TW", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_SubCategory", "varname" => "firefoxbd_at_103_6_168_141__Utility_SubCategory", "altvarname" => "Utility_SubCategory", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Utility_SubCategory_TW", "varname" => "firefoxbd_at_103_6_168_141__Utility_SubCategory_TW", "altvarname" => "Utility_SubCategory_TW", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "webusers", "varname" => "firefoxbd_at_103_6_168_141__webusers", "altvarname" => "webusers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( $schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection(\''. $tbl["connId"] .'\');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>