<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("Customer_Login");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblfirefoxbd_at_103_6_168_141__BD_audit;
	var $tblfirefoxbd_at_103_6_168_141__BD_Model;
	var $tblfirefoxbd_at_103_6_168_141__Currency;
	var $tblfirefoxbd_at_103_6_168_141__Cus_Ref_Cmt_Head;
	var $tblfirefoxbd_at_103_6_168_141__Cus_Ref_Cmt_Item;
	var $tblfirefoxbd_at_103_6_168_141__Cust_Comment_View;
	var $tblfirefoxbd_at_103_6_168_141__Customer;
	var $tblfirefoxbd_at_103_6_168_141__Customer_Create_SC;
	var $tblfirefoxbd_at_103_6_168_141__Customer_Create_SC_Item;
	var $tblfirefoxbd_at_103_6_168_141__Customer_Create_SC_Rmks;
	var $tblfirefoxbd_at_103_6_168_141__Customer_Login;
	var $tblfirefoxbd_at_103_6_168_141__Destinations;
	var $tblfirefoxbd_at_103_6_168_141__Ex_Rate;
	var $tblfirefoxbd_at_103_6_168_141__Exp_Inv_Cont;
	var $tblfirefoxbd_at_103_6_168_141__Exp_Inv_Main;
	var $tblfirefoxbd_at_103_6_168_141__Fright;
	var $tblfirefoxbd_at_103_6_168_141__Gatepass_Head;
	var $tblfirefoxbd_at_103_6_168_141__Invoice_Head;
	var $tblfirefoxbd_at_103_6_168_141__Invoice_item;
	var $tblfirefoxbd_at_103_6_168_141__Item_Unit;
	var $tblfirefoxbd_at_103_6_168_141__Loading_Ports;
	var $tblfirefoxbd_at_103_6_168_141__Maker;
	var $tblfirefoxbd_at_103_6_168_141__Offer_Head;
	var $tblfirefoxbd_at_103_6_168_141__Packing;
	var $tblfirefoxbd_at_103_6_168_141__Payterms_new;
	var $tblfirefoxbd_at_103_6_168_141__Pc_Terms;
	var $tblfirefoxbd_at_103_6_168_141__Ref_Spec_amend;
	var $tblfirefoxbd_at_103_6_168_141__Sc_Head;
	var $tblfirefoxbd_at_103_6_168_141__SC_Item;
	var $tblfirefoxbd_at_103_6_168_141__SHP_Adv_Data;
	var $tblfirefoxbd_at_103_6_168_141__SHP_Adv_Head;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Amendments;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Amendments_Item;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Group;
	var $tblfirefoxbd_at_103_6_168_141__Spec_History;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Item_Color;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Kids_Head;
	var $tblfirefoxbd_at_103_6_168_141__Spec_Type;
	var $tblfirefoxbd_at_103_6_168_141__Spec_withmodel;
	var $tblfirefoxbd_at_103_6_168_141__Specrevision;
	var $tblfirefoxbd_at_103_6_168_141__Upload_Export;
	var $tblfirefoxbd_at_103_6_168_141__Upload_PPsample;
	var $tblfirefoxbd_at_103_6_168_141__Upload_QC;
	var $tblfirefoxbd_at_103_6_168_141__Upload_Sc_Att;
	var $tblfirefoxbd_at_103_6_168_141__Upload_Spec_Comp;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "BD_audit", "varname" => "firefoxbd_at_103_6_168_141__BD_audit", "altvarname" => "BD_audit", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "BD_Model", "varname" => "firefoxbd_at_103_6_168_141__BD_Model", "altvarname" => "BD_Model", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Currency", "varname" => "firefoxbd_at_103_6_168_141__Currency", "altvarname" => "Currency", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cus_Ref_Cmt_Head", "varname" => "firefoxbd_at_103_6_168_141__Cus_Ref_Cmt_Head", "altvarname" => "Cus_Ref_Cmt_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cus_Ref_Cmt_Item", "varname" => "firefoxbd_at_103_6_168_141__Cus_Ref_Cmt_Item", "altvarname" => "Cus_Ref_Cmt_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Cust_Comment_View", "varname" => "firefoxbd_at_103_6_168_141__Cust_Comment_View", "altvarname" => "Cust_Comment_View", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer", "varname" => "firefoxbd_at_103_6_168_141__Customer", "altvarname" => "Customer", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer_Create_SC", "varname" => "firefoxbd_at_103_6_168_141__Customer_Create_SC", "altvarname" => "Customer_Create_SC", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer_Create_SC_Item", "varname" => "firefoxbd_at_103_6_168_141__Customer_Create_SC_Item", "altvarname" => "Customer_Create_SC_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer_Create_SC_Rmks", "varname" => "firefoxbd_at_103_6_168_141__Customer_Create_SC_Rmks", "altvarname" => "Customer_Create_SC_Rmks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Customer_Login", "varname" => "firefoxbd_at_103_6_168_141__Customer_Login", "altvarname" => "Customer_Login", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Destinations", "varname" => "firefoxbd_at_103_6_168_141__Destinations", "altvarname" => "Destinations", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Ex_Rate", "varname" => "firefoxbd_at_103_6_168_141__Ex_Rate", "altvarname" => "Ex_Rate", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Exp_Inv_Cont", "varname" => "firefoxbd_at_103_6_168_141__Exp_Inv_Cont", "altvarname" => "Exp_Inv_Cont", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Exp_Inv_Main", "varname" => "firefoxbd_at_103_6_168_141__Exp_Inv_Main", "altvarname" => "Exp_Inv_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Fright", "varname" => "firefoxbd_at_103_6_168_141__Fright", "altvarname" => "Fright", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Gatepass_Head", "varname" => "firefoxbd_at_103_6_168_141__Gatepass_Head", "altvarname" => "Gatepass_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_Head", "varname" => "firefoxbd_at_103_6_168_141__Invoice_Head", "altvarname" => "Invoice_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Invoice_item", "varname" => "firefoxbd_at_103_6_168_141__Invoice_item", "altvarname" => "Invoice_item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Item_Unit", "varname" => "firefoxbd_at_103_6_168_141__Item_Unit", "altvarname" => "Item_Unit", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Loading_Ports", "varname" => "firefoxbd_at_103_6_168_141__Loading_Ports", "altvarname" => "Loading_Ports", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Maker", "varname" => "firefoxbd_at_103_6_168_141__Maker", "altvarname" => "Maker", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Offer_Head", "varname" => "firefoxbd_at_103_6_168_141__Offer_Head", "altvarname" => "Offer_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Packing", "varname" => "firefoxbd_at_103_6_168_141__Packing", "altvarname" => "Packing", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Payterms_new", "varname" => "firefoxbd_at_103_6_168_141__Payterms_new", "altvarname" => "Payterms_new", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Pc_Terms", "varname" => "firefoxbd_at_103_6_168_141__Pc_Terms", "altvarname" => "Pc_Terms", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Ref_Spec_amend", "varname" => "firefoxbd_at_103_6_168_141__Ref_Spec_amend", "altvarname" => "Ref_Spec_amend", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Sc_Head", "varname" => "firefoxbd_at_103_6_168_141__Sc_Head", "altvarname" => "Sc_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "SC_Item", "varname" => "firefoxbd_at_103_6_168_141__SC_Item", "altvarname" => "SC_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "SHP_Adv_Data", "varname" => "firefoxbd_at_103_6_168_141__SHP_Adv_Data", "altvarname" => "SHP_Adv_Data", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "SHP_Adv_Head", "varname" => "firefoxbd_at_103_6_168_141__SHP_Adv_Head", "altvarname" => "SHP_Adv_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_Amendments", "varname" => "firefoxbd_at_103_6_168_141__Spec_Amendments", "altvarname" => "Spec_Amendments", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_Amendments_Item", "varname" => "firefoxbd_at_103_6_168_141__Spec_Amendments_Item", "altvarname" => "Spec_Amendments_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_Group", "varname" => "firefoxbd_at_103_6_168_141__Spec_Group", "altvarname" => "Spec_Group", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_History", "varname" => "firefoxbd_at_103_6_168_141__Spec_History", "altvarname" => "Spec_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_Item_Color", "varname" => "firefoxbd_at_103_6_168_141__Spec_Item_Color", "altvarname" => "Spec_Item_Color", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_Kids_Head", "varname" => "firefoxbd_at_103_6_168_141__Spec_Kids_Head", "altvarname" => "Spec_Kids_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_Type", "varname" => "firefoxbd_at_103_6_168_141__Spec_Type", "altvarname" => "Spec_Type", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Spec_withmodel", "varname" => "firefoxbd_at_103_6_168_141__Spec_withmodel", "altvarname" => "Spec_withmodel", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Specrevision", "varname" => "firefoxbd_at_103_6_168_141__Specrevision", "altvarname" => "Specrevision", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Upload_Export", "varname" => "firefoxbd_at_103_6_168_141__Upload_Export", "altvarname" => "Upload_Export", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Upload_PPsample", "varname" => "firefoxbd_at_103_6_168_141__Upload_PPsample", "altvarname" => "Upload_PPsample", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Upload_QC", "varname" => "firefoxbd_at_103_6_168_141__Upload_QC", "altvarname" => "Upload_QC", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Upload_Sc_Att", "varname" => "firefoxbd_at_103_6_168_141__Upload_Sc_Att", "altvarname" => "Upload_Sc_Att", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
		$this->lstTables[] = array("name" => "Upload_Spec_Comp", "varname" => "firefoxbd_at_103_6_168_141__Upload_Spec_Comp", "altvarname" => "Upload_Spec_Comp", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at 103.6.168.141");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( $schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection(\''. $tbl["connId"] .'\');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>