<?php
include_once getabspath("classes/controls/ViewFileField.php");
class ViewFileDownloadField extends ViewFileField
{
	public $sizeUnits = array();
	
	/**
	 * addJSFiles
	 * Add control JS files to page object
	 */
	function __construct($field, $container, $pageobject)
	{
		parent::__construct($field, $container, $pageobject);
		$this->sizeUnits = array("KB", "MB", "GB", "TB");
	}
	
	public function addJSFiles()
	{
		if($this->container->pSet->showThumbnail($this->field)){
			$this->getJSControl();
		}
	}
	
	/**
	 * addCSSFiles
	 * Add control CSS files to page object
	 */ 
	function addCSSFiles()
	{
	}
	
	public function showDBValue( &$data, $keylink, $html = true )
	{
		$value = "";
		$this->upload_handler->tkeys = $keylink;
		$filesArray = $this->getFilesArray($data[$this->field]);
		$showThumbnails = $this->container->pSet->showThumbnail($this->field);
		$isExport = $this->container->pageType == PAGE_EXPORT
			|| $this->container->forExport != ''; 

		foreach ($filesArray as $file)
		{
			$userFile = $this->upload_handler->buildUserFile($file);
			if(!$isExport)
			{
				$value .= ($value != "" ? "<br>" : "");
				if($showThumbnails && $userFile["thumbnail_url"] != "" && CheckImageExtension($file["name"])) 
				{
					$value .= "<a target=_blank href=\"".runner_htmlspecialchars($userFile["url"])."\" ><img  border='0'";
					if($this->is508)
						$value .= " alt=\"".runner_htmlspecialchars($userFile["name"])."\"";
					$value .= " src=\"".runner_htmlspecialchars(GetRootPathForResources($userFile["thumbnail_url"]))."\" /></a>";
				}
				else if($this->container->pSet->showIcon($this->field)) 
				{
					$value .= '<a href="'.runner_htmlspecialchars($userFile["url"])
						.'"><img style="vertical-align: middle;" src="'.GetRootPathForResources('images/icons/'
						.$this->getFileIconByType($file["name"], $file["type"])).'" /></a>';
				}
			}
			
			if($this->container->pSet->showCustomExpr($this->field))
			{
				$value .= fileCustomExpression($file, $data, $this->field, $this->container->pageType);
			}
			else
			{
				if($isExport)
					$value .= ($value != "" ? ", " : "").$file["usrName"];
				else
				{ 
					if($showThumbnails && $userFile["thumbnail_url"] != "" && CheckImageExtension($file["name"]) && $value != "") 
					{
						$value .=  "<br />";
					}
					
					$label = runner_htmlspecialchars($file["usrName"] != "" ? $file["usrName"] : $file["name"]);	
					if($this->searchHighlight)
					{
						$label = $this->highlightSearchWord($label, true, ""); 
					}						
					$value .= '<a dir="LTR" href="'.runner_htmlspecialchars($userFile["url"]).'">'.$label.'</a>';					
				}	
			}
			if($this->container->pSet->showFileSize($this->field))
			{
				$fileSizeAndUnit = $this->getFileSizeAndUnits($file["size"]);
				$value .= " ".str_format_number(round($fileSizeAndUnit["size"], 2))
					." ".$this->sizeUnits[$fileSizeAndUnit["unitIndex"]];
			}
		}

		if($value==""){
			$filename=$data[$this->field];
			$patterns=array();
			$patterns[0]='/%/';
			$patterns[1]='/#/';
			$replacements = array();
			$replacements[0] = '%25';
			$replacements[1] = '%23';
			$filename=preg_replace($patterns, $replacements, $filename);

			$path_partss=pathinfo($filename);
			$file_namess=$path_partss['filename'];

			if((strstr($filename,"-202102")==true && substr($file_namess,-15,6)==202102) || (strstr($filename,"-202103")==true && substr($file_namess,-15,6)==202103) || (strstr($filename,"-202104")==true && substr($file_namess,-15,6)==202104) || (strstr($filename,"-202105")==true && substr($file_namess,-15,6)==202105) || (strstr($filename,"-202106")==true && substr($file_namess,-15,6)==202106) || (strstr($filename,"-202107")==true && substr($file_namess,-15,6)==202107) || (strstr($filename,"-202108")==true && substr($file_namess,-15,6)==202108) || (strstr($filename,"-202109")==true && substr($file_namess,-15,6)==202109) || (strstr($filename,"-202110")==true && substr($file_namess,-15,6)==202110)){
				$path_parts=pathinfo($filename);
				$ext_name=$path_parts['extension'];
				$file_namess=$path_parts['filename'];
				$file_namess=substr($file_namess,0,-16);
				$File_Names=$file_namess.".".$ext_name;
			  	$value .= '<a href="http://103.5.232.38/Uploads/files/2021/'.$File_Names.'"><img style="vertical-align: middle;" src="'.GetRootPathForResources('images/icons/'
					.$this->getFileIconByType(strtolower($data[$this->field]), $file["type"])).'" /></a>';
			   	$value.='<a dir="LTR" href="http://103.5.232.38/Uploads/files/2021/'.$File_Names.'">'.$data[$this->field].'</a>';
			}
			else{
				$value .= '<a href="http://103.5.232.38/Uploads/files/'.$filename.'"><img style="vertical-align: middle;" src="'.GetRootPathForResources('images/icons/'
					.$this->getFileIconByType(strtolower($data[$this->field]), $file["type"])).'" /></a>';
				$value.='<a dir="LTR" href="http://103.5.232.38/Uploads/files/'.$filename.'">'.$data[$this->field].'</a>';
			}
		}

		return $value;
	}
	
	public function getFileSizeAndUnits($size, $deepLevel = 0)
	{
		$shrinkedSize = $size / 1024;
		if($shrinkedSize > 1024 && $deepLevel < count($this->sizeUnits) - 1)
			return $this->getFileSizeAndUnits($shrinkedSize, $deepLevel + 1);
		return array("size" => $shrinkedSize, "unitIndex" => $deepLevel);
	}
	
	public function getFileIconByType($file_name, $fileType)
	{
		$fileName = "no_image.gif";
		if($fileType == "")
		{
			$fileType = getContentTypeByExtension(substr($file_name, strrpos($file_name, '.')));
		}
		
		return getIconByFileType($fileType, $file_name);
	}
}
?>