<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["sc_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["sc_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["sc_head.Cst_ID"]["edit"] = array("table" => "Sc_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["sc_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["sc_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["sc_head.Destination"]["edit"] = array("table" => "Sc_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["ref_cus_bdbk.Customer_Ref"] )) {
			$lookupTableLinks["Customer"]["ref_cus_bdbk.Customer_Ref"] = array();
		}
		$lookupTableLinks["Customer"]["ref_cus_bdbk.Customer_Ref"]["edit"] = array("table" => "Ref_Cus_BDBK", "field" => "Customer_Ref", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["shipping_head_contlist.From"] )) {
			$lookupTableLinks["Destinations"]["shipping_head_contlist.From"] = array();
		}
		$lookupTableLinks["Destinations"]["shipping_head_contlist.From"]["edit"] = array("table" => "Shipping_Head_Contlist", "field" => "From", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["shipping_head_contlist.PayTerms"] )) {
			$lookupTableLinks["Payterms_new"]["shipping_head_contlist.PayTerms"] = array();
		}
		$lookupTableLinks["Payterms_new"]["shipping_head_contlist.PayTerms"]["edit"] = array("table" => "Shipping_Head_Contlist", "field" => "PayTerms", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["offer_head.Cust"] )) {
			$lookupTableLinks["Customer"]["offer_head.Cust"] = array();
		}
		$lookupTableLinks["Customer"]["offer_head.Cust"]["edit"] = array("table" => "Offer_Head", "field" => "Cust", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["offer_head.Payment"] )) {
			$lookupTableLinks["Payterms_new"]["offer_head.Payment"] = array();
		}
		$lookupTableLinks["Payterms_new"]["offer_head.Payment"]["edit"] = array("table" => "Offer_Head", "field" => "Payment", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["ref_cust_scmodel.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["ref_cust_scmodel.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["ref_cust_scmodel.Cst_ID"]["edit"] = array("table" => "Ref_Cust_SCmodel", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["invoice_head.for_account"] )) {
			$lookupTableLinks["Customer"]["invoice_head.for_account"] = array();
		}
		$lookupTableLinks["Customer"]["invoice_head.for_account"]["edit"] = array("table" => "Invoice_Head", "field" => "for_account", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["spec_kids_head.Model"] )) {
			$lookupTableLinks["BD_Model"]["spec_kids_head.Model"] = array();
		}
		$lookupTableLinks["BD_Model"]["spec_kids_head.Model"]["edit"] = array("table" => "Spec_Kids_Head", "field" => "Model", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Type"] ) ) {
			$lookupTableLinks["Spec_Type"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Type"]["spec_kids_head.Spec_type"] )) {
			$lookupTableLinks["Spec_Type"]["spec_kids_head.Spec_type"] = array();
		}
		$lookupTableLinks["Spec_Type"]["spec_kids_head.Spec_type"]["edit"] = array("table" => "Spec_Kids_Head", "field" => "Spec_type", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["spec_kids_head.Cus_ID"] )) {
			$lookupTableLinks["Customer"]["spec_kids_head.Cus_ID"] = array();
		}
		$lookupTableLinks["Customer"]["spec_kids_head.Cus_ID"]["edit"] = array("table" => "Spec_Kids_Head", "field" => "Cus_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_ITLinv"] ) ) {
			$lookupTableLinks["Ref_ITLinv"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_ITLinv"]["cus_ref_cmt_head.Model_Name"] )) {
			$lookupTableLinks["Ref_ITLinv"]["cus_ref_cmt_head.Model_Name"] = array();
		}
		$lookupTableLinks["Ref_ITLinv"]["cus_ref_cmt_head.Model_Name"]["edit"] = array("table" => "Cus_Ref_Cmt_Head", "field" => "Model_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_ITLinv"] ) ) {
			$lookupTableLinks["Ref_ITLinv"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_ITLinv"]["cus_ref_cmt_head.Model_No1"] )) {
			$lookupTableLinks["Ref_ITLinv"]["cus_ref_cmt_head.Model_No1"] = array();
		}
		$lookupTableLinks["Ref_ITLinv"]["cus_ref_cmt_head.Model_No1"]["edit"] = array("table" => "Cus_Ref_Cmt_Head", "field" => "Model_No1", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["upload_sc_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["upload_sc_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["upload_sc_head.Cst_ID"]["edit"] = array("table" => "Upload_SC_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["upload_ppsample_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["upload_ppsample_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["upload_ppsample_head.Cst_ID"]["edit"] = array("table" => "Upload_PPsample_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["upload_qc_head.Cst_ID"] )) {
			$lookupTableLinks["Customer"]["upload_qc_head.Cst_ID"] = array();
		}
		$lookupTableLinks["Customer"]["upload_qc_head.Cst_ID"]["edit"] = array("table" => "Upload_QC_Head", "field" => "Cst_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["customer_create_sc.Shpg_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["customer_create_sc.Shpg_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["customer_create_sc.Shpg_Term"]["edit"] = array("table" => "Customer_Create_SC", "field" => "Shpg_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["customer_create_sc.Destination"] )) {
			$lookupTableLinks["Destinations"]["customer_create_sc.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["customer_create_sc.Destination"]["edit"] = array("table" => "Customer_Create_SC", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["customer_create_sc.Fright"] )) {
			$lookupTableLinks["Fright"]["customer_create_sc.Fright"] = array();
		}
		$lookupTableLinks["Fright"]["customer_create_sc.Fright"]["edit"] = array("table" => "Customer_Create_SC", "field" => "Fright", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["customer_create_sc.Currency"] )) {
			$lookupTableLinks["Currency"]["customer_create_sc.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["customer_create_sc.Currency"]["edit"] = array("table" => "Customer_Create_SC", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["customer_create_sc.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["customer_create_sc.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["customer_create_sc.Port"]["edit"] = array("table" => "Customer_Create_SC", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Offer_Head"] ) ) {
			$lookupTableLinks["Offer_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Offer_Head"]["customer_create_sc.Offer_No"] )) {
			$lookupTableLinks["Offer_Head"]["customer_create_sc.Offer_No"] = array();
		}
		$lookupTableLinks["Offer_Head"]["customer_create_sc.Offer_No"]["edit"] = array("table" => "Customer_Create_SC", "field" => "Offer_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Item_Color"] ) ) {
			$lookupTableLinks["Spec_Item_Color"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.Color"] )) {
			$lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.Color"] = array();
		}
		$lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.Color"]["edit"] = array("table" => "Customer_Create_SC_Item", "field" => "Color", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Item_Color"] ) ) {
			$lookupTableLinks["Spec_Item_Color"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.FrameColour"] )) {
			$lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.FrameColour"] = array();
		}
		$lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.FrameColour"]["edit"] = array("table" => "Customer_Create_SC_Item", "field" => "FrameColour", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Item_Color"] ) ) {
			$lookupTableLinks["Spec_Item_Color"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.ForkColour"] )) {
			$lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.ForkColour"] = array();
		}
		$lookupTableLinks["Spec_Item_Color"]["customer_create_sc_item.ForkColour"]["edit"] = array("table" => "Customer_Create_SC_Item", "field" => "ForkColour", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["customer_create_sc_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["customer_create_sc_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["customer_create_sc_item.Unit"]["edit"] = array("table" => "Customer_Create_SC_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Packing"] ) ) {
			$lookupTableLinks["Packing"] = array();
		}
		if( !isset( $lookupTableLinks["Packing"]["customer_create_sc_item.Packing"] )) {
			$lookupTableLinks["Packing"]["customer_create_sc_item.Packing"] = array();
		}
		$lookupTableLinks["Packing"]["customer_create_sc_item.Packing"]["edit"] = array("table" => "Customer_Create_SC_Item", "field" => "Packing", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["customer_create_sc_item.Model_BDBK"] )) {
			$lookupTableLinks["BD_Model"]["customer_create_sc_item.Model_BDBK"] = array();
		}
		$lookupTableLinks["BD_Model"]["customer_create_sc_item.Model_BDBK"]["edit"] = array("table" => "Customer_Create_SC_Item", "field" => "Model_BDBK", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_withmodel"] ) ) {
			$lookupTableLinks["Spec_withmodel"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_withmodel"]["spec_amendments.Model_No"] )) {
			$lookupTableLinks["Spec_withmodel"]["spec_amendments.Model_No"] = array();
		}
		$lookupTableLinks["Spec_withmodel"]["spec_amendments.Model_No"]["edit"] = array("table" => "Spec_Amendments", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Specrevision"] ) ) {
			$lookupTableLinks["Specrevision"] = array();
		}
		if( !isset( $lookupTableLinks["Specrevision"]["spec_amendments.Spec_No"] )) {
			$lookupTableLinks["Specrevision"]["spec_amendments.Spec_No"] = array();
		}
		$lookupTableLinks["Specrevision"]["spec_amendments.Spec_No"]["edit"] = array("table" => "Spec_Amendments", "field" => "Spec_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Item_Color"] ) ) {
			$lookupTableLinks["Spec_Item_Color"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Item_Color"]["spec_amendments_item.Color_New"] )) {
			$lookupTableLinks["Spec_Item_Color"]["spec_amendments_item.Color_New"] = array();
		}
		$lookupTableLinks["Spec_Item_Color"]["spec_amendments_item.Color_New"]["edit"] = array("table" => "Spec_Amendments_Item", "field" => "Color_New", "page" => "edit");
		if( !isset( $lookupTableLinks["Maker"] ) ) {
			$lookupTableLinks["Maker"] = array();
		}
		if( !isset( $lookupTableLinks["Maker"]["spec_amendments_item.Maker_New"] )) {
			$lookupTableLinks["Maker"]["spec_amendments_item.Maker_New"] = array();
		}
		$lookupTableLinks["Maker"]["spec_amendments_item.Maker_New"]["edit"] = array("table" => "Spec_Amendments_Item", "field" => "Maker_New", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Spec_amend"] ) ) {
			$lookupTableLinks["Ref_Spec_amend"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Spec_amend"]["spec_amendments_item.Model_new"] )) {
			$lookupTableLinks["Ref_Spec_amend"]["spec_amendments_item.Model_new"] = array();
		}
		$lookupTableLinks["Ref_Spec_amend"]["spec_amendments_item.Model_new"]["edit"] = array("table" => "Spec_Amendments_Item", "field" => "Model_new", "page" => "edit");
}

?>