<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

require_once("include/dbcommon.php");
header("Expires: Thu, 01 Jan 1970 00:00:01 GMT"); 


if(!isLogged())
{ 
	return;
}
if(!IsAdmin())
{
	return;
}
$nonAdminTablesArr = array();
$nonAdminTablesArr[] = "0_China_Customer";
$nonAdminTablesArr[] = "FGS_History";
$nonAdminTablesArr[] = "ST_History";
$nonAdminTablesArr[] = "ST_History_C_FOB";
$nonAdminTablesArr[] = "ST_History_Cap_FOB";
$nonAdminTablesArr[] = "ST_History_ExtraFrm";
$nonAdminTablesArr[] = "ST_History_FOB";
$nonAdminTablesArr[] = "ST_History_FOB1";
$nonAdminTablesArr[] = "ST_History_FOB_Block";
$nonAdminTablesArr[] = "ST_History_FOB_Tube";
$nonAdminTablesArr[] = "ST_History_F_FOB";
$nonAdminTablesArr[] = "ST_History_IBWS_FOB";
$nonAdminTablesArr[] = "ST_History_Paint_FOB";
$nonAdminTablesArr[] = "ST_History_Remain";
$nonAdminTablesArr[] = "ST_History_Rim";
$nonAdminTablesArr[] = "Spec_History";
$nonAdminTablesArr[] = "Sub_ST_History";
$nonAdminTablesArr[] = "TRI_FGS_History";
$nonAdminTablesArr[] = "TRI_Frame_Drawing_Spec_History";
$nonAdminTablesArr[] = "TRI_ST_History";
$nonAdminTablesArr[] = "TRI_ST_History_Repl";
$nonAdminTablesArr[] = "TRI_Sub_ST_History_Tube";
$nonAdminTablesArr[] = "Temp_ST_History_Tube";
$nonAdminTablesArr[] = "webusers";
$nonAdminTablesArr[] = "PSI_Imp_C_Head";
$nonAdminTablesArr[] = "PSI_Imp_C_Item";
$nonAdminTablesArr[] = "PSI_Imp_C_Main";
$nonAdminTablesArr[] = "PSI_Imp_C_Remarks";
$nonAdminTablesArr[] = "PSI_Imp_C_plusminus";
$nonAdminTablesArr[] = "TRI_PSI_Imp_C_Head";
$nonAdminTablesArr[] = "TRI_PSI_Imp_C_Item";
$nonAdminTablesArr[] = "TRI_PSI_Imp_C_Main";
$nonAdminTablesArr[] = "TRI_PSI_Imp_C_Remarks";
$nonAdminTablesArr[] = "TRI_PSI_Imp_C_plusminus";
$nonAdminTablesArr[] = "SC_Item";
$nonAdminTablesArr[] = "SC_Tube_Allocation";
$nonAdminTablesArr[] = "Sc_Head";
$nonAdminTablesArr[] = "Sc_Itemnot_Include";
$nonAdminTablesArr[] = "Sc_Reusable";
$nonAdminTablesArr[] = "TRI_SC_Item";
$nonAdminTablesArr[] = "TRI_Sc_Head";
$nonAdminTablesArr[] = "TRI_Sc_Plus_Minus";
$nonAdminTablesArr[] = "TRI_Sc_Remarks";
$nonAdminTablesArr[] = "TRI_Sc_Reusable";
$nonAdminTablesArr[] = "Gsp_Bom_costing";
$nonAdminTablesArr[] = "gsp_analysis";
$nonAdminTablesArr[] = "gsp_analysis_sc_seq";
$nonAdminTablesArr[] = "ST_Item";
$nonAdminTablesArr[] = "ST_Item_Bulk";
$nonAdminTablesArr[] = "ST_Item_Fixed";
$nonAdminTablesArr[] = "TRI_ST_Item";
$nonAdminTablesArr[] = "PO_Imp_A_Head";
$nonAdminTablesArr[] = "PO_Imp_A_Item";
$nonAdminTablesArr[] = "PO_Imp_Ap_Head";
$nonAdminTablesArr[] = "PO_Imp_Ap_Item";
$nonAdminTablesArr[] = "PO_Imp_B_Head";
$nonAdminTablesArr[] = "PO_Imp_B_Item";
$nonAdminTablesArr[] = "PO_Imp_B_Item_Booking_SC";
$nonAdminTablesArr[] = "PO_Imp_C_Head";
$nonAdminTablesArr[] = "PO_Imp_C_Item";
$nonAdminTablesArr[] = "PO_Imp_F_Head";
$nonAdminTablesArr[] = "PO_Imp_F_Head_Paint";
$nonAdminTablesArr[] = "PO_Imp_F_Item";
$nonAdminTablesArr[] = "PO_Imp_F_ItemData";
$nonAdminTablesArr[] = "PO_Imp_F_Item_Paint";
$nonAdminTablesArr[] = "PO_Imp_M_Head";
$nonAdminTablesArr[] = "PO_Imp_M_Item";
$nonAdminTablesArr[] = "PO_Imp_R_Head";
$nonAdminTablesArr[] = "PO_Imp_R_Item";
$nonAdminTablesArr[] = "PO_Imp_Rc_Head";
$nonAdminTablesArr[] = "PO_Imp_Rc_Item";
$nonAdminTablesArr[] = "PO_Imp_Rim_Head";
$nonAdminTablesArr[] = "PO_Imp_Rim_Item";
$nonAdminTablesArr[] = "TRI_PO_Imp_A_Head";
$nonAdminTablesArr[] = "TRI_PO_Imp_A_Item";
$nonAdminTablesArr[] = "TRI_PO_Imp_B_Head";
$nonAdminTablesArr[] = "TRI_PO_Imp_B_Item";
$nonAdminTablesArr[] = "TRI_PO_Imp_C_Head";
$nonAdminTablesArr[] = "TRI_PO_Imp_C_Item";
$nonAdminTablesArr[] = "TRI_PO_Imp_M_Head";
$nonAdminTablesArr[] = "TRI_PO_Imp_M_Item";
$nonAdminTablesArr[] = "TRI_PO_Imp_R_Head";
$nonAdminTablesArr[] = "TRI_PO_Imp_R_Item";
$nonAdminTablesArr[] = "PSI_Imp_A_Head";
$nonAdminTablesArr[] = "PSI_Imp_A_Item";
$nonAdminTablesArr[] = "PSI_Imp_A_Main";
$nonAdminTablesArr[] = "PI_Imp_A_Head";
$nonAdminTablesArr[] = "PI_Imp_A_Item";
$nonAdminTablesArr[] = "TRI_PI_Imp_A_Head";
$nonAdminTablesArr[] = "TRI_PI_Imp_A_Item";
$nonAdminTablesArr[] = "TRI_PSI_Imp_A_Head";
$nonAdminTablesArr[] = "TRI_PSI_Imp_A_Item";
$nonAdminTablesArr[] = "TRI_PSI_Imp_A_Main";

$ug_connection = $cman->getForUserGroups();

$cbxNames = array('add' => array('mask' => 'A', 'rightName' => 'add')
	, 'edt' => array('mask' => 'E', 'rightName' => 'edit')
	, 'del' => array('mask' => 'D', 'rightName' => 'delete')
	, 'lst' => array('mask' => 'S', 'rightName' => 'list')
	, 'exp' => array('mask' => 'P', 'rightName' => 'export')
	, 'imp' => array('mask' => 'I', 'rightName' => 'import')
	, 'adm' => array('mask' => 'M'));

$wGroupTableName = $ug_connection->addTableWrappers( "viud1_uggroups" );
	
switch(postvalue("a"))
{
	case "add":
		$sql = "insert into ". $wGroupTableName ." (". $ug_connection->addFieldWrappers( "Label" ) .")"
			." values (". $ug_connection->prepareString( postvalue("name") ). ")";		
		$ug_connection->exec( $sql );

		$sql = "select max(". $ug_connection->addFieldWrappers( "GroupID") .") from ". $wGroupTableName;
		$data = $ug_connection->query( $sql )->fetchNumeric();
		
		echo printJSON( array('success' => true, 'id' => $data[0]) );
		break;
		
	case "del":
		$sql = "delete from ". $wGroupTableName ." where ". $ug_connection->addFieldWrappers("GroupID") ."=".(postvalue_number("id"));
		$ug_connection->exec( $sql );
		
		$sql = "delete from ". $ug_connection->addTableWrappers( "viud1_ugrights" ) 
			." where ". $ug_connection->addFieldWrappers( "GroupID" ) ."=".(postvalue_number("id"));
		$ug_connection->exec( $sql );
		
		$sql = "delete from ".$ug_connection->addTableWrappers( "viud1_ugmembers" ) 
			." where ". $ug_connection->addFieldWrappers( "GroupID" ) ."=".(postvalue_number("id"));
		$ug_connection->exec( $sql );
		
		echo printJSON( array('success' => true) );
		break;
		
	case "rename":
		$sql = "update ". $wGroupTableName  
			." set ". $ug_connection->addFieldWrappers( "Label" ) ."=". $ug_connection->prepareString( postvalue("name") )
			." where ". $ug_connection->addFieldWrappers( "GroupID" ) ."=".(postvalue_number("id"));
		$ug_connection->exec( $sql );
		
		echo printJSON( array('success' => true) );
		break;
	
	case 'saveRights':
		$error = '';
		if( postvalue('state') )
		{	
			$allRights = array();
			$sql = "select ". $ug_connection->addFieldWrappers( "GroupID" ) 
				.", ". $ug_connection->addFieldWrappers( "TableName" ) 
				.", ". $ug_connection->addFieldWrappers( "AccessMask" ) ." from ". $wGroupTableName;
			
			$qResult = $ug_connection->query( $sql );
			// don't use fetchAssoc! because of ORACLE and PostgreSQL
			while( $rightsRow = $qResult->fetchNumeric() )
			{
				$allRights[] = $rightsRow;
			}
			
			$wRightsTableName = $ug_connection->addTableWrappers( "viud1_ugrights" );
			
			$delGroupId = 0;
			$state = my_json_decode( postvalue('state') );
			// delete all extra permissions from db
			foreach($allRights as $i => $rightValue)
			{
				$groupIDInt = (int) $rightValue[0];
				
				if($groupIDInt == $delGroupId)
					continue;
					
				//delete all extra permissions for group
				if( !array_key_exists($groupIDInt, $state) )
				{
					$sql = "delete from ". $wRightsTableName 
						." where ". $ug_connection->addFieldWrappers( "GroupID" ) ."=". $groupIDInt;
					$ug_connection->exec( $sql );
				}
				//delete all extra permissions for table in group
				else if(!array_key_exists(GetTableId($data[1]), $state[$groupIDInt]))
				{
					$sql = "delete from ". $wRightsTableName 
						." where ". $ug_connection->addFieldWrappers( "GroupID" ) ."=". $groupIDInt 
						." and ". $ug_connection->addFieldWrappers( "TableName" ) ."=".$ug_connection->prepareString( html_special_decode($data[1]) );				
					$ug_connection->exec( $sql );
				}
			}
			
			$realTables = GetRealValues();
			foreach ($state as $groupId => $groupRights)
			{
				foreach ($groupRights as $table => $mask)
				{
					if( !array_key_exists($table, $realTables) )
						continue;
					
					$ins = true;
					foreach($allRights as $i => $rightValue)
					{	
						if($rightValue[0] == $groupId && $rightValue[1] == $realTables[$table])	
						{
							$ins = false;
							if($data[2]!= $mask)
							{
								$sql ="update". $wRightsTableName 
									." set ". $ug_connection->addFieldWrappers( "AccessMask" ) ."=". $ug_connection->prepareString( $mask )
									." where ". $ug_connection->addFieldWrappers( "GroupID" ) ."=". $groupId 
									." and ". $ug_connection->addFieldWrappers( "TableName" ) ."=". $ug_connection->prepareString( html_special_decode($realTables[$table]) );
								$ug_connection->exec( $sql );
							}
						}
					}
					if($ins)
					{
						$sql = "insert into ". $wRightsTableName
							." (". $ug_connection->addFieldWrappers( "TableName" ) 
							.", ". $ug_connection->addFieldWrappers( "GroupID" ) 
							.", ". $ug_connection->addFieldWrappers( "AccessMask" ) .") " 
							."values (". $ug_connection->prepareString(html_special_decode($realTables[$table])) .", ". $groupId .", ". $ug_connection->prepareString($mask)  .")";
						$ug_connection->exec( $sql );
					}
					
					$error = $ug_connection->lastError();
				}
			}
		}
		
		getJSONResult($error);
		break;
}

function GetTableId($name)
{
	$tbls = GetRealValues();
	for($i = 0;$i < count($tbls); $i++)
	{
		if($tbls[$i] == $name)
			return $i;
	}
	return -1;
}

/**
 * GetRealValues
 * Form array with real users or tables names
 * @return {array} array of reaf names
 */
function GetRealValues()
{
	$result = array();
	if(postvalue('realValues'))
		$realValues = my_json_decode(postvalue('realValues'));
		foreach ($realValues as $key =>$value)
			$result[$key] = $value;
	return $result;
}

/**
 * getJSONResult
 * Form result as a JSON object according of errors
 * @param {string} list of errors
 */
function getJSONResult($error)
{
	$result['success'] = $error == '';
	$result['error'] = $error;	
	echo printJSON($result);
}