<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("webusers");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblfirefoxbd_at_103_6_168_141__tbl0_China_Customer;
	var $tblfirefoxbd_at_103_6_168_141__FGS_History;
	var $tblfirefoxbd_at_103_6_168_141__gsp_analysis;
	var $tblfirefoxbd_at_103_6_168_141__gsp_analysis_sc_seq;
	var $tblfirefoxbd_at_103_6_168_141__Gsp_Bom_costing;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PI_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_Ap_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_Ap_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_B_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_B_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_B_Item_Booking_SC;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_C_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_Head_Paint;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_Item_Paint;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_F_ItemData;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_M_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_M_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_R_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_R_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_Rc_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_Rc_Item;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_Rim_Head;
	var $tblfirefoxbd_at_103_6_168_141__PO_Imp_Rim_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_A_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Item;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Main;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_plusminus;
	var $tblfirefoxbd_at_103_6_168_141__PSI_Imp_C_Remarks;
	var $tblfirefoxbd_at_103_6_168_141__Sc_Head;
	var $tblfirefoxbd_at_103_6_168_141__SC_Item;
	var $tblfirefoxbd_at_103_6_168_141__Sc_Itemnot_Include;
	var $tblfirefoxbd_at_103_6_168_141__Sc_Reusable;
	var $tblfirefoxbd_at_103_6_168_141__SC_Tube_Allocation;
	var $tblfirefoxbd_at_103_6_168_141__Spec_History;
	var $tblfirefoxbd_at_103_6_168_141__ST_History;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_C_FOB;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_Cap_FOB;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_ExtraFrm;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_F_FOB;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_FOB;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_FOB1;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_FOB_Block;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_FOB_Tube;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_IBWS_FOB;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_Paint_FOB;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_Remain;
	var $tblfirefoxbd_at_103_6_168_141__ST_History_Rim;
	var $tblfirefoxbd_at_103_6_168_141__ST_Item;
	var $tblfirefoxbd_at_103_6_168_141__ST_Item_Bulk;
	var $tblfirefoxbd_at_103_6_168_141__ST_Item_Fixed;
	var $tblfirefoxbd_at_103_6_168_141__Sub_ST_History;
	var $tblfirefoxbd_at_103_6_168_141__Temp_ST_History_Tube;
	var $tblfirefoxbd_at_103_6_168_141__TRI_FGS_History;
	var $tblfirefoxbd_at_103_6_168_141__TRI_Frame_Drawing_Spec_History;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PI_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_B_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_B_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_C_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_M_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_M_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_R_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PO_Imp_R_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_A_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_A_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_A_Main;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Main;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_plusminus;
	var $tblfirefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Remarks;
	var $tblfirefoxbd_at_103_6_168_141__TRI_Sc_Head;
	var $tblfirefoxbd_at_103_6_168_141__TRI_SC_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_Sc_Plus_Minus;
	var $tblfirefoxbd_at_103_6_168_141__TRI_Sc_Remarks;
	var $tblfirefoxbd_at_103_6_168_141__TRI_Sc_Reusable;
	var $tblfirefoxbd_at_103_6_168_141__TRI_ST_History;
	var $tblfirefoxbd_at_103_6_168_141__TRI_ST_History_Repl;
	var $tblfirefoxbd_at_103_6_168_141__TRI_ST_Item;
	var $tblfirefoxbd_at_103_6_168_141__TRI_Sub_ST_History_Tube;
	var $tblfirefoxbd_at_103_6_168_141__viud1_settings;
	var $tblfirefoxbd_at_103_6_168_141__viud1_uggroups;
	var $tblfirefoxbd_at_103_6_168_141__viud1_ugmembers;
	var $tblfirefoxbd_at_103_6_168_141__viud1_ugrights;
	var $tblfirefoxbd_at_103_6_168_141__viudcorvo_audit;
	var $tblfirefoxbd_at_103_6_168_141__webusers;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "0_China_Customer", "varname" => "firefoxbd_at_103_6_168_141__tbl0_China_Customer", "altvarname" => "tbl0_China_Customer", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "FGS_History", "varname" => "firefoxbd_at_103_6_168_141__FGS_History", "altvarname" => "FGS_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "gsp_analysis", "varname" => "firefoxbd_at_103_6_168_141__gsp_analysis", "altvarname" => "gsp_analysis", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "gsp_analysis_sc_seq", "varname" => "firefoxbd_at_103_6_168_141__gsp_analysis_sc_seq", "altvarname" => "gsp_analysis_sc_seq", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Gsp_Bom_costing", "varname" => "firefoxbd_at_103_6_168_141__Gsp_Bom_costing", "altvarname" => "Gsp_Bom_costing", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_A_Head", "altvarname" => "PI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PI_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__PI_Imp_A_Item", "altvarname" => "PI_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_A_Head", "altvarname" => "PO_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_A_Item", "altvarname" => "PO_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_Ap_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_Ap_Head", "altvarname" => "PO_Imp_Ap_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_Ap_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_Ap_Item", "altvarname" => "PO_Imp_Ap_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_B_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_B_Head", "altvarname" => "PO_Imp_B_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_B_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_B_Item", "altvarname" => "PO_Imp_B_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_B_Item_Booking_SC", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_B_Item_Booking_SC", "altvarname" => "PO_Imp_B_Item_Booking_SC", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_C_Head", "altvarname" => "PO_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_C_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_C_Item", "altvarname" => "PO_Imp_C_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_Head", "altvarname" => "PO_Imp_F_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_Head_Paint", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_Head_Paint", "altvarname" => "PO_Imp_F_Head_Paint", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_Item", "altvarname" => "PO_Imp_F_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_Item_Paint", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_Item_Paint", "altvarname" => "PO_Imp_F_Item_Paint", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_F_ItemData", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_F_ItemData", "altvarname" => "PO_Imp_F_ItemData", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_M_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_M_Head", "altvarname" => "PO_Imp_M_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_M_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_M_Item", "altvarname" => "PO_Imp_M_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_R_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_R_Head", "altvarname" => "PO_Imp_R_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_R_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_R_Item", "altvarname" => "PO_Imp_R_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_Rc_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_Rc_Head", "altvarname" => "PO_Imp_Rc_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_Rc_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_Rc_Item", "altvarname" => "PO_Imp_Rc_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_Rim_Head", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_Rim_Head", "altvarname" => "PO_Imp_Rim_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PO_Imp_Rim_Item", "varname" => "firefoxbd_at_103_6_168_141__PO_Imp_Rim_Item", "altvarname" => "PO_Imp_Rim_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Head", "altvarname" => "PSI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Item", "altvarname" => "PSI_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_A_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_A_Main", "altvarname" => "PSI_Imp_A_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Head", "altvarname" => "PSI_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Item", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Item", "altvarname" => "PSI_Imp_C_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Main", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Main", "altvarname" => "PSI_Imp_C_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_plusminus", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_plusminus", "altvarname" => "PSI_Imp_C_plusminus", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "PSI_Imp_C_Remarks", "varname" => "firefoxbd_at_103_6_168_141__PSI_Imp_C_Remarks", "altvarname" => "PSI_Imp_C_Remarks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Sc_Head", "varname" => "firefoxbd_at_103_6_168_141__Sc_Head", "altvarname" => "Sc_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "SC_Item", "varname" => "firefoxbd_at_103_6_168_141__SC_Item", "altvarname" => "SC_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Sc_Itemnot_Include", "varname" => "firefoxbd_at_103_6_168_141__Sc_Itemnot_Include", "altvarname" => "Sc_Itemnot_Include", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Sc_Reusable", "varname" => "firefoxbd_at_103_6_168_141__Sc_Reusable", "altvarname" => "Sc_Reusable", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "SC_Tube_Allocation", "varname" => "firefoxbd_at_103_6_168_141__SC_Tube_Allocation", "altvarname" => "SC_Tube_Allocation", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Spec_History", "varname" => "firefoxbd_at_103_6_168_141__Spec_History", "altvarname" => "Spec_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History", "varname" => "firefoxbd_at_103_6_168_141__ST_History", "altvarname" => "ST_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_C_FOB", "varname" => "firefoxbd_at_103_6_168_141__ST_History_C_FOB", "altvarname" => "ST_History_C_FOB", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_Cap_FOB", "varname" => "firefoxbd_at_103_6_168_141__ST_History_Cap_FOB", "altvarname" => "ST_History_Cap_FOB", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_ExtraFrm", "varname" => "firefoxbd_at_103_6_168_141__ST_History_ExtraFrm", "altvarname" => "ST_History_ExtraFrm", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_F_FOB", "varname" => "firefoxbd_at_103_6_168_141__ST_History_F_FOB", "altvarname" => "ST_History_F_FOB", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_FOB", "varname" => "firefoxbd_at_103_6_168_141__ST_History_FOB", "altvarname" => "ST_History_FOB", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_FOB1", "varname" => "firefoxbd_at_103_6_168_141__ST_History_FOB1", "altvarname" => "ST_History_FOB1", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_FOB_Block", "varname" => "firefoxbd_at_103_6_168_141__ST_History_FOB_Block", "altvarname" => "ST_History_FOB_Block", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_FOB_Tube", "varname" => "firefoxbd_at_103_6_168_141__ST_History_FOB_Tube", "altvarname" => "ST_History_FOB_Tube", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_IBWS_FOB", "varname" => "firefoxbd_at_103_6_168_141__ST_History_IBWS_FOB", "altvarname" => "ST_History_IBWS_FOB", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_Paint_FOB", "varname" => "firefoxbd_at_103_6_168_141__ST_History_Paint_FOB", "altvarname" => "ST_History_Paint_FOB", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_Remain", "varname" => "firefoxbd_at_103_6_168_141__ST_History_Remain", "altvarname" => "ST_History_Remain", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_History_Rim", "varname" => "firefoxbd_at_103_6_168_141__ST_History_Rim", "altvarname" => "ST_History_Rim", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_Item", "varname" => "firefoxbd_at_103_6_168_141__ST_Item", "altvarname" => "ST_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_Item_Bulk", "varname" => "firefoxbd_at_103_6_168_141__ST_Item_Bulk", "altvarname" => "ST_Item_Bulk", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "ST_Item_Fixed", "varname" => "firefoxbd_at_103_6_168_141__ST_Item_Fixed", "altvarname" => "ST_Item_Fixed", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Sub_ST_History", "varname" => "firefoxbd_at_103_6_168_141__Sub_ST_History", "altvarname" => "Sub_ST_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "Temp_ST_History_Tube", "varname" => "firefoxbd_at_103_6_168_141__Temp_ST_History_Tube", "altvarname" => "Temp_ST_History_Tube", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_FGS_History", "varname" => "firefoxbd_at_103_6_168_141__TRI_FGS_History", "altvarname" => "TRI_FGS_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_Frame_Drawing_Spec_History", "varname" => "firefoxbd_at_103_6_168_141__TRI_Frame_Drawing_Spec_History", "altvarname" => "TRI_Frame_Drawing_Spec_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PI_Imp_A_Head", "altvarname" => "TRI_PI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PI_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PI_Imp_A_Item", "altvarname" => "TRI_PI_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_A_Head", "altvarname" => "TRI_PO_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_A_Item", "altvarname" => "TRI_PO_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_B_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_B_Head", "altvarname" => "TRI_PO_Imp_B_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_B_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_B_Item", "altvarname" => "TRI_PO_Imp_B_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_C_Head", "altvarname" => "TRI_PO_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_C_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_C_Item", "altvarname" => "TRI_PO_Imp_C_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_M_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_M_Head", "altvarname" => "TRI_PO_Imp_M_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_M_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_M_Item", "altvarname" => "TRI_PO_Imp_M_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_R_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_R_Head", "altvarname" => "TRI_PO_Imp_R_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PO_Imp_R_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PO_Imp_R_Item", "altvarname" => "TRI_PO_Imp_R_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_A_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_A_Head", "altvarname" => "TRI_PSI_Imp_A_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_A_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_A_Item", "altvarname" => "TRI_PSI_Imp_A_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_A_Main", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_A_Main", "altvarname" => "TRI_PSI_Imp_A_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_C_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Head", "altvarname" => "TRI_PSI_Imp_C_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_C_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Item", "altvarname" => "TRI_PSI_Imp_C_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_C_Main", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Main", "altvarname" => "TRI_PSI_Imp_C_Main", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_C_plusminus", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_plusminus", "altvarname" => "TRI_PSI_Imp_C_plusminus", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_PSI_Imp_C_Remarks", "varname" => "firefoxbd_at_103_6_168_141__TRI_PSI_Imp_C_Remarks", "altvarname" => "TRI_PSI_Imp_C_Remarks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_Sc_Head", "varname" => "firefoxbd_at_103_6_168_141__TRI_Sc_Head", "altvarname" => "TRI_Sc_Head", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_SC_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_SC_Item", "altvarname" => "TRI_SC_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_Sc_Plus_Minus", "varname" => "firefoxbd_at_103_6_168_141__TRI_Sc_Plus_Minus", "altvarname" => "TRI_Sc_Plus_Minus", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_Sc_Remarks", "varname" => "firefoxbd_at_103_6_168_141__TRI_Sc_Remarks", "altvarname" => "TRI_Sc_Remarks", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_Sc_Reusable", "varname" => "firefoxbd_at_103_6_168_141__TRI_Sc_Reusable", "altvarname" => "TRI_Sc_Reusable", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_ST_History", "varname" => "firefoxbd_at_103_6_168_141__TRI_ST_History", "altvarname" => "TRI_ST_History", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_ST_History_Repl", "varname" => "firefoxbd_at_103_6_168_141__TRI_ST_History_Repl", "altvarname" => "TRI_ST_History_Repl", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_ST_Item", "varname" => "firefoxbd_at_103_6_168_141__TRI_ST_Item", "altvarname" => "TRI_ST_Item", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "TRI_Sub_ST_History_Tube", "varname" => "firefoxbd_at_103_6_168_141__TRI_Sub_ST_History_Tube", "altvarname" => "TRI_Sub_ST_History_Tube", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "viud1_settings", "varname" => "firefoxbd_at_103_6_168_141__viud1_settings", "altvarname" => "viud1_settings", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "viud1_uggroups", "varname" => "firefoxbd_at_103_6_168_141__viud1_uggroups", "altvarname" => "viud1_uggroups", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "viud1_ugmembers", "varname" => "firefoxbd_at_103_6_168_141__viud1_ugmembers", "altvarname" => "viud1_ugmembers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "viud1_ugrights", "varname" => "firefoxbd_at_103_6_168_141__viud1_ugrights", "altvarname" => "viud1_ugrights", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "viudcorvo_audit", "varname" => "firefoxbd_at_103_6_168_141__viudcorvo_audit", "altvarname" => "viudcorvo_audit", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
		$this->lstTables[] = array("name" => "webusers", "varname" => "firefoxbd_at_103_6_168_141__webusers", "altvarname" => "webusers", "connId" => "firefoxbd_at_103_6_168_141", "schema" => "", "connName" => "firefoxbd at erp.corvoltd.com");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( $schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection(\''. $tbl["connId"] .'\');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>