<?php
include("dbcon.php");

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

$term = isset($_GET['term']) ? $_GET['term'] : '';
$suggestions = array();

if (!empty($term)) {
    $term = mysqli_real_escape_string($conn, $term);
    
    // Adjust column name if necessary (e.g., Unit_Price → unit_price)
    $sql = "SELECT Stock_code, UnitPrice FROM SC_Item 
            WHERE Stock_code LIKE '%$term%' 
            GROUP BY Stock_code 
            LIMIT 10";
    $result = mysqli_query($conn, $sql);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn));
    }

    while ($row = mysqli_fetch_assoc($result)) {
        $suggestions[] = array(
            'label' => $row['Stock_code'],  // Display in dropdown
            'value' => $row['Stock_code'],  // Value to input field
            'unit_price' => $row['UnitPrice']  // Additional data
        );
    }
}

header('Content-Type: application/json');
echo json_encode($suggestions);
?>