<?php
    date_default_timezone_set('Asia/Dhaka');
    require ('dbcon.php');

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    require 'PHPMailer-6.6.3/src/Exception.php';
    require 'PHPMailer-6.6.3/src/PHPMailer.php';
    require 'PHPMailer-6.6.3/src/SMTP.php';

    $today = date("Y-m-d");
    $ETAt = date("Y-m-d", strtotime($today."+14 day"));
    $ETAf = date("Y-m-d", strtotime($today."+0 day"));
    $ETAfa = date("Y-m-d", strtotime($today."-1 day"));

    $msg = '<table border="1" cellpadding="0" cellspacing="0" style="text-align:center;">
        <tr>
            <td>Inv</td>
            <td>Vessel Name</td>
            <td>Voyage NO</td>
            <td>Cont NO</td>
            <td>Shipping Line</td>
            <td>ETD</td>
            <td>ETA</td>
            <td>New ETA</td>
            <td>To</td>
            <td>Customer</td>
        </tr>';

    $d = 0; 
    $invs = "";
    $processedInvoices = array(); // Array to track processed invoice numbers

    // First query: NewETA between today and 14 days ahead
    $sel = mysqli_query($conn, "SELECT * FROM SHP_Adv_Head WHERE (NewETA BETWEEN '$ETAf' AND '$ETAt')");
    while($row = mysqli_fetch_assoc($sel)) {
        $InvNo = $row['InvNo'];
        
        // Skip if this invoice has already been processed
        if (in_array($InvNo, $processedInvoices)) {
            continue;
        }
        
        $processedInvoices[] = $InvNo; // Mark as processed
        
        $VesselName = $row['VesselName'];
        $VoyageNo = $row['VoyageNo'];
        $ShippingLine = $row['ShippingLine'];
        $ETD = $row['ETD'];
        $ETA = $row['ETA'];
        $NewETA = $row['NewETA'];
        $To = $row['To'];
        $BuyerID = $row['BuyerID'];
        $Exp_Internal = $row['Exp_Internal'];

        ($invs != "") ? $invs .= ", '".$InvNo."'" : $invs = "'".$InvNo."'";
        
        $selcn = mysqli_query($conn, "SELECT NickName FROM Customer WHERE Cst_ID='$BuyerID'");
        $rowcn = mysqli_fetch_assoc($selcn);
        $NickName = $rowcn['NickName'];
        
        // Get container numbers
        $selcn1 = mysqli_query($conn, "SELECT * FROM Exp_Inv_Main WHERE InvoiceNo='$InvNo'");
        $rowcn1 = mysqli_fetch_assoc($selcn1);
        $expinternal = $rowcn1['Internal'];
        
        $cont_nos = array();
        $sel_cont = mysqli_query($conn, "SELECT CNTR_No FROM Exp_Inv_Cont WHERE MainInternal='$expinternal'");
        while($cont_row = mysqli_fetch_assoc($sel_cont)) {
            $cont_nos[] = $cont_row['CNTR_No'];
        }
        $cont_list = implode(", ", $cont_nos);

        $s = 0;
        $selcns = mysqli_query($conn, "SELECT dueamt1, dueamt2, Total_Invpaid FROM Invoice_Head WHERE Expmain_Int='$Exp_Internal'");
        while($rowcns = mysqli_fetch_assoc($selcns)) {
            $dueamt1 = $rowcns['dueamt1'];
            $dueamt2 = $rowcns['dueamt2'];
            $Total_Invpaid = $rowcns['Total_Invpaid'];

            if($dueamt2 == "") $dueamt2 = 0;
            if($Total_Invpaid == "") $Total_Invpaid = 0;
            
            if(($dueamt1 + $dueamt2) > $Total_Invpaid) {
                $s = 1;
            }
        }

        if($s == 1) {
            $msg .= '<tr>
                <td>'.$InvNo.'</td>
                <td>'.$VesselName.'</td>
                <td>'.$VoyageNo.'</td>
                <td>'.$cont_list.'</td>
                <td>'.$ShippingLine.'</td>
                <td>'.$ETD.'</td>
                <td>'.$ETA.'</td>
                <td>'.$NewETA.'</td>
                <td>'.$To.'</td>
                <td>'.$NickName.'</td>
            </tr>';
            $d = 1;
        }
    }

    // Second query: ETA between today and 14 days ahead, excluding already processed invoices
    $where = "";
    if($invs != "") {
        $where = " AND InvNo NOT IN ($invs)";
    }
    
    $sel = mysqli_query($conn, "SELECT * FROM SHP_Adv_Head WHERE (ETA BETWEEN '$ETAf' AND '$ETAt') $where");
    while($row = mysqli_fetch_assoc($sel)) {
        $InvNo = $row['InvNo'];
        
        // Skip if this invoice has already been processed
        if (in_array($InvNo, $processedInvoices)) {
            continue;
        }
        
        $processedInvoices[] = $InvNo; // Mark as processed
        
        $VesselName = $row['VesselName'];
        $VoyageNo = $row['VoyageNo'];
        $ShippingLine = $row['ShippingLine'];
        $ETD = $row['ETD'];
        $ETA = $row['ETA'];
        $NewETA = $row['NewETA'];
        $To = $row['To'];
        $BuyerID = $row['BuyerID'];
        $Exp_Internal = $row['Exp_Internal'];
        
        $selcn = mysqli_query($conn, "SELECT NickName FROM Customer WHERE Cst_ID='$BuyerID'");
        $rowcn = mysqli_fetch_assoc($selcn);
        $NickName = $rowcn['NickName'];
        
        // Get container numbers
        $selcn1 = mysqli_query($conn, "SELECT * FROM Exp_Inv_Main WHERE InvoiceNo='$InvNo'");
        $rowcn1 = mysqli_fetch_assoc($selcn1);
        $expinternal = $rowcn1['Internal'];
        
        $cont_nos = array();
        $sel_cont = mysqli_query($conn, "SELECT CNTR_No FROM Exp_Inv_Cont WHERE MainInternal='$expinternal'");
        while($cont_row = mysqli_fetch_assoc($sel_cont)) {
            $cont_nos[] = $cont_row['CNTR_No'];
        }
        $cont_list = implode(", ", $cont_nos);

        $s = 0;
        $selcns = mysqli_query($conn, "SELECT dueamt1, dueamt2, Total_Invpaid FROM Invoice_Head WHERE Expmain_Int='$Exp_Internal'");
        while($rowcns = mysqli_fetch_assoc($selcns)) {
            $dueamt1 = $rowcns['dueamt1'];
            $dueamt2 = $rowcns['dueamt2'];
            $Total_Invpaid = $rowcns['Total_Invpaid'];

            if($dueamt2 == "") $dueamt2 = 0;
            if($Total_Invpaid == "") $Total_Invpaid = 0;
            
            if(($dueamt1 + $dueamt2) > $Total_Invpaid) {
                $s = 1;
            }
        }

        if($s == 1) {
            $msg .= '<tr>
                <td>'.$InvNo.'</td>
                <td>'.$VesselName.'</td>
                <td>'.$VoyageNo.'</td>
                <td>'.$cont_list.'</td>
                <td>'.$ShippingLine.'</td>
                <td>'.$ETD.'</td>
                <td>'.$ETA.'</td>
                <td>'.$NewETA.'</td>
                <td>'.$To.'</td>
                <td>'.$NickName.'</td>
            </tr>';
            $d = 1;
        }
    }

    // Third query: ETA before today (past shipments)
    $sel = mysqli_query($conn, "SELECT * FROM SHP_Adv_Head WHERE (ETA BETWEEN '2023-12-31' AND '$ETAfa')");
    while($row = mysqli_fetch_assoc($sel)) {
        $InvNo = $row['InvNo'];
        
        // Skip if this invoice has already been processed
        if (in_array($InvNo, $processedInvoices)) {
            continue;
        }
        
        $processedInvoices[] = $InvNo; // Mark as processed
        
        $VesselName = $row['VesselName'];
        $VoyageNo = $row['VoyageNo'];
        $ShippingLine = $row['ShippingLine'];
        $ETD = $row['ETD'];
        $ETA = $row['ETA'];
        $NewETA = $row['NewETA'];
        $To = $row['To'];
        $BuyerID = $row['BuyerID'];
        $Exp_Internal = $row['Exp_Internal'];

        ($invs != "") ? $invs .= ", '".$InvNo."'" : $invs = "'".$InvNo."'";
        
        $selcn = mysqli_query($conn, "SELECT NickName FROM Customer WHERE Cst_ID='$BuyerID'");
        $rowcn = mysqli_fetch_assoc($selcn);
        $NickName = $rowcn['NickName'];
        
        // Get container numbers
        $selcn1 = mysqli_query($conn, "SELECT * FROM Exp_Inv_Main WHERE InvoiceNo='$InvNo'");
        $rowcn1 = mysqli_fetch_assoc($selcn1);
        $expinternal = $rowcn1['Internal'];
        
        $cont_nos = array();
        $sel_cont = mysqli_query($conn, "SELECT CNTR_No FROM Exp_Inv_Cont WHERE MainInternal='$expinternal'");
        while($cont_row = mysqli_fetch_assoc($sel_cont)) {
            $cont_nos[] = $cont_row['CNTR_No'];
        }
        $cont_list = implode(", ", $cont_nos);
        
        $ttlpaidall = 0;
        $ttlitem = 0;
        $bal = 0;
        
        $selcns = mysqli_query($conn, "SELECT * FROM Invoice_Head WHERE Expmain_Int='".mysqli_real_escape_string($conn, $Exp_Internal)."'");
        if(!$selcns) {
            die("Invoice Head Query Error: " . mysqli_error($conn));
        }

        while($rowcns = mysqli_fetch_assoc($selcns)) {
            $Paid_Amt1 = (float)$rowcns['Paid_Amt1'];
            $Paid_Amt2 = (float)$rowcns['Paid_Amt2'];
            $Paid_Amt3 = (float)$rowcns['Paid_Amt3'];
            
            $ttlpaid = $Paid_Amt1 + $Paid_Amt2 + $Paid_Amt3;
            $ttlpaidall += $ttlpaid;

            $headinternal = $rowcns['internal'];

            $selcnsa = mysqli_query($conn, "SELECT * FROM Invoice_item WHERE internal='".$headinternal."'");
            if(!$selcnsa) {
                die("Invoice Item Query Error: " . mysqli_error($conn));
            }

            $head_total = 0;
            while($rowcnsa = mysqli_fetch_assoc($selcnsa)) {
                $qty = (float)$rowcnsa["shp_qty"];
                $price = (float)$rowcnsa["unit_price"];
                $head_total += $qty * $price;
            }
            $ttlitem += $head_total;
            
            mysqli_free_result($selcnsa);
        }
        
        $ttlitem1 = number_format($ttlitem, 2);
        $ttlpaidall1 = number_format($ttlpaidall, 2);
        $bal = $ttlitem1 - $ttlpaidall1;
        $xx = $InvNo."-".$ttlitem."-".$ttlpaidall."-".$Exp_Internal."-".$bal;
        
        if($bal > 0) {
            echo $xx;
            echo "</br>";
            $msg .= '<tr>
                <td>'.$InvNo.'</td>
                <td>'.$VesselName.'</td>
                <td>'.$VoyageNo.'</td>
                <td>'.$cont_list.'</td>
                <td>'.$ShippingLine.'</td>
                <td>'.$ETD.'</td>
                <td>'.$ETA.'</td>
                <td>'.$NewETA.'</td>
                <td>'.$To.'</td>
                <td>'.$NickName.'</td>
            </tr>';
            $d = 1;
        }
    }

    $msg .= '</table>';

    $modelsubject = "ETA date verification data for Shp Adv of ETA ".$ETAf." to ".$ETAt;
    $Information = $msg;
    $from = "shp_adv_new_eta_verify@corvoltd.com";
    
    $email1 = "amy@intrend.com.tw";
    $email4 = "sujeewa@corvoltd.com";
    $email5 = "programmer@tridentcycles.net";
    $email6 = "sahil@intrend.com.tw";
    $email7 = "saheela@intrend.com.tw";
    $email8 = "angel@intrend.com.tw";
    $email9 = "carol@intertrend.com.cn";
    $email10 = "lynn@intrend.com.tw";
    $email = "umanga@corvoltd.com";

    $mail = new PHPMailer;
    $mail->isSMTP();
    $mail->SMTPOptions = [
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false,
            'allow_self_signed' => true,
        ]
    ];
    $mail->Host = "mail.corvoltd.com";
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;
    $mail->SMTPAuth = true;
    $mail->isHTML(true);
    $mail->Username = "sys@corvoltd.com";
    $mail->Password = "Sybd1357";
    $mail->setFrom($from, 'System');

    $mail->Subject = $modelsubject;
    $mail->Body = $Information;
    $mail->addAddress($email, $email);
    $mail->addAddress($email4, $email4);


    if($d == 1) {
        $mail->send();
    }

    echo "Today ".$today." mail send on shipment advice eta verification data";
?>