<?php
    date_default_timezone_set('Asia/Dhaka');
    require ('dbcon.php');

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    require 'PHPMailer-6.6.3/src/Exception.php';
    require 'PHPMailer-6.6.3/src/PHPMailer.php';
    require 'PHPMailer-6.6.3/src/SMTP.php';

    $today = date("Y-m-d");
    $ETAt = date("Y-m-d", strtotime($today."+14 day"));
    $ETAf = date("Y-m-d", strtotime($today."+0 day"));
    $ETAfa = date("Y-m-d", strtotime($today."-1 day"));

    // Initialize Excel data
    $excelData = "Inv No,Vessel Name,Voyage No,Container No,Shipping Line,ETD,ETA,New ETA,To,Customer,Total Amount,Total Paid,Balance\n";
    
    $msg = '<table border="1" cellpadding="0" cellspacing="0" style="text-align:center;">
        <tr>
            <td>Inv</td>
            <td>Vessel Name</td>
            <td>Voyage NO</td>
            <td>Cont NO</td>
            <td>Shipping Line</td>
            <td>ETD</td>
            <td>ETA</td>
            <td>New ETA</td>
            <td>To</td>
            <td>Customer</td>
            <td>Total Amount</td>
            <td>Total Paid</td>
            <td>Balance</td>
        </tr>';

    $d = 0; 
    $invs = "";
    $processedInvoices = array();

    // Function to process each row
    function processRow($conn, $row, &$msg, &$excelData, &$d) {
        $InvNo = $row['InvNo'];
        $VesselName = $row['VesselName'];
        $VoyageNo = $row['VoyageNo'];
        $ShippingLine = $row['ShippingLine'];
        $ETD = $row['ETD'];
        $ETA = $row['ETA'];
        $NewETA = $row['NewETA'];
        $To = $row['To'];
        $BuyerID = $row['BuyerID'];
        $Exp_Internal = $row['Exp_Internal'];
        
        $selcn = mysqli_query($conn, "SELECT NickName FROM Customer WHERE Cst_ID='$BuyerID'");
        $rowcn = mysqli_fetch_assoc($selcn);
        $NickName = $rowcn['NickName'];
        
        // Get container numbers
        $selcn1 = mysqli_query($conn, "SELECT * FROM Exp_Inv_Main WHERE InvoiceNo='$InvNo'");
        $rowcn1 = mysqli_fetch_assoc($selcn1);
        $expinternal = $rowcn1['Internal'];
        
        $cont_nos = array();
        $sel_cont = mysqli_query($conn, "SELECT CNTR_No FROM Exp_Inv_Cont WHERE MainInternal='$expinternal'");
        while($cont_row = mysqli_fetch_assoc($sel_cont)) {
            $cont_nos[] = $cont_row['CNTR_No'];
        }
        $cont_list = implode(", ", $cont_nos);

        // Calculate totals and balance
        $ttlpaidall = 0;
        $ttlitem = 0;
        
        $selcns = mysqli_query($conn, "SELECT * FROM Invoice_Head WHERE Expmain_Int='".mysqli_real_escape_string($conn, $Exp_Internal)."'");
        if(!$selcns) {
            die("Invoice Head Query Error: " . mysqli_error($conn));
        }

        while($rowcns = mysqli_fetch_assoc($selcns)) {
            $Paid_Amt1 = (float)$rowcns['Paid_Amt1'];
            $Paid_Amt2 = (float)$rowcns['Paid_Amt2'];
            $Paid_Amt3 = (float)$rowcns['Paid_Amt3'];
            
            $ttlpaid = $Paid_Amt1 + $Paid_Amt2 + $Paid_Amt3;
            $ttlpaidall += $ttlpaid;

            $headinternal = $rowcns['internal'];

            $selcnsa = mysqli_query($conn, "SELECT * FROM Invoice_item WHERE internal='".$headinternal."'");
            if(!$selcnsa) {
                die("Invoice Item Query Error: " . mysqli_error($conn));
            }

            $head_total = 0;
            while($rowcnsa = mysqli_fetch_assoc($selcnsa)) {
                $qty = (float)$rowcnsa["shp_qty"];
                $price = (float)$rowcnsa["unit_price"];
                $head_total += $qty * $price;
            }
            $ttlitem += $head_total;
            
            mysqli_free_result($selcnsa);
        }
        
        $ttlitem1 = number_format($ttlitem, 2);
        $ttlpaidall1 = number_format($ttlpaidall, 2);
        $bal = $ttlitem1 - $ttlpaidall1;
        
        // Add to Excel data
        $excelData .= '"' . str_replace('"', '""', $InvNo) . '",';
        $excelData .= '"' . str_replace('"', '""', $VesselName) . '",';
        $excelData .= '"' . str_replace('"', '""', $VoyageNo) . '",';
        $excelData .= '"' . str_replace('"', '""', $cont_list) . '",';
        $excelData .= '"' . str_replace('"', '""', $ShippingLine) . '",';
        $excelData .= '"' . str_replace('"', '""', $ETD) . '",';
        $excelData .= '"' . str_replace('"', '""', $ETA) . '",';
        $excelData .= '"' . str_replace('"', '""', $NewETA) . '",';
        $excelData .= '"' . str_replace('"', '""', $To) . '",';
        $excelData .= '"' . str_replace('"', '""', $NickName) . '",';
        $excelData .= '"' . str_replace('"', '""', $ttlitem1) . '",';
        $excelData .= '"' . str_replace('"', '""', $ttlpaidall1) . '",';
        $excelData .= '"' . str_replace('"', '""', $bal) . '"';
        $excelData .= "\n";
        
        // Add to HTML email
        $msg .= '<tr>
            <td>'.$InvNo.'</td>
            <td>'.$VesselName.'</td>
            <td>'.$VoyageNo.'</td>
            <td>'.$cont_list.'</td>
            <td>'.$ShippingLine.'</td>
            <td>'.$ETD.'</td>
            <td>'.$ETA.'</td>
            <td>'.$NewETA.'</td>
            <td>'.$To.'</td>
            <td>'.$NickName.'</td>
            <td>'.$ttlitem1.'</td>
            <td>'.$ttlpaidall1.'</td>
            <td>'.$bal.'</td>
        </tr>';
        $d = 1;
        
        return true;
    }

    // First query: NewETA between today and 14 days ahead
    $sel = mysqli_query($conn, "SELECT * FROM SHP_Adv_Head WHERE (NewETA BETWEEN '$ETAf' AND '$ETAt')");
    while($row = mysqli_fetch_assoc($sel)) {
        $InvNo = $row['InvNo'];
        if (in_array($InvNo, $processedInvoices)) continue;
        $processedInvoices[] = $InvNo;
        processRow($conn, $row, $msg, $excelData, $d);
    }

    // Second query: ETA between today and 14 days ahead, excluding already processed invoices
    $where = ($invs != "") ? " AND InvNo NOT IN ($invs)" : "";
    $sel = mysqli_query($conn, "SELECT * FROM SHP_Adv_Head WHERE (ETA BETWEEN '$ETAf' AND '$ETAt') $where");
    while($row = mysqli_fetch_assoc($sel)) {
        $InvNo = $row['InvNo'];
        if (in_array($InvNo, $processedInvoices)) continue;
        $processedInvoices[] = $InvNo;
        processRow($conn, $row, $msg, $excelData, $d);
    }

    // Third query: ETA before today (past shipments)
    $sel = mysqli_query($conn, "SELECT * FROM SHP_Adv_Head WHERE (ETA BETWEEN '2020-01-01' AND '$ETAfa')");
    while($row = mysqli_fetch_assoc($sel)) {
        $InvNo = $row['InvNo'];
        if (in_array($InvNo, $processedInvoices)) continue;
        $processedInvoices[] = $InvNo;
        processRow($conn, $row, $msg, $excelData, $d);
    }

    $msg .= '</table>';

    // Send email
    $modelsubject = "ETA date verification data for Shp Adv of ETA ".$ETAf." to ".$ETAt;
    $Information = $msg;
    $from = "shp_adv_new_eta_verify@corvoltd.com";
    
    $email = "umanga@corvoltd.com";

    $mail = new PHPMailer;
    $mail->isSMTP();
    $mail->SMTPOptions = [
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false,
            'allow_self_signed' => true,
        ]
    ];
    $mail->Host = "mail.corvoltd.com";
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port = 587;
    $mail->SMTPAuth = true;
    $mail->isHTML(true);
    $mail->Username = "sys@corvoltd.com";
    $mail->Password = "Sybd1357";
    $mail->setFrom($from, 'System');

    $mail->Subject = $modelsubject;
    $mail->Body = $Information;
    $mail->addAddress($email, $email);

    if($d == 1) {
        $mail->send();
    }

    // Output Excel file for download
    header('Content-Type: application/csv');
    header('Content-Disposition: attachment; filename="shipment_advice_eta_report_' . $today . '.csv"');
    echo $excelData;
    exit;

    echo "Today ".$today." mail send on shipment advice eta verification data";
?>