<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["bd_model.Customer_Ref"] )) {
			$lookupTableLinks["Customer"]["bd_model.Customer_Ref"] = array();
		}
		$lookupTableLinks["Customer"]["bd_model.Customer_Ref"]["edit"] = array("table" => "BD_Model", "field" => "Customer_Ref", "page" => "edit");
		if( !isset( $lookupTableLinks["Model_Group"] ) ) {
			$lookupTableLinks["Model_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Model_Group"]["bd_model.GroupID"] )) {
			$lookupTableLinks["Model_Group"]["bd_model.GroupID"] = array();
		}
		$lookupTableLinks["Model_Group"]["bd_model.GroupID"]["edit"] = array("table" => "BD_Model", "field" => "GroupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["supplier_maintenance.Country"] )) {
			$lookupTableLinks["Country"]["supplier_maintenance.Country"] = array();
		}
		$lookupTableLinks["Country"]["supplier_maintenance.Country"]["edit"] = array("table" => "Supplier_Maintenance", "field" => "Country", "page" => "edit");
		if( !isset( $lookupTableLinks["Maintenance_Item"] ) ) {
			$lookupTableLinks["Maintenance_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Maintenance_Item"]["maintenance_input.MT_Itemcode"] )) {
			$lookupTableLinks["Maintenance_Item"]["maintenance_input.MT_Itemcode"] = array();
		}
		$lookupTableLinks["Maintenance_Item"]["maintenance_input.MT_Itemcode"]["edit"] = array("table" => "Maintenance_Input", "field" => "MT_Itemcode", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier_Maintenance"] ) ) {
			$lookupTableLinks["Supplier_Maintenance"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier_Maintenance"]["maintenance_input.Service_Supplier"] )) {
			$lookupTableLinks["Supplier_Maintenance"]["maintenance_input.Service_Supplier"] = array();
		}
		$lookupTableLinks["Supplier_Maintenance"]["maintenance_input.Service_Supplier"]["edit"] = array("table" => "Maintenance_Input", "field" => "Service_Supplier", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["maintenance_item.Category"] )) {
			$lookupTableLinks["Assets_Group"]["maintenance_item.Category"] = array();
		}
		$lookupTableLinks["Assets_Group"]["maintenance_item.Category"]["edit"] = array("table" => "Maintenance_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Item"] ) ) {
			$lookupTableLinks["Assets_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Item"]["maintenance_item.Item_Code"] )) {
			$lookupTableLinks["Assets_Item"]["maintenance_item.Item_Code"] = array();
		}
		$lookupTableLinks["Assets_Item"]["maintenance_item.Item_Code"]["edit"] = array("table" => "Maintenance_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["maintenance_item.Country"] )) {
			$lookupTableLinks["Country"]["maintenance_item.Country"] = array();
		}
		$lookupTableLinks["Country"]["maintenance_item.Country"]["edit"] = array("table" => "Maintenance_Item", "field" => "Country", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["maintenance_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["maintenance_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["maintenance_item.Unit"]["edit"] = array("table" => "Maintenance_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["maintenance_item.Manufactur"] )) {
			$lookupTableLinks["Supplier"]["maintenance_item.Manufactur"] = array();
		}
		$lookupTableLinks["Supplier"]["maintenance_item.Manufactur"]["edit"] = array("table" => "Maintenance_Item", "field" => "Manufactur", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["assets_item.Category"] )) {
			$lookupTableLinks["Assets_Group"]["assets_item.Category"] = array();
		}
		$lookupTableLinks["Assets_Group"]["assets_item.Category"]["edit"] = array("table" => "Assets_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["assets_item.Country"] )) {
			$lookupTableLinks["Country"]["assets_item.Country"] = array();
		}
		$lookupTableLinks["Country"]["assets_item.Country"]["edit"] = array("table" => "Assets_Item", "field" => "Country", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["assets_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["assets_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["assets_item.Unit"]["edit"] = array("table" => "Assets_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Time_Period"] ) ) {
			$lookupTableLinks["Time_Period"] = array();
		}
		if( !isset( $lookupTableLinks["Time_Period"]["assets_item.time_period"] )) {
			$lookupTableLinks["Time_Period"]["assets_item.time_period"] = array();
		}
		$lookupTableLinks["Time_Period"]["assets_item.time_period"]["edit"] = array("table" => "Assets_Item", "field" => "time_period", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["assets_item.Manufactur"] )) {
			$lookupTableLinks["Supplier"]["assets_item.Manufactur"] = array();
		}
		$lookupTableLinks["Supplier"]["assets_item.Manufactur"]["edit"] = array("table" => "Assets_Item", "field" => "Manufactur", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["supplier.Country"] )) {
			$lookupTableLinks["Country"]["supplier.Country"] = array();
		}
		$lookupTableLinks["Country"]["supplier.Country"]["edit"] = array("table" => "Supplier", "field" => "Country", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Group"] ) ) {
			$lookupTableLinks["Spec_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Group"]["supplier.Item_Cat"] )) {
			$lookupTableLinks["Spec_Group"]["supplier.Item_Cat"] = array();
		}
		$lookupTableLinks["Spec_Group"]["supplier.Item_Cat"]["edit"] = array("table" => "Supplier", "field" => "Item_Cat", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["supplier.Item_ref"] )) {
			$lookupTableLinks["Parts"]["supplier.Item_ref"] = array();
		}
		$lookupTableLinks["Parts"]["supplier.Item_ref"]["edit"] = array("table" => "Supplier", "field" => "Item_ref", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["supplier.Country1"] )) {
			$lookupTableLinks["Country"]["supplier.Country1"] = array();
		}
		$lookupTableLinks["Country"]["supplier.Country1"]["edit"] = array("table" => "Supplier", "field" => "Country1", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["supplier.Country2"] )) {
			$lookupTableLinks["Country"]["supplier.Country2"] = array();
		}
		$lookupTableLinks["Country"]["supplier.Country2"]["edit"] = array("table" => "Supplier", "field" => "Country2", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["supplier.Country3"] )) {
			$lookupTableLinks["Country"]["supplier.Country3"] = array();
		}
		$lookupTableLinks["Country"]["supplier.Country3"]["edit"] = array("table" => "Supplier", "field" => "Country3", "page" => "edit");
		if( !isset( $lookupTableLinks["Country"] ) ) {
			$lookupTableLinks["Country"] = array();
		}
		if( !isset( $lookupTableLinks["Country"]["supplier.Country4"] )) {
			$lookupTableLinks["Country"]["supplier.Country4"] = array();
		}
		$lookupTableLinks["Country"]["supplier.Country4"]["edit"] = array("table" => "Supplier", "field" => "Country4", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Group"] ) ) {
			$lookupTableLinks["Spec_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Group"]["supplier.Item_Cat1"] )) {
			$lookupTableLinks["Spec_Group"]["supplier.Item_Cat1"] = array();
		}
		$lookupTableLinks["Spec_Group"]["supplier.Item_Cat1"]["edit"] = array("table" => "Supplier", "field" => "Item_Cat1", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["supplier.Item_ref1"] )) {
			$lookupTableLinks["Parts"]["supplier.Item_ref1"] = array();
		}
		$lookupTableLinks["Parts"]["supplier.Item_ref1"]["edit"] = array("table" => "Supplier", "field" => "Item_ref1", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Group"] ) ) {
			$lookupTableLinks["Spec_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Group"]["supplier.Item_Cat2"] )) {
			$lookupTableLinks["Spec_Group"]["supplier.Item_Cat2"] = array();
		}
		$lookupTableLinks["Spec_Group"]["supplier.Item_Cat2"]["edit"] = array("table" => "Supplier", "field" => "Item_Cat2", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["supplier.Item_ref2"] )) {
			$lookupTableLinks["Parts"]["supplier.Item_ref2"] = array();
		}
		$lookupTableLinks["Parts"]["supplier.Item_ref2"]["edit"] = array("table" => "Supplier", "field" => "Item_ref2", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Cat"] ) ) {
			$lookupTableLinks["ST_Item_Cat"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Cat"]["st_item.Category"] )) {
			$lookupTableLinks["ST_Item_Cat"]["st_item.Category"] = array();
		}
		$lookupTableLinks["ST_Item_Cat"]["st_item.Category"]["edit"] = array("table" => "ST_Item", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Spec_Group"] ) ) {
			$lookupTableLinks["Spec_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Spec_Group"]["st_item.Part"] )) {
			$lookupTableLinks["Spec_Group"]["st_item.Part"] = array();
		}
		$lookupTableLinks["Spec_Group"]["st_item.Part"]["edit"] = array("table" => "ST_Item", "field" => "Part", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["st_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["st_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["st_item.Unit"]["edit"] = array("table" => "ST_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["st_item_chain.Item_No"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["st_item_chain.Item_No"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["st_item_chain.Item_No"]["edit"] = array("table" => "ST_Item_Chain", "field" => "Item_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["st_item_chain.Supplier"] )) {
			$lookupTableLinks["Supplier"]["st_item_chain.Supplier"] = array();
		}
		$lookupTableLinks["Supplier"]["st_item_chain.Supplier"]["edit"] = array("table" => "ST_Item_Chain", "field" => "Supplier", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_a_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_a_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_a_head.TitleID"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_imp_a_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_imp_a_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_imp_a_head.SupID"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["po_imp_a_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright"]["po_imp_a_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright"]["po_imp_a_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["po_imp_a_head.Isseued_By1"] )) {
			$lookupTableLinks["webusers"]["po_imp_a_head.Isseued_By1"] = array();
		}
		$lookupTableLinks["webusers"]["po_imp_a_head.Isseued_By1"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "Isseued_By1", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_a_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_a_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_a_head.Destination"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_a_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_a_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_a_head.Port"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_a_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_a_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_a_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_a_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_a_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_a_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_a_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_a_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_a_head.Currency"]["edit"] = array("table" => "PO_Imp_A_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["po_imp_a_item.Cat_ID"] )) {
			$lookupTableLinks["Assets_Group"]["po_imp_a_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Assets_Group"]["po_imp_a_item.Cat_ID"]["edit"] = array("table" => "PO_Imp_A_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Item"] ) ) {
			$lookupTableLinks["Assets_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Item"]["po_imp_a_item.Item_Code"] )) {
			$lookupTableLinks["Assets_Item"]["po_imp_a_item.Item_Code"] = array();
		}
		$lookupTableLinks["Assets_Item"]["po_imp_a_item.Item_Code"]["edit"] = array("table" => "PO_Imp_A_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["po_imp_a_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["po_imp_a_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["po_imp_a_item.Unit"]["edit"] = array("table" => "PO_Imp_A_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Time_Period"] ) ) {
			$lookupTableLinks["Time_Period"] = array();
		}
		if( !isset( $lookupTableLinks["Time_Period"]["po_imp_a_item.time_period"] )) {
			$lookupTableLinks["Time_Period"]["po_imp_a_item.time_period"] = array();
		}
		$lookupTableLinks["Time_Period"]["po_imp_a_item.time_period"]["edit"] = array("table" => "PO_Imp_A_Item", "field" => "time_period", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["imp_a_remarks.Ship_marks"] )) {
			$lookupTableLinks["Shipping_Marks"]["imp_a_remarks.Ship_marks"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["imp_a_remarks.Ship_marks"]["edit"] = array("table" => "Imp_A_Remarks", "field" => "Ship_marks", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_c_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_c_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_c_head.TitleID"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_imp_c_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_imp_c_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_imp_c_head.SupID"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["po_imp_c_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright"]["po_imp_c_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright"]["po_imp_c_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_c_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_c_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_c_head.Destination"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_c_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_c_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_c_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_c_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_c_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_c_head.Port"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_c_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_c_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_c_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_c_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_c_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_c_head.Currency"]["edit"] = array("table" => "PO_Imp_C_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts211"] ) ) {
			$lookupTableLinks["Parts211"] = array();
		}
		if( !isset( $lookupTableLinks["Parts211"]["po_imp_c_item.Cat_ID"] )) {
			$lookupTableLinks["Parts211"]["po_imp_c_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts211"]["po_imp_c_item.Cat_ID"]["edit"] = array("table" => "PO_Imp_C_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["po_imp_c_item.Item_Code"] )) {
			$lookupTableLinks["ST_Item"]["po_imp_c_item.Item_Code"] = array();
		}
		$lookupTableLinks["ST_Item"]["po_imp_c_item.Item_Code"]["edit"] = array("table" => "PO_Imp_C_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["imp_c_remarks.Ship_marks"] )) {
			$lookupTableLinks["Shipping_Marks"]["imp_c_remarks.Ship_marks"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["imp_c_remarks.Ship_marks"]["edit"] = array("table" => "Imp_C_Remarks", "field" => "Ship_marks", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_loc_b_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_loc_b_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_loc_b_head.TitleID"]["edit"] = array("table" => "PO_Loc_B_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_loc_b_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_loc_b_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_loc_b_head.SupID"]["edit"] = array("table" => "PO_Loc_B_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_loc_b_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_loc_b_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_loc_b_head.Destination"]["edit"] = array("table" => "PO_Loc_B_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_loc_b_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_loc_b_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_loc_b_head.Paymt_Term"]["edit"] = array("table" => "PO_Loc_B_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_loc_b_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_loc_b_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_loc_b_head.Currency"]["edit"] = array("table" => "PO_Loc_B_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts3"] ) ) {
			$lookupTableLinks["Parts3"] = array();
		}
		if( !isset( $lookupTableLinks["Parts3"]["po_loc_b_item.Cat_ID"] )) {
			$lookupTableLinks["Parts3"]["po_loc_b_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts3"]["po_loc_b_item.Cat_ID"]["edit"] = array("table" => "PO_Loc_B_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["po_loc_b_item.Item_Code"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["po_loc_b_item.Item_Code"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["po_loc_b_item.Item_Code"]["edit"] = array("table" => "PO_Loc_B_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_loc_f_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_loc_f_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_loc_f_head.TitleID"]["edit"] = array("table" => "PO_Loc_F_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_loc_f_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_loc_f_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_loc_f_head.SupID"]["edit"] = array("table" => "PO_Loc_F_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_loc_f_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_loc_f_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_loc_f_head.Paymt_Term"]["edit"] = array("table" => "PO_Loc_F_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_loc_f_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_loc_f_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_loc_f_head.Currency"]["edit"] = array("table" => "PO_Loc_F_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_loc_c_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_loc_c_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_loc_c_head.TitleID"]["edit"] = array("table" => "PO_Loc_C_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_loc_c_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_loc_c_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_loc_c_head.SupID"]["edit"] = array("table" => "PO_Loc_C_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_loc_c_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_loc_c_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_loc_c_head.Paymt_Term"]["edit"] = array("table" => "PO_Loc_C_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_loc_c_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_loc_c_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_loc_c_head.Currency"]["edit"] = array("table" => "PO_Loc_C_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["po_loc_c_item.Cat_ID"] )) {
			$lookupTableLinks["Parts"]["po_loc_c_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts"]["po_loc_c_item.Cat_ID"]["edit"] = array("table" => "PO_Loc_C_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["po_loc_c_item.Item_Code"] )) {
			$lookupTableLinks["ST_Item"]["po_loc_c_item.Item_Code"] = array();
		}
		$lookupTableLinks["ST_Item"]["po_loc_c_item.Item_Code"]["edit"] = array("table" => "PO_Loc_C_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["po_loc_c_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["po_loc_c_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["po_loc_c_item.Unit"]["edit"] = array("table" => "PO_Loc_C_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_loc_a_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_loc_a_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_loc_a_head.TitleID"]["edit"] = array("table" => "PO_Loc_A_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_loc_a_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_loc_a_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_loc_a_head.SupID"]["edit"] = array("table" => "PO_Loc_A_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_loc_a_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_loc_a_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_loc_a_head.Paymt_Term"]["edit"] = array("table" => "PO_Loc_A_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_loc_a_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_loc_a_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_loc_a_head.Currency"]["edit"] = array("table" => "PO_Loc_A_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["po_loc_a_item.Cat_ID"] )) {
			$lookupTableLinks["Assets_Group"]["po_loc_a_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Assets_Group"]["po_loc_a_item.Cat_ID"]["edit"] = array("table" => "PO_Loc_A_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Item"] ) ) {
			$lookupTableLinks["Assets_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Item"]["po_loc_a_item.Item_Code"] )) {
			$lookupTableLinks["Assets_Item"]["po_loc_a_item.Item_Code"] = array();
		}
		$lookupTableLinks["Assets_Item"]["po_loc_a_item.Item_Code"]["edit"] = array("table" => "PO_Loc_A_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["po_loc_a_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["po_loc_a_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["po_loc_a_item.Unit"]["edit"] = array("table" => "PO_Loc_A_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Time_Period"] ) ) {
			$lookupTableLinks["Time_Period"] = array();
		}
		if( !isset( $lookupTableLinks["Time_Period"]["po_loc_a_item.time_period"] )) {
			$lookupTableLinks["Time_Period"]["po_loc_a_item.time_period"] = array();
		}
		$lookupTableLinks["Time_Period"]["po_loc_a_item.time_period"]["edit"] = array("table" => "PO_Loc_A_Item", "field" => "time_period", "page" => "edit");
		if( !isset( $lookupTableLinks["BD_Model"] ) ) {
			$lookupTableLinks["BD_Model"] = array();
		}
		if( !isset( $lookupTableLinks["BD_Model"]["pc_head.Model_No"] )) {
			$lookupTableLinks["BD_Model"]["pc_head.Model_No"] = array();
		}
		$lookupTableLinks["BD_Model"]["pc_head.Model_No"]["edit"] = array("table" => "PC_Head", "field" => "Model_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Factory"] ) ) {
			$lookupTableLinks["Factory"] = array();
		}
		if( !isset( $lookupTableLinks["Factory"]["ibws_head_inv.Tittle"] )) {
			$lookupTableLinks["Factory"]["ibws_head_inv.Tittle"] = array();
		}
		$lookupTableLinks["Factory"]["ibws_head_inv.Tittle"]["edit"] = array("table" => "Ibws_Head_Inv", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_r_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_r_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_r_head.TitleID"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["BL_Shipper"] ) ) {
			$lookupTableLinks["BL_Shipper"] = array();
		}
		if( !isset( $lookupTableLinks["BL_Shipper"]["po_imp_r_head.SupID"] )) {
			$lookupTableLinks["BL_Shipper"]["po_imp_r_head.SupID"] = array();
		}
		$lookupTableLinks["BL_Shipper"]["po_imp_r_head.SupID"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright_new"] ) ) {
			$lookupTableLinks["Fright_new"] = array();
		}
		if( !isset( $lookupTableLinks["Fright_new"]["po_imp_r_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright_new"]["po_imp_r_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright_new"]["po_imp_r_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["po_imp_r_head.Isseude_By2"] )) {
			$lookupTableLinks["webusers"]["po_imp_r_head.Isseude_By2"] = array();
		}
		$lookupTableLinks["webusers"]["po_imp_r_head.Isseude_By2"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Isseude_By2", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_r_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_r_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_r_head.Destination"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_r_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_r_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_r_head.Port"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_r_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_r_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_r_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_r_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_r_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_r_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_r_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_r_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_r_head.Currency"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Replcement_Req_Head"] ) ) {
			$lookupTableLinks["Replcement_Req_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request"] )) {
			$lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request"] = array();
		}
		$lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Rep_request", "page" => "edit");
		if( !isset( $lookupTableLinks["Replcement_Req_Head"] ) ) {
			$lookupTableLinks["Replcement_Req_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request1"] )) {
			$lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request1"] = array();
		}
		$lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request1"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Rep_request1", "page" => "edit");
		if( !isset( $lookupTableLinks["Replcement_Req_Head"] ) ) {
			$lookupTableLinks["Replcement_Req_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request2"] )) {
			$lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request2"] = array();
		}
		$lookupTableLinks["Replcement_Req_Head"]["po_imp_r_head.Rep_request2"]["edit"] = array("table" => "PO_Imp_R_Head", "field" => "Rep_request2", "page" => "edit");
		if( !isset( $lookupTableLinks["Replacement_Item"] ) ) {
			$lookupTableLinks["Replacement_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Replacement_Item"]["po_imp_r_item.Item_Code"] )) {
			$lookupTableLinks["Replacement_Item"]["po_imp_r_item.Item_Code"] = array();
		}
		$lookupTableLinks["Replacement_Item"]["po_imp_r_item.Item_Code"]["edit"] = array("table" => "PO_Imp_R_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["po_imp_r_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["po_imp_r_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["po_imp_r_item.Unit"]["edit"] = array("table" => "PO_Imp_R_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["po_imp_r_item.Pc_NO"] )) {
			$lookupTableLinks["Sc_Head"]["po_imp_r_item.Pc_NO"] = array();
		}
		$lookupTableLinks["Sc_Head"]["po_imp_r_item.Pc_NO"]["edit"] = array("table" => "PO_Imp_R_Item", "field" => "Pc_NO", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["po_imp_r_item.Ref_Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["po_imp_r_item.Ref_Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["po_imp_r_item.Ref_Seq_No"]["edit"] = array("table" => "PO_Imp_R_Item", "field" => "Ref_Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["imp_r_remarks.Shippingmarks"] )) {
			$lookupTableLinks["Shipping_Marks"]["imp_r_remarks.Shippingmarks"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["imp_r_remarks.Shippingmarks"]["edit"] = array("table" => "Imp_R_Remarks", "field" => "Shippingmarks", "page" => "edit");
		if( !isset( $lookupTableLinks["Item_Unit"] ) ) {
			$lookupTableLinks["Item_Unit"] = array();
		}
		if( !isset( $lookupTableLinks["Item_Unit"]["replacement_item.Unit"] )) {
			$lookupTableLinks["Item_Unit"]["replacement_item.Unit"] = array();
		}
		$lookupTableLinks["Item_Unit"]["replacement_item.Unit"]["edit"] = array("table" => "Replacement_Item", "field" => "Unit", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["paint_head.Sc_No"] )) {
			$lookupTableLinks["Sc_Head"]["paint_head.Sc_No"] = array();
		}
		$lookupTableLinks["Sc_Head"]["paint_head.Sc_No"]["edit"] = array("table" => "Paint_Head", "field" => "Sc_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["paint_head.Cus_ID"] )) {
			$lookupTableLinks["Customer"]["paint_head.Cus_ID"] = array();
		}
		$lookupTableLinks["Customer"]["paint_head.Cus_ID"]["edit"] = array("table" => "Paint_Head", "field" => "Cus_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item"] ) ) {
			$lookupTableLinks["ST_Item"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item"]["paint_item.Paint_Item"] )) {
			$lookupTableLinks["ST_Item"]["paint_item.Paint_Item"] = array();
		}
		$lookupTableLinks["ST_Item"]["paint_item.Paint_Item"]["edit"] = array("table" => "Paint_Item", "field" => "Paint_Item", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["paint_item.Cat_ID"] )) {
			$lookupTableLinks["Parts"]["paint_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts"]["paint_item.Cat_ID"]["edit"] = array("table" => "Paint_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_rc_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_rc_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_rc_head.TitleID"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Factory"] ) ) {
			$lookupTableLinks["Factory"] = array();
		}
		if( !isset( $lookupTableLinks["Factory"]["po_imp_rc_head.SupID"] )) {
			$lookupTableLinks["Factory"]["po_imp_rc_head.SupID"] = array();
		}
		$lookupTableLinks["Factory"]["po_imp_rc_head.SupID"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright_new"] ) ) {
			$lookupTableLinks["Fright_new"] = array();
		}
		if( !isset( $lookupTableLinks["Fright_new"]["po_imp_rc_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright_new"]["po_imp_rc_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright_new"]["po_imp_rc_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["po_imp_rc_head.Isseude_By2"] )) {
			$lookupTableLinks["webusers"]["po_imp_rc_head.Isseude_By2"] = array();
		}
		$lookupTableLinks["webusers"]["po_imp_rc_head.Isseude_By2"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "Isseude_By2", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_rc_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_rc_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_rc_head.Destination"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_rc_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_rc_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_rc_head.Port"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_rc_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_rc_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_rc_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_rc_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_rc_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_rc_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_rc_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_rc_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_rc_head.Currency"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["po_imp_rc_head.Cus_ID"] )) {
			$lookupTableLinks["Customer"]["po_imp_rc_head.Cus_ID"] = array();
		}
		$lookupTableLinks["Customer"]["po_imp_rc_head.Cus_ID"]["edit"] = array("table" => "PO_Imp_Rc_Head", "field" => "Cus_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Replacement_Item"] ) ) {
			$lookupTableLinks["Replacement_Item"] = array();
		}
		if( !isset( $lookupTableLinks["Replacement_Item"]["po_imp_rc_item.Item_Code"] )) {
			$lookupTableLinks["Replacement_Item"]["po_imp_rc_item.Item_Code"] = array();
		}
		$lookupTableLinks["Replacement_Item"]["po_imp_rc_item.Item_Code"]["edit"] = array("table" => "PO_Imp_Rc_Item", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Sc_Head"] ) ) {
			$lookupTableLinks["Sc_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Sc_Head"]["po_imp_rc_item.Pc_NO"] )) {
			$lookupTableLinks["Sc_Head"]["po_imp_rc_item.Pc_NO"] = array();
		}
		$lookupTableLinks["Sc_Head"]["po_imp_rc_item.Pc_NO"]["edit"] = array("table" => "PO_Imp_Rc_Item", "field" => "Pc_NO", "page" => "edit");
		if( !isset( $lookupTableLinks["SC_Item"] ) ) {
			$lookupTableLinks["SC_Item"] = array();
		}
		if( !isset( $lookupTableLinks["SC_Item"]["po_imp_rc_item.Seq_No"] )) {
			$lookupTableLinks["SC_Item"]["po_imp_rc_item.Seq_No"] = array();
		}
		$lookupTableLinks["SC_Item"]["po_imp_rc_item.Seq_No"]["edit"] = array("table" => "PO_Imp_Rc_Item", "field" => "Seq_No", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["imp_rc_remarks.Ship_marks"] )) {
			$lookupTableLinks["Shipping_Marks"]["imp_rc_remarks.Ship_marks"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["imp_rc_remarks.Ship_marks"]["edit"] = array("table" => "Imp_Rc_Remarks", "field" => "Ship_marks", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["psi_imp_rc_main.To"] )) {
			$lookupTableLinks["Customer"]["psi_imp_rc_main.To"] = array();
		}
		$lookupTableLinks["Customer"]["psi_imp_rc_main.To"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["psi_imp_rc_main.From"] )) {
			$lookupTableLinks["webusers"]["psi_imp_rc_main.From"] = array();
		}
		$lookupTableLinks["webusers"]["psi_imp_rc_main.From"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "From", "page" => "edit");
		if( !isset( $lookupTableLinks["RCConsignee"] ) ) {
			$lookupTableLinks["RCConsignee"] = array();
		}
		if( !isset( $lookupTableLinks["RCConsignee"]["psi_imp_rc_main.Consignee"] )) {
			$lookupTableLinks["RCConsignee"]["psi_imp_rc_main.Consignee"] = array();
		}
		$lookupTableLinks["RCConsignee"]["psi_imp_rc_main.Consignee"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "Consignee", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["psi_imp_rc_main.Customer"] )) {
			$lookupTableLinks["Customer"]["psi_imp_rc_main.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["psi_imp_rc_main.Customer"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["psi_imp_rc_main.NotifyID"] )) {
			$lookupTableLinks["Title"]["psi_imp_rc_main.NotifyID"] = array();
		}
		$lookupTableLinks["Title"]["psi_imp_rc_main.NotifyID"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "NotifyID", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["psi_imp_rc_main.FowarderID"] )) {
			$lookupTableLinks["Forwaders"]["psi_imp_rc_main.FowarderID"] = array();
		}
		$lookupTableLinks["Forwaders"]["psi_imp_rc_main.FowarderID"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "FowarderID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright_new"] ) ) {
			$lookupTableLinks["Fright_new"] = array();
		}
		if( !isset( $lookupTableLinks["Fright_new"]["psi_imp_rc_main.TPTType"] )) {
			$lookupTableLinks["Fright_new"]["psi_imp_rc_main.TPTType"] = array();
		}
		$lookupTableLinks["Fright_new"]["psi_imp_rc_main.TPTType"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "TPTType", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["psi_imp_rc_main.Destination"] )) {
			$lookupTableLinks["Destinations"]["psi_imp_rc_main.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["psi_imp_rc_main.Destination"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["psi_imp_rc_main.PaymentType"] )) {
			$lookupTableLinks["Payterms_new"]["psi_imp_rc_main.PaymentType"] = array();
		}
		$lookupTableLinks["Payterms_new"]["psi_imp_rc_main.PaymentType"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "PaymentType", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["psi_imp_rc_main.Currency"] )) {
			$lookupTableLinks["Currency"]["psi_imp_rc_main.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["psi_imp_rc_main.Currency"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["psi_imp_rc_main.Inv_Currency"] )) {
			$lookupTableLinks["Currency"]["psi_imp_rc_main.Inv_Currency"] = array();
		}
		$lookupTableLinks["Currency"]["psi_imp_rc_main.Inv_Currency"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "Inv_Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Rc_List"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_Rc_List"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Rc_List"]["psi_imp_rc_head.PONUM"] )) {
			$lookupTableLinks["PO_PSI_Imp_Rc_List"]["psi_imp_rc_head.PONUM"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_Rc_List"]["psi_imp_rc_head.PONUM"]["edit"] = array("table" => "PSI_Imp_Rc_Head", "field" => "PONUM", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Rc"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_Rc"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Rc"]["psi_imp_rc_item.SNo"] )) {
			$lookupTableLinks["PO_PSI_Imp_Rc"]["psi_imp_rc_item.SNo"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_Rc"]["psi_imp_rc_item.SNo"]["edit"] = array("table" => "PSI_Imp_Rc_Item", "field" => "SNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_rim_head.Tittle"] )) {
			$lookupTableLinks["Title"]["pi_imp_rim_head.Tittle"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_rim_head.Tittle"]["edit"] = array("table" => "PI_Imp_Rim_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["pi_imp_rim_head.Customer"] )) {
			$lookupTableLinks["Customer"]["pi_imp_rim_head.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["pi_imp_rim_head.Customer"]["edit"] = array("table" => "PI_Imp_Rim_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_rim_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_rim_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_rim_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_Rim_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_rc_head.Tittle"] )) {
			$lookupTableLinks["Title"]["pi_imp_rc_head.Tittle"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_rc_head.Tittle"]["edit"] = array("table" => "PI_Imp_Rc_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["pi_imp_rc_head.Customer"] )) {
			$lookupTableLinks["Customer"]["pi_imp_rc_head.Customer"] = array();
		}
		$lookupTableLinks["Customer"]["pi_imp_rc_head.Customer"]["edit"] = array("table" => "PI_Imp_Rc_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_rc_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_rc_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_rc_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_Rc_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Agent_Master"] ) ) {
			$lookupTableLinks["Agent_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Agent_Master"]["pi_imp_rc_head.Cust_Agent"] )) {
			$lookupTableLinks["Agent_Master"]["pi_imp_rc_head.Cust_Agent"] = array();
		}
		$lookupTableLinks["Agent_Master"]["pi_imp_rc_head.Cust_Agent"]["edit"] = array("table" => "PI_Imp_Rc_Head", "field" => "Cust_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_a_main.To"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_a_main.To"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_a_main.To"]["edit"] = array("table" => "PSI_Imp_A_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_A_List"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_A_List"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_A_List"]["psi_imp_a_head.PONUM"] )) {
			$lookupTableLinks["PO_PSI_Imp_A_List"]["psi_imp_a_head.PONUM"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_A_List"]["psi_imp_a_head.PONUM"]["edit"] = array("table" => "PSI_Imp_A_Head", "field" => "PONUM", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_A"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_A"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_A"]["psi_imp_a_item.SNo"] )) {
			$lookupTableLinks["PO_PSI_Imp_A"]["psi_imp_a_item.SNo"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_A"]["psi_imp_a_item.SNo"]["edit"] = array("table" => "PSI_Imp_A_Item", "field" => "SNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["pi_imp_a_head.Tittle"] )) {
			$lookupTableLinks["Supplier"]["pi_imp_a_head.Tittle"] = array();
		}
		$lookupTableLinks["Supplier"]["pi_imp_a_head.Tittle"]["edit"] = array("table" => "PI_Imp_A_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_a_head.Customer"] )) {
			$lookupTableLinks["Title"]["pi_imp_a_head.Customer"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_a_head.Customer"]["edit"] = array("table" => "PI_Imp_A_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_a_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_a_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_a_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_A_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["pi_imp_a_head.Clear_Agent"] )) {
			$lookupTableLinks["Forwaders"]["pi_imp_a_head.Clear_Agent"] = array();
		}
		$lookupTableLinks["Forwaders"]["pi_imp_a_head.Clear_Agent"]["edit"] = array("table" => "PI_Imp_A_Head", "field" => "Clear_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Assets_Group"] ) ) {
			$lookupTableLinks["Assets_Group"] = array();
		}
		if( !isset( $lookupTableLinks["Assets_Group"]["pi_imp_a_item.Cat_ID"] )) {
			$lookupTableLinks["Assets_Group"]["pi_imp_a_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Assets_Group"]["pi_imp_a_item.Cat_ID"]["edit"] = array("table" => "PI_Imp_A_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["pi_imp_a_rmks.ShpMarks1"] )) {
			$lookupTableLinks["Shipping_Marks"]["pi_imp_a_rmks.ShpMarks1"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["pi_imp_a_rmks.ShpMarks1"]["edit"] = array("table" => "PI_Imp_A_Rmks", "field" => "ShpMarks1", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_c_main.To"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_c_main.To"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_c_main.To"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["psi_imp_c_main.Consignee"] )) {
			$lookupTableLinks["Title"]["psi_imp_c_main.Consignee"] = array();
		}
		$lookupTableLinks["Title"]["psi_imp_c_main.Consignee"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "Consignee", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["psi_imp_c_main.Notify"] )) {
			$lookupTableLinks["Title"]["psi_imp_c_main.Notify"] = array();
		}
		$lookupTableLinks["Title"]["psi_imp_c_main.Notify"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "Notify", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["psi_imp_c_main.Forwarder"] )) {
			$lookupTableLinks["Forwaders"]["psi_imp_c_main.Forwarder"] = array();
		}
		$lookupTableLinks["Forwaders"]["psi_imp_c_main.Forwarder"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "Forwarder", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["psi_imp_c_main.TPTType"] )) {
			$lookupTableLinks["Fright"]["psi_imp_c_main.TPTType"] = array();
		}
		$lookupTableLinks["Fright"]["psi_imp_c_main.TPTType"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "TPTType", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["psi_imp_c_main.Destination"] )) {
			$lookupTableLinks["Destinations"]["psi_imp_c_main.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["psi_imp_c_main.Destination"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["psi_imp_c_main.PaymentType"] )) {
			$lookupTableLinks["Payterms_new"]["psi_imp_c_main.PaymentType"] = array();
		}
		$lookupTableLinks["Payterms_new"]["psi_imp_c_main.PaymentType"]["edit"] = array("table" => "PSI_Imp_C_Main", "field" => "PaymentType", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_C_List"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_C_List"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_C_List"]["psi_imp_c_head.PONUM"] )) {
			$lookupTableLinks["PO_PSI_Imp_C_List"]["psi_imp_c_head.PONUM"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_C_List"]["psi_imp_c_head.PONUM"]["edit"] = array("table" => "PSI_Imp_C_Head", "field" => "PONUM", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_C"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_C"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_C"]["psi_imp_c_item.SNo"] )) {
			$lookupTableLinks["PO_PSI_Imp_C"]["psi_imp_c_item.SNo"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_C"]["psi_imp_c_item.SNo"]["edit"] = array("table" => "PSI_Imp_C_Item", "field" => "SNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["pi_imp_c_head.Tittle"] )) {
			$lookupTableLinks["Supplier"]["pi_imp_c_head.Tittle"] = array();
		}
		$lookupTableLinks["Supplier"]["pi_imp_c_head.Tittle"]["edit"] = array("table" => "PI_Imp_C_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_c_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_c_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_c_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_C_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["pi_imp_c_head.Currency"] )) {
			$lookupTableLinks["Currency"]["pi_imp_c_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["pi_imp_c_head.Currency"]["edit"] = array("table" => "PI_Imp_C_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_c_head.Customer"] )) {
			$lookupTableLinks["Title"]["pi_imp_c_head.Customer"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_c_head.Customer"]["edit"] = array("table" => "PI_Imp_C_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["pi_imp_c_head.Clear_Agent"] )) {
			$lookupTableLinks["Forwaders"]["pi_imp_c_head.Clear_Agent"] = array();
		}
		$lookupTableLinks["Forwaders"]["pi_imp_c_head.Clear_Agent"]["edit"] = array("table" => "PI_Imp_C_Head", "field" => "Clear_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["pi_imp_c_item.Cat_ID"] )) {
			$lookupTableLinks["Parts"]["pi_imp_c_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts"]["pi_imp_c_item.Cat_ID"]["edit"] = array("table" => "PI_Imp_C_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["pi_imp_c_rmks.ShpMarks1"] )) {
			$lookupTableLinks["Shipping_Marks"]["pi_imp_c_rmks.ShpMarks1"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["pi_imp_c_rmks.ShpMarks1"]["edit"] = array("table" => "PI_Imp_C_Rmks", "field" => "ShpMarks1", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_r_main.To"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_r_main.To"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_r_main.To"]["edit"] = array("table" => "PSI_Imp_R_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["psi_imp_r_main.PaymentType"] )) {
			$lookupTableLinks["Payterms_new"]["psi_imp_r_main.PaymentType"] = array();
		}
		$lookupTableLinks["Payterms_new"]["psi_imp_r_main.PaymentType"]["edit"] = array("table" => "PSI_Imp_R_Main", "field" => "PaymentType", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_R_List"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_R_List"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_R_List"]["psi_imp_r_head.PONUM"] )) {
			$lookupTableLinks["PO_PSI_Imp_R_List"]["psi_imp_r_head.PONUM"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_R_List"]["psi_imp_r_head.PONUM"]["edit"] = array("table" => "PSI_Imp_R_Head", "field" => "PONUM", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_R"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_R"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_R"]["psi_imp_r_item.SNo"] )) {
			$lookupTableLinks["PO_PSI_Imp_R"]["psi_imp_r_item.SNo"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_R"]["psi_imp_r_item.SNo"]["edit"] = array("table" => "PSI_Imp_R_Item", "field" => "SNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Factory"] ) ) {
			$lookupTableLinks["Factory"] = array();
		}
		if( !isset( $lookupTableLinks["Factory"]["pi_imp_r_head.Tittle"] )) {
			$lookupTableLinks["Factory"]["pi_imp_r_head.Tittle"] = array();
		}
		$lookupTableLinks["Factory"]["pi_imp_r_head.Tittle"]["edit"] = array("table" => "PI_Imp_R_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_r_head.Customer"] )) {
			$lookupTableLinks["Title"]["pi_imp_r_head.Customer"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_r_head.Customer"]["edit"] = array("table" => "PI_Imp_R_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_r_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_r_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_r_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_R_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["pi_imp_r_head.Currency"] )) {
			$lookupTableLinks["Currency"]["pi_imp_r_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["pi_imp_r_head.Currency"]["edit"] = array("table" => "PI_Imp_R_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["pi_imp_r_head.Clear_Agent"] )) {
			$lookupTableLinks["Forwaders"]["pi_imp_r_head.Clear_Agent"] = array();
		}
		$lookupTableLinks["Forwaders"]["pi_imp_r_head.Clear_Agent"]["edit"] = array("table" => "PI_Imp_R_Head", "field" => "Clear_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["pi_imp_r_rmks.ShpMarks1"] )) {
			$lookupTableLinks["Shipping_Marks"]["pi_imp_r_rmks.ShpMarks1"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["pi_imp_r_rmks.ShpMarks1"]["edit"] = array("table" => "PI_Imp_R_Rmks", "field" => "ShpMarks1", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_b_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_b_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_b_head.TitleID"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_imp_b_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_imp_b_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_imp_b_head.SupID"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["po_imp_b_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright"]["po_imp_b_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright"]["po_imp_b_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["webusers"] ) ) {
			$lookupTableLinks["webusers"] = array();
		}
		if( !isset( $lookupTableLinks["webusers"]["po_imp_b_head.Isseude_By2"] )) {
			$lookupTableLinks["webusers"]["po_imp_b_head.Isseude_By2"] = array();
		}
		$lookupTableLinks["webusers"]["po_imp_b_head.Isseude_By2"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "Isseude_By2", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_b_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_b_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_b_head.Destination"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_b_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_b_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_b_head.Port"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_b_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_b_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_b_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_b_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_b_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_b_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_b_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_b_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_b_head.Currency"]["edit"] = array("table" => "PO_Imp_B_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts31"] ) ) {
			$lookupTableLinks["Parts31"] = array();
		}
		if( !isset( $lookupTableLinks["Parts31"]["po_imp_b_item.Cat_ID"] )) {
			$lookupTableLinks["Parts31"]["po_imp_b_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts31"]["po_imp_b_item.Cat_ID"]["edit"] = array("table" => "PO_Imp_B_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["po_imp_b_item.Item_Codechain"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["po_imp_b_item.Item_Codechain"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["po_imp_b_item.Item_Codechain"]["edit"] = array("table" => "PO_Imp_B_Item", "field" => "Item_Codechain", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["po_imp_b_item.Item_Codeother"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["po_imp_b_item.Item_Codeother"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["po_imp_b_item.Item_Codeother"]["edit"] = array("table" => "PO_Imp_B_Item", "field" => "Item_Codeother", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["imp_b_remarks.Ship_marks"] )) {
			$lookupTableLinks["Shipping_Marks"]["imp_b_remarks.Ship_marks"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["imp_b_remarks.Ship_marks"]["edit"] = array("table" => "Imp_B_Remarks", "field" => "Ship_marks", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_b_main.To"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_b_main.To"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_b_main.To"]["edit"] = array("table" => "PSI_Imp_B_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["psi_imp_b_main.PaymentType"] )) {
			$lookupTableLinks["Payterms_new"]["psi_imp_b_main.PaymentType"] = array();
		}
		$lookupTableLinks["Payterms_new"]["psi_imp_b_main.PaymentType"]["edit"] = array("table" => "PSI_Imp_B_Main", "field" => "PaymentType", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_B_List"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_B_List"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_B_List"]["psi_imp_b_head.PONUM"] )) {
			$lookupTableLinks["PO_PSI_Imp_B_List"]["psi_imp_b_head.PONUM"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_B_List"]["psi_imp_b_head.PONUM"]["edit"] = array("table" => "PSI_Imp_B_Head", "field" => "PONUM", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_B"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_B"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_B"]["psi_imp_b_item.SNo"] )) {
			$lookupTableLinks["PO_PSI_Imp_B"]["psi_imp_b_item.SNo"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_B"]["psi_imp_b_item.SNo"]["edit"] = array("table" => "PSI_Imp_B_Item", "field" => "SNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["pi_imp_b_head.Tittle"] )) {
			$lookupTableLinks["Supplier"]["pi_imp_b_head.Tittle"] = array();
		}
		$lookupTableLinks["Supplier"]["pi_imp_b_head.Tittle"]["edit"] = array("table" => "PI_Imp_B_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_b_head.Customer"] )) {
			$lookupTableLinks["Title"]["pi_imp_b_head.Customer"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_b_head.Customer"]["edit"] = array("table" => "PI_Imp_B_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_b_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_b_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_b_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_B_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["pi_imp_b_head.Currency"] )) {
			$lookupTableLinks["Currency"]["pi_imp_b_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["pi_imp_b_head.Currency"]["edit"] = array("table" => "PI_Imp_B_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["pi_imp_b_head.Clear_Agent"] )) {
			$lookupTableLinks["Forwaders"]["pi_imp_b_head.Clear_Agent"] = array();
		}
		$lookupTableLinks["Forwaders"]["pi_imp_b_head.Clear_Agent"]["edit"] = array("table" => "PI_Imp_B_Head", "field" => "Clear_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Ref_Sc_Iniinput"] ) ) {
			$lookupTableLinks["Ref_Sc_Iniinput"] = array();
		}
		if( !isset( $lookupTableLinks["Ref_Sc_Iniinput"]["pi_imp_b_item.Cat_ID"] )) {
			$lookupTableLinks["Ref_Sc_Iniinput"]["pi_imp_b_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Ref_Sc_Iniinput"]["pi_imp_b_item.Cat_ID"]["edit"] = array("table" => "PI_Imp_B_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["pi_imp_b_rmks.ShpMarks1"] )) {
			$lookupTableLinks["Shipping_Marks"]["pi_imp_b_rmks.ShpMarks1"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["pi_imp_b_rmks.ShpMarks1"]["edit"] = array("table" => "PI_Imp_B_Rmks", "field" => "ShpMarks1", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts"] ) ) {
			$lookupTableLinks["Parts"] = array();
		}
		if( !isset( $lookupTableLinks["Parts"]["pi_imp_b_item_ex.Cat_ID"] )) {
			$lookupTableLinks["Parts"]["pi_imp_b_item_ex.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts"]["pi_imp_b_item_ex.Cat_ID"]["edit"] = array("table" => "PI_Imp_B_Item_Ex", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["ST_Item_Bulk"] ) ) {
			$lookupTableLinks["ST_Item_Bulk"] = array();
		}
		if( !isset( $lookupTableLinks["ST_Item_Bulk"]["pi_imp_b_item_ex.Item_Code"] )) {
			$lookupTableLinks["ST_Item_Bulk"]["pi_imp_b_item_ex.Item_Code"] = array();
		}
		$lookupTableLinks["ST_Item_Bulk"]["pi_imp_b_item_ex.Item_Code"]["edit"] = array("table" => "PI_Imp_B_Item_Ex", "field" => "Item_Code", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["po_imp_f_head.TitleID"] )) {
			$lookupTableLinks["Title"]["po_imp_f_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["po_imp_f_head.TitleID"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["po_imp_f_head.SupID"] )) {
			$lookupTableLinks["Supplier"]["po_imp_f_head.SupID"] = array();
		}
		$lookupTableLinks["Supplier"]["po_imp_f_head.SupID"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "SupID", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["po_imp_f_head.SHPG_Mode"] )) {
			$lookupTableLinks["Fright"]["po_imp_f_head.SHPG_Mode"] = array();
		}
		$lookupTableLinks["Fright"]["po_imp_f_head.SHPG_Mode"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "SHPG_Mode", "page" => "edit");
		if( !isset( $lookupTableLinks["Destinations"] ) ) {
			$lookupTableLinks["Destinations"] = array();
		}
		if( !isset( $lookupTableLinks["Destinations"]["po_imp_f_head.Destination"] )) {
			$lookupTableLinks["Destinations"]["po_imp_f_head.Destination"] = array();
		}
		$lookupTableLinks["Destinations"]["po_imp_f_head.Destination"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Destination", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["po_imp_f_head.SHPG_Term"] )) {
			$lookupTableLinks["Pc_Terms"]["po_imp_f_head.SHPG_Term"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["po_imp_f_head.SHPG_Term"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "SHPG_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Loading_Ports"] ) ) {
			$lookupTableLinks["Loading_Ports"] = array();
		}
		if( !isset( $lookupTableLinks["Loading_Ports"]["po_imp_f_head.Port"] )) {
			$lookupTableLinks["Loading_Ports"]["po_imp_f_head.Port"] = array();
		}
		$lookupTableLinks["Loading_Ports"]["po_imp_f_head.Port"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Port", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["po_imp_f_head.Paymt_Term"] )) {
			$lookupTableLinks["Payterms_new"]["po_imp_f_head.Paymt_Term"] = array();
		}
		$lookupTableLinks["Payterms_new"]["po_imp_f_head.Paymt_Term"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Paymt_Term", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["po_imp_f_head.Currency"] )) {
			$lookupTableLinks["Currency"]["po_imp_f_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["po_imp_f_head.Currency"]["edit"] = array("table" => "PO_Imp_F_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Paint_Head"] ) ) {
			$lookupTableLinks["Paint_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Paint_Head"]["po_imp_f_item.PCNo"] )) {
			$lookupTableLinks["Paint_Head"]["po_imp_f_item.PCNo"] = array();
		}
		$lookupTableLinks["Paint_Head"]["po_imp_f_item.PCNo"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "PCNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Paint_Head"] ) ) {
			$lookupTableLinks["Paint_Head"] = array();
		}
		if( !isset( $lookupTableLinks["Paint_Head"]["po_imp_f_item.SeqNo"] )) {
			$lookupTableLinks["Paint_Head"]["po_imp_f_item.SeqNo"] = array();
		}
		$lookupTableLinks["Paint_Head"]["po_imp_f_item.SeqNo"]["edit"] = array("table" => "PO_Imp_F_Item", "field" => "SeqNo", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts3"] ) ) {
			$lookupTableLinks["Parts3"] = array();
		}
		if( !isset( $lookupTableLinks["Parts3"]["po_imp_f_itemdata.Cat_ID"] )) {
			$lookupTableLinks["Parts3"]["po_imp_f_itemdata.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts3"]["po_imp_f_itemdata.Cat_ID"]["edit"] = array("table" => "PO_Imp_F_ItemData", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["imp_paint_remarks.Ship_marks"] )) {
			$lookupTableLinks["Shipping_Marks"]["imp_paint_remarks.Ship_marks"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["imp_paint_remarks.Ship_marks"]["edit"] = array("table" => "Imp_Paint_Remarks", "field" => "Ship_marks", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_paint_main.To"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_paint_main.To"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_paint_main.To"]["edit"] = array("table" => "PSI_Imp_Paint_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["Fright"] ) ) {
			$lookupTableLinks["Fright"] = array();
		}
		if( !isset( $lookupTableLinks["Fright"]["psi_imp_paint_main.TPTType"] )) {
			$lookupTableLinks["Fright"]["psi_imp_paint_main.TPTType"] = array();
		}
		$lookupTableLinks["Fright"]["psi_imp_paint_main.TPTType"]["edit"] = array("table" => "PSI_Imp_Paint_Main", "field" => "TPTType", "page" => "edit");
		if( !isset( $lookupTableLinks["Payterms_new"] ) ) {
			$lookupTableLinks["Payterms_new"] = array();
		}
		if( !isset( $lookupTableLinks["Payterms_new"]["psi_imp_paint_main.PaymentType"] )) {
			$lookupTableLinks["Payterms_new"]["psi_imp_paint_main.PaymentType"] = array();
		}
		$lookupTableLinks["Payterms_new"]["psi_imp_paint_main.PaymentType"]["edit"] = array("table" => "PSI_Imp_Paint_Main", "field" => "PaymentType", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Paint_List"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_Paint_List"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Paint_List"]["psi_imp_paint_head.PONUM"] )) {
			$lookupTableLinks["PO_PSI_Imp_Paint_List"]["psi_imp_paint_head.PONUM"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_Paint_List"]["psi_imp_paint_head.PONUM"]["edit"] = array("table" => "PSI_Imp_Paint_Head", "field" => "PONUM", "page" => "edit");
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Paint"] ) ) {
			$lookupTableLinks["PO_PSI_Imp_Paint"] = array();
		}
		if( !isset( $lookupTableLinks["PO_PSI_Imp_Paint"]["psi_imp_paint_item.CUSPAR"] )) {
			$lookupTableLinks["PO_PSI_Imp_Paint"]["psi_imp_paint_item.CUSPAR"] = array();
		}
		$lookupTableLinks["PO_PSI_Imp_Paint"]["psi_imp_paint_item.CUSPAR"]["edit"] = array("table" => "PSI_Imp_Paint_Item", "field" => "CUSPAR", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["pi_imp_paint_head.Tittle"] )) {
			$lookupTableLinks["Supplier"]["pi_imp_paint_head.Tittle"] = array();
		}
		$lookupTableLinks["Supplier"]["pi_imp_paint_head.Tittle"]["edit"] = array("table" => "PI_Imp_Paint_Head", "field" => "Tittle", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["pi_imp_paint_head.Customer"] )) {
			$lookupTableLinks["Title"]["pi_imp_paint_head.Customer"] = array();
		}
		$lookupTableLinks["Title"]["pi_imp_paint_head.Customer"]["edit"] = array("table" => "PI_Imp_Paint_Head", "field" => "Customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Pc_Terms"] ) ) {
			$lookupTableLinks["Pc_Terms"] = array();
		}
		if( !isset( $lookupTableLinks["Pc_Terms"]["pi_imp_paint_head.ShipTerm"] )) {
			$lookupTableLinks["Pc_Terms"]["pi_imp_paint_head.ShipTerm"] = array();
		}
		$lookupTableLinks["Pc_Terms"]["pi_imp_paint_head.ShipTerm"]["edit"] = array("table" => "PI_Imp_Paint_Head", "field" => "ShipTerm", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["pi_imp_paint_head.Currency"] )) {
			$lookupTableLinks["Currency"]["pi_imp_paint_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["pi_imp_paint_head.Currency"]["edit"] = array("table" => "PI_Imp_Paint_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Forwaders"] ) ) {
			$lookupTableLinks["Forwaders"] = array();
		}
		if( !isset( $lookupTableLinks["Forwaders"]["pi_imp_paint_head.Clear_Agent"] )) {
			$lookupTableLinks["Forwaders"]["pi_imp_paint_head.Clear_Agent"] = array();
		}
		$lookupTableLinks["Forwaders"]["pi_imp_paint_head.Clear_Agent"]["edit"] = array("table" => "PI_Imp_Paint_Head", "field" => "Clear_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Parts3"] ) ) {
			$lookupTableLinks["Parts3"] = array();
		}
		if( !isset( $lookupTableLinks["Parts3"]["pi_imp_paint_item.Cat_ID"] )) {
			$lookupTableLinks["Parts3"]["pi_imp_paint_item.Cat_ID"] = array();
		}
		$lookupTableLinks["Parts3"]["pi_imp_paint_item.Cat_ID"]["edit"] = array("table" => "PI_Imp_Paint_Item", "field" => "Cat_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Shipping_Marks"] ) ) {
			$lookupTableLinks["Shipping_Marks"] = array();
		}
		if( !isset( $lookupTableLinks["Shipping_Marks"]["pi_imp_paint_rmks.ShpMarks1"] )) {
			$lookupTableLinks["Shipping_Marks"]["pi_imp_paint_rmks.ShpMarks1"] = array();
		}
		$lookupTableLinks["Shipping_Marks"]["pi_imp_paint_rmks.ShpMarks1"]["edit"] = array("table" => "PI_Imp_Paint_Rmks", "field" => "ShpMarks1", "page" => "edit");
}

?>