<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["po_bulk_pay.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["po_bulk_pay.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["po_bulk_pay.Bank_Name"]["edit"] = array("table" => "Po_Bulk_Pay", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_b_main.Sup_ID"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_b_main.Sup_ID"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_b_main.Sup_ID"]["edit"] = array("table" => "PSI_Imp_B_Main", "field" => "Sup_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_f_main.Sup_ID"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_f_main.Sup_ID"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_f_main.Sup_ID"]["edit"] = array("table" => "PSI_Imp_F_Main", "field" => "Sup_ID", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["po_fixed_pay.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["po_fixed_pay.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["po_fixed_pay.Bank_Name"]["edit"] = array("table" => "Po_Fixed_Pay", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["po_con_pay.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["po_con_pay.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["po_con_pay.Bank_Name"]["edit"] = array("table" => "Po_Con_Pay", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["psi_imp_rc_main.To"] )) {
			$lookupTableLinks["Customer"]["psi_imp_rc_main.To"] = array();
		}
		$lookupTableLinks["Customer"]["psi_imp_rc_main.To"]["edit"] = array("table" => "PSI_Imp_Rc_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["Supplier"] ) ) {
			$lookupTableLinks["Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Supplier"]["psi_imp_r_main.To"] )) {
			$lookupTableLinks["Supplier"]["psi_imp_r_main.To"] = array();
		}
		$lookupTableLinks["Supplier"]["psi_imp_r_main.To"]["edit"] = array("table" => "PSI_Imp_R_Main", "field" => "To", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["po_paint_pay.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["po_paint_pay.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["po_paint_pay.Bank_Name"]["edit"] = array("table" => "Po_Paint_Pay", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["po_rc_pay.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["po_rc_pay.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["po_rc_pay.Bank_Name"]["edit"] = array("table" => "Po_Rc_Pay", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["po_repl_pay.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["po_repl_pay.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["po_repl_pay.Bank_Name"]["edit"] = array("table" => "Po_Repl_Pay", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["bd_reimbursement.Cust"] )) {
			$lookupTableLinks["Customer"]["bd_reimbursement.Cust"] = array();
		}
		$lookupTableLinks["Customer"]["bd_reimbursement.Cust"]["edit"] = array("table" => "BD_Reimbursement", "field" => "Cust", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["acc_drcr_credit_head.CUST"] )) {
			$lookupTableLinks["Customer"]["acc_drcr_credit_head.CUST"] = array();
		}
		$lookupTableLinks["Customer"]["acc_drcr_credit_head.CUST"]["edit"] = array("table" => "Acc_DrCr_Credit_Head", "field" => "CUST", "page" => "edit");
		if( !isset( $lookupTableLinks["Combine_FTY_Supplier"] ) ) {
			$lookupTableLinks["Combine_FTY_Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Combine_FTY_Supplier"]["acc_drcr_credit_head.FTY"] )) {
			$lookupTableLinks["Combine_FTY_Supplier"]["acc_drcr_credit_head.FTY"] = array();
		}
		$lookupTableLinks["Combine_FTY_Supplier"]["acc_drcr_credit_head.FTY"]["edit"] = array("table" => "Acc_DrCr_Credit_Head", "field" => "FTY", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["acc_drcr_credit_head.Currency"] )) {
			$lookupTableLinks["Currency"]["acc_drcr_credit_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["acc_drcr_credit_head.Currency"]["edit"] = array("table" => "Acc_DrCr_Credit_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["acc_drcr_debit_head.TitleID"] )) {
			$lookupTableLinks["Title"]["acc_drcr_debit_head.TitleID"] = array();
		}
		$lookupTableLinks["Title"]["acc_drcr_debit_head.TitleID"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "TitleID", "page" => "edit");
		if( !isset( $lookupTableLinks["Customer"] ) ) {
			$lookupTableLinks["Customer"] = array();
		}
		if( !isset( $lookupTableLinks["Customer"]["acc_drcr_debit_head.CUST"] )) {
			$lookupTableLinks["Customer"]["acc_drcr_debit_head.CUST"] = array();
		}
		$lookupTableLinks["Customer"]["acc_drcr_debit_head.CUST"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "CUST", "page" => "edit");
		if( !isset( $lookupTableLinks["Combine_FTY_Supplier"] ) ) {
			$lookupTableLinks["Combine_FTY_Supplier"] = array();
		}
		if( !isset( $lookupTableLinks["Combine_FTY_Supplier"]["acc_drcr_debit_head.FTY"] )) {
			$lookupTableLinks["Combine_FTY_Supplier"]["acc_drcr_debit_head.FTY"] = array();
		}
		$lookupTableLinks["Combine_FTY_Supplier"]["acc_drcr_debit_head.FTY"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "FTY", "page" => "edit");
		if( !isset( $lookupTableLinks["Currency"] ) ) {
			$lookupTableLinks["Currency"] = array();
		}
		if( !isset( $lookupTableLinks["Currency"]["acc_drcr_debit_head.Currency"] )) {
			$lookupTableLinks["Currency"]["acc_drcr_debit_head.Currency"] = array();
		}
		$lookupTableLinks["Currency"]["acc_drcr_debit_head.Currency"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "Currency", "page" => "edit");
		if( !isset( $lookupTableLinks["Acc_DrCr_Base"] ) ) {
			$lookupTableLinks["Acc_DrCr_Base"] = array();
		}
		if( !isset( $lookupTableLinks["Acc_DrCr_Base"]["acc_drcr_debit_head.Payment_To"] )) {
			$lookupTableLinks["Acc_DrCr_Base"]["acc_drcr_debit_head.Payment_To"] = array();
		}
		$lookupTableLinks["Acc_DrCr_Base"]["acc_drcr_debit_head.Payment_To"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "Payment_To", "page" => "edit");
		if( !isset( $lookupTableLinks["Merchandiser"] ) ) {
			$lookupTableLinks["Merchandiser"] = array();
		}
		if( !isset( $lookupTableLinks["Merchandiser"]["acc_drcr_debit_head.officer"] )) {
			$lookupTableLinks["Merchandiser"]["acc_drcr_debit_head.officer"] = array();
		}
		$lookupTableLinks["Merchandiser"]["acc_drcr_debit_head.officer"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "officer", "page" => "edit");
		if( !isset( $lookupTableLinks["Agent_Master"] ) ) {
			$lookupTableLinks["Agent_Master"] = array();
		}
		if( !isset( $lookupTableLinks["Agent_Master"]["acc_drcr_debit_head.Customer_Agent"] )) {
			$lookupTableLinks["Agent_Master"]["acc_drcr_debit_head.Customer_Agent"] = array();
		}
		$lookupTableLinks["Agent_Master"]["acc_drcr_debit_head.Customer_Agent"]["edit"] = array("table" => "Acc_DrCr_Debit_Head", "field" => "Customer_Agent", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category_TW"] ) ) {
			$lookupTableLinks["Utility_Category_TW"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category_TW"]["utility_head_tw.Category"] )) {
			$lookupTableLinks["Utility_Category_TW"]["utility_head_tw.Category"] = array();
		}
		$lookupTableLinks["Utility_Category_TW"]["utility_head_tw.Category"]["edit"] = array("table" => "Utility_Head_TW", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_SubCategory_TW"] ) ) {
			$lookupTableLinks["Utility_SubCategory_TW"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_SubCategory_TW"]["utility_head_tw.Sub_Category"] )) {
			$lookupTableLinks["Utility_SubCategory_TW"]["utility_head_tw.Sub_Category"] = array();
		}
		$lookupTableLinks["Utility_SubCategory_TW"]["utility_head_tw.Sub_Category"]["edit"] = array("table" => "Utility_Head_TW", "field" => "Sub_Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category_TW"] ) ) {
			$lookupTableLinks["Utility_Category_TW"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category_TW"]["utility_budget_item_tw.Category"] )) {
			$lookupTableLinks["Utility_Category_TW"]["utility_budget_item_tw.Category"] = array();
		}
		$lookupTableLinks["Utility_Category_TW"]["utility_budget_item_tw.Category"]["edit"] = array("table" => "Utility_Budget_Item_TW", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_SubCategory_TW"] ) ) {
			$lookupTableLinks["Utility_SubCategory_TW"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_SubCategory_TW"]["utility_budget_item_tw.Subcategory"] )) {
			$lookupTableLinks["Utility_SubCategory_TW"]["utility_budget_item_tw.Subcategory"] = array();
		}
		$lookupTableLinks["Utility_SubCategory_TW"]["utility_budget_item_tw.Subcategory"]["edit"] = array("table" => "Utility_Budget_Item_TW", "field" => "Subcategory", "page" => "edit");
		if( !isset( $lookupTableLinks["Utility_Category_TW"] ) ) {
			$lookupTableLinks["Utility_Category_TW"] = array();
		}
		if( !isset( $lookupTableLinks["Utility_Category_TW"]["utility_subcategory_tw.Category"] )) {
			$lookupTableLinks["Utility_Category_TW"]["utility_subcategory_tw.Category"] = array();
		}
		$lookupTableLinks["Utility_Category_TW"]["utility_subcategory_tw.Category"]["edit"] = array("table" => "Utility_SubCategory_TW", "field" => "Category", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["freight_ibws.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["freight_ibws.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["freight_ibws.Bank_Name"]["edit"] = array("table" => "Freight_IBWS", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["cash_flow_cashinhand_item.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_cashinhand_item.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_cashinhand_item.Bank_Name"]["edit"] = array("table" => "Cash_Flow_CashInHand_Item", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["cash_flow_incomeothers.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_incomeothers.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_incomeothers.Bank_Name"]["edit"] = array("table" => "Cash_Flow_IncomeOthers", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Title"] ) ) {
			$lookupTableLinks["Title"] = array();
		}
		if( !isset( $lookupTableLinks["Title"]["cash_flow_payments_expences.Office_Name"] )) {
			$lookupTableLinks["Title"]["cash_flow_payments_expences.Office_Name"] = array();
		}
		$lookupTableLinks["Title"]["cash_flow_payments_expences.Office_Name"]["edit"] = array("table" => "Cash_Flow_Payments_Expences", "field" => "Office_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["cash_flow_payments_expences.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_payments_expences.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_payments_expences.Bank_Name"]["edit"] = array("table" => "Cash_Flow_Payments_Expences", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["cash_flow_othersexpence.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_othersexpence.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_othersexpence.Bank_Name"]["edit"] = array("table" => "Cash_Flow_OthersExpence", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["cash_flow_loan.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_loan.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["cash_flow_loan.Bank_Name"]["edit"] = array("table" => "Cash_Flow_Loan", "field" => "Bank_Name", "page" => "edit");
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"] ) ) {
			$lookupTableLinks["Cash_Flow_Banks"] = array();
		}
		if( !isset( $lookupTableLinks["Cash_Flow_Banks"]["ibws_payment_main.Bank_Name"] )) {
			$lookupTableLinks["Cash_Flow_Banks"]["ibws_payment_main.Bank_Name"] = array();
		}
		$lookupTableLinks["Cash_Flow_Banks"]["ibws_payment_main.Bank_Name"]["edit"] = array("table" => "IBWS_Payment_Main", "field" => "Bank_Name", "page" => "edit");
}

?>